/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import static com.l2jserver.gameserver.util.GameTimeFunction.*;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;

/**
 * Lair of Antharas AI.
 * @author St3eT, UnAfraid
 */
public final class LairOfAntharas extends AbstractNpcAI
{
	// NPC
	final private static int KNORIKS = 22857;				// n̏@ NmNX
	final private static int DRAGON_KNIGHT = 22844;			// hS pC^
	final private static int DRAGON_KNIGHT2 = 22845;		// hS pC^
	final private static int ELITE_DRAGON_KNIGHT = 22846;	// G[g hS pC^
	
	final private static int DRAGON_GUARD = 22852;			// hS K[h
	final private static int DRAGON_MAGE = 22853;			// hS CW
	// Misc
	final private static int KNIGHT_CHANCE = 70;
	private static final int KNORIKS_SHOUT_INTERVAL = 90; //+[JOJO]
	
	private LairOfAntharas()
	{
		super(LairOfAntharas.class.getSimpleName(), "ai/group_template");
		addKillId(DRAGON_KNIGHT, DRAGON_KNIGHT2);
		addSpawnId(DRAGON_KNIGHT, DRAGON_KNIGHT2, DRAGON_GUARD, DRAGON_MAGE);
		addAggroRangeEnterId(KNORIKS);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		// DRAGON_GUARD | DRAGON_MAGE
		if (event == "CHECK_HOME")
		{
			if (npc.isDead() || !npc.isVisible())
			{
				cancelQuestTimer(event, npc, player);
			}
			else if (npc.hasAI() && !npc.isInCombat() && !npc.isMoving())
			{
				if (npc.calculateDistance(npc.getSpawn().getLocation(), false, false) > 10)
				{
					((L2Attackable) npc).returnHome();
				}
				else if (npc.getHeading() != npc.getSpawn().getHeading())
				{
					npc.setHeading(npc.getSpawn().getHeading());
					npc.broadcastPacket(new ValidateLocation(npc));
				}
			}
		}
		return super.onAdvEvent(event, npc, player);
	}
	
	@Override
	public String onAggroRangeEnter(L2Npc npc, L2PcInstance player, boolean isSummon)
	{
		// KNORIKS
		if (npc.getAI().getIntention() != CtrlIntention.AI_INTENTION_ATTACK)
		{
			final int now = currentTime();
			if (npc.getScriptValue() < now)
			{
				npc.setScriptValue(now + KNORIKS_SHOUT_INTERVAL);
				broadcastNpcSay(npc, Say2.NPC_SHOUT, NpcStringId.WHOS_THERE_IF_YOU_DISTURB_THE_TEMPER_OF_THE_GREAT_LAND_DRAGON_ANTHARAS_I_WILL_NEVER_FORGIVE_YOU);
			}
		}
		return super.onAggroRangeEnter(npc, player, isSummon);
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		switch (npc.getId())
		{
			case DRAGON_KNIGHT:
			{
				if (getRandom(100) < KNIGHT_CHANCE)
				{
					final L2Attackable newKnight = (L2Attackable) addSpawn(DRAGON_KNIGHT2, npc.getPosition(), false, 0, true);
					npc.deleteMe();
					broadcastNpcSay(newKnight, Say2.NPC_SHOUT, NpcStringId.THOSE_WHO_SET_FOOT_IN_THIS_PLACE_SHALL_NOT_LEAVE_ALIVE);
					attackPlayer(newKnight, killer);
				}
				break;
			}
			case DRAGON_KNIGHT2:
			{
				if (getRandom(100) < KNIGHT_CHANCE)
				{
					final L2Attackable eliteKnight = (L2Attackable) addSpawn(ELITE_DRAGON_KNIGHT, npc.getPosition(), false, 0, true);
					npc.deleteMe();
					broadcastNpcSay(eliteKnight, Say2.NPC_SHOUT, NpcStringId.IF_YOU_WISH_TO_SEE_HELL_I_WILL_GRANT_YOU_YOUR_WISH);
					attackPlayer(eliteKnight, killer);
				}
				break;
			}
		}
		return super.onKill(npc, killer, isSummon);
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		switch (npc.getNpcId())
		{
			case DRAGON_KNIGHT:
			case DRAGON_KNIGHT2:
				((L2Attackable) npc).setOnKillDelay(0);
				break;
			case DRAGON_GUARD:
			case DRAGON_MAGE:
				npc.setIsNoRndWalk(true);
				startQuestTimer("CHECK_HOME", 10000, npc, null, true);
				break;
			default:
				throw new RuntimeException();
		}
		return super.onSpawn(npc);
	}
	
	public static void main(String[] args)
	{
		new LairOfAntharas();
	}
}