/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import static com.l2jserver.gameserver.util.GameTimeFunction.*;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;

/**
 * Warrior Fishing Block AI.
 * @author Zoey76
 */
public final class WarriorFishingBlock extends AbstractNpcAI
{
	//@formatter:off
	// NPC Strings
	private static final int
		NPC_STRINGS_ON_SPAWN = 0,
		NPC_STRINGS_ON_ATTACK = 1,
		NPC_STRINGS_ON_KILL = 2;
	
	// fishingMonsters.xml
	private static final SortedIntObjectArrayMap<int[][]> NPC_STRINGS = new SortedIntObjectArrayMap<int[][]>()
		.append(18319, new int[][]{	// Caught Frog ނꂽJG
			{
				1010400, // PPbIȂƂ$s1ȂāIH
				1010401, // $s1AˁI
				1010402, // ނԈႦČA$s1I
			},
			{
				1010403, // JGÂႢB
				1010404, // JG̗͂Ă낤I
				1010405, // ňݍłI
			},
			{
				1010406, // StbDDD̃IlʂȂāI
				1010407, // QRQRIJGEI
				1010408, // JG͔ȂłIB
			}
		})
		.append(18320, new int[][]{	// Caught Undine ނꂽEfB[l
			{
				1010409, // ႠI$s1ÂH
				1010410, // ӂӂA$s1̑̂ɏȂāBo͂łĂł傤ˁH
				1010411, // A$s1 Ȃ̂ˁBłˁAȍrۂ҂ɊԏȂĂȂH
			},
			{
				1010412, // {点ˁI
				1010413, // ̏AǂĂ̂IH
				1010414, // 񂽂ڂɂ킹ĂII
			},
			{
				1010415, // ႠIˁAoĂႢI
				1010416, // Ȃ̃GT͐HׂȂāA̋Ɍӂ炵ĂI
				1010417, // ݂Ȃア߂ȂāDDDB
			}
		})
		.append(18321, new int[][]{	// Caught Rakul ނꂽN
			{
				1010418, // PPPDDD$s1DDDHׂ邼DDDPPbDDD
				1010419, // ODDDDDD$s1DDD߂DDDǂDDD
				1010420, // $s1HPzbDDDODDDObDDD
			},
			{
				1010421, // NPPPPINIXsIA^AAAAAbNI
				1010422, // IpvIIII
				1010423, // NINI@@NDDDDI
			},
			{
				1010424, // NGFDDD݁DDDDDD
				1010425, // HꂽȂDDDOA@
				1010426, // OnbINIPzbPzbIOGFDDD
			}
		})
		.append(18322, new int[][]{	// Caught Sea Giant ނꂽV[WCAg
			{
				1010427, // pvIɉhI$s1ɂ͎I
				1010428, // $s1AOỈ߂Ă̂́I
				1010429, // lI$s1Ɏ􂢂I
			},
			{
				1010430, // WCAg XyV A^bNI
				1010431, // ݂̍vmI
				1010432, // ̑HĂ݂I
			},
			{
				1010433, // pvIlɉhI
				1010434, // ͂I
				1010435, // V͎ȂDDD̂݁DDD
			}
		})
		.append(18323, new int[][]{	// Caught Sea Horse Soldier ނꂽV[z[X \W[
			{
				1010436, // $s1A̐̋Rm̒󂯂I
				1010437, // ̕񍐂ɂ$s1I
				1010438, // $s1A킦̂͂񂽂̃GT̂I
			},
			{
				1010439, // {d݂̑pI
				1010440, // 񂽂ɑŊ̃v[gI
				1010441, // 񂽂̃GT͎|IႠȁI
			},
			{
				1010442, // I䂪E݂̍I
				1010443, // oĂI̋w͂ƒNDDD
				1010444, // OtbDDDOɂ͕߂܂ȂI
			}
		})
		.append(18324, new int[][]{	// Caught Homunculus ނꂽzNX
			{
				1010445, // $s1ADDD
				1010446, // $s1A[Cɂ鉴ނグȂāDDD
				1010447, // $s1AɌ邩B
			},
			{
				1010448, // ͂قЂ`
				1010449, // NNNbAǂA񂪂ĂĂ낤B
				1010450, // oĖfĂ񂾂H
			},
			{
				1010451, // ЂDDDɂDDDĂĂĂĂI
				1010452, // `FbAsDDD̂ɁB
				1010453, // DDD~DDDWWbDDD
			},
		})
		.append(18325, new int[][]{	// Caught Flava ނꂽt@
			{
				1010454, // NbI$s1`Nb|[B
				1010455, // $s1̓邼I
				1010456, // ȁA$s1I
			},
			{
				1010457, // HĂ邼I
				1010458, // ււցAvԂɂGTȁI
				1010459, // OȂ񂩈I
			},
			{
				1010460, // DDDGTɂȂāI
				1010461, // Õ͉GTȂ񂾂I߂ĐHĂI
				1010462, // GTɐHȂāDDDNbDDD
			},
		})
		.append(18326, new int[][]{	// Caught Gigantic Eye ނꂽ
			{
				1010463, // ނ̂$s1H
				1010464, // ɉƂhɎvA$s1B
				1010465, // $s1AċAȂĂۂvȂقB
			},
			{
				1010466, // [̗͂ƂƌDDD
				1010467, // ̒ނƂւ܂ĂDDD
				1010468, // Ml̎ŕẢDDD
			},
			{
				1010469, // ̒ނtȂ̂DDD
				1010470, // pvI|Ȃ̂DDD
				1010471, // f炵AJ߂Ă邼DDD
			},
		});
	// Misc
	private static final int CHANCE_TO_SHOUT_ON_ATTACK = 33;
	private static final int MINIMAL_SHOUT_INTERVAL = 7; //[JOJO] 8 seconds
	private static final int DESPAWN_TIME = 50; // 50 seconds to despawn
	
	public WarriorFishingBlock()
	{
		super(WarriorFishingBlock.class.getSimpleName(), "ai/group_template");
		int[] MONSTERS = NPC_STRINGS.keySet();
		addAttackId(MONSTERS);
		addKillId(MONSTERS);
		addSpawnId(MONSTERS);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		switch (event)
		{
			case "SPAWN":
			{
				final L2Object obj = npc.getTarget();
				if ((obj == null) || !obj.isPlayer())
				{
					npc.deleteMe();
					return super.onSpawn(npc);
				}
				else
				{
					final L2PcInstance target = obj.getActingPlayer();
					
					final int now = currentTime();
					npc.setScriptValue(now + MINIMAL_SHOUT_INTERVAL);
					int[] npcStringId = NPC_STRINGS.get(npc.getId())[NPC_STRINGS_ON_SPAWN];
					npc.broadcastPacket(new NpcSay(npc, Say2.NPC_ALL, npcStringId[getRandom(npcStringId.length)])
					.addPcName(target));
					((L2Attackable) npc).addDamageHate(target, 0, 2000);
					npc.getAI().notifyEvent(CtrlEvent.EVT_ATTACKED, target);
					npc.addAttackerToAttackByList(target);
					startQuestTimer("DESPAWN", DESPAWN_TIME * 1000, npc, target);
				}
				break;
			}
			case "DESPAWN":
			{
				npc.deleteMe();
				break;
			}
		}
		return super.onAdvEvent(event, npc, player);
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon)
	{
		final int now = currentTime();
		if (npc.getScriptValue() < now && getRandom(100) < CHANCE_TO_SHOUT_ON_ATTACK)
		{
			npc.setScriptValue(now + MINIMAL_SHOUT_INTERVAL);
			int[] npcStringId = NPC_STRINGS.get(npc.getId())[NPC_STRINGS_ON_ATTACK];
			npc.broadcastPacket(new NpcSay(npc, Say2.NPC_ALL, npcStringId[getRandom(npcStringId.length)]));
		}
		return super.onAttack(npc, attacker, damage, isSummon);
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		int[] npcStringId = NPC_STRINGS.get(npc.getId())[NPC_STRINGS_ON_KILL];
		npc.broadcastPacket(new NpcSay(npc, Say2.NPC_ALL, npcStringId[getRandom(npcStringId.length)]));
		cancelQuestTimer("DESPAWN", npc, killer);
		return super.onKill(npc, killer, isSummon);
	}
	
	@Override
	public String onSpawn(L2Npc npc)	// <-- L2Fishing#spawnMonster
	{
		startQuestTimer("SPAWN", 2000, npc, null);
		return super.onSpawn(npc);
	}
	
	public static void main(String[] args)
	{
		new WarriorFishingBlock();
	}
}
