/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.Teleports.TeleportToFantasy;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.clientpackets.Say2;

/**
 * Fantasy Island teleport AI.
 * @author Plim
 */
public final class TeleportToFantasy extends AbstractNpcAI
{
	// NPC
	private static final int PADDIES = 32378;
	private static final int[] TELEPORTERS =
	{
	/*id*/    -1,
	/* 1*/ 30320,	// Richlin	1.O[fB̑
	/* 2*/ 30256,	// Bella	2.O[fBȊ
	/* 3*/ 30059,	// Trisha	3.fBȊ
	/* 4*/ 30080,	// Clarissa	4.M̑
	/* 5*/ 30899,	// Flauen	5.ssnClX
	/* 6*/ 30177,	// Valentina	6.I[̑
	/* 7*/ 30848,	// Elisa	7.Af̑
	/* 8*/ 30233,	// Esmeralda	8.t̑
	/* 9*/ 31320,	// Ilyana	9.O[fB̑
	/*10*/ 31275,	// Tatiana	10.S_[h̑
	/*11*/ 31964,	// Bilia	11.V`bcKg̑
	};
	// Locations
	private static final Location RUNE_TOWNSHIP = new Location(43835, -47749, -792);
	private static final Location[] RETURN_LOCATIONS =
	{
	/*id*/ null,
	/* 1*/ new Location(-80826, 149775, -3043),
	/* 2*/ new Location(-12672, 122776, -3116),
	/* 3*/ new Location(15670, 142983, -2705),
	/* 4*/ new Location(83400, 147943, -3404),
	/* 5*/ new Location(111409, 219364, -3545),
	/* 6*/ new Location(82956, 53162, -1495),
	/* 7*/ new Location(146331, 25762, -2018),
	/* 8*/ new Location(116819, 76994, -2714),
	/* 9*/ new Location(43835, -47749, -792),
	/*10*/ new Location(147930, -55281, -2728),
	/*11*/ new Location(87386, -143246, -1293),
	};
	private static final Location[] ISLE_LOCATIONS =
	{
		new Location(-58752, -56898, -2032),
		new Location(-59716, -57868, -2032),
		new Location(-60691, -56893, -2032),
		new Location(-59720, -55921, -2032)
	};
	// Player Variables
	private static final String FANTASY_RETURN = "FANTASY_RETURN";
	
	private TeleportToFantasy()
	{
		super(TeleportToFantasy.class.getSimpleName(), "ai/npc/Teleports");
		addStartNpc(PADDIES);
		addStartNpc(TELEPORTERS);
		addTalkId(PADDIES);
		addTalkId(TELEPORTERS);
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		if (npc.getId() == PADDIES)
		{
			final int returnId = player.getVariables().getInt(FANTASY_RETURN, -1);
			
			if (0 < returnId && returnId < RETURN_LOCATIONS.length)
			{
				player.teleToLocation(RETURN_LOCATIONS[returnId]);
			}
			else
			{
				broadcastNpcSay(npc, Say2.ALL, NpcStringId.IF_YOUR_MEANS_OF_ARRIVAL_WAS_A_BIT_UNCONVENTIONAL_THEN_ILL_BE_SENDING_YOU_BACK_TO_RUNE_TOWNSHIP_WHICH_IS_THE_NEAREST_TOWN);
				player.teleToLocation(RUNE_TOWNSHIP);
			}
			player.getVariables().remove(FANTASY_RETURN);
		}
		else
		{
			final int teleportId = com.l2jserver.gameserver.util.Util.indexOf(TELEPORTERS, npc.getId());
			
			player.teleToLocation(ISLE_LOCATIONS[getRandom(ISLE_LOCATIONS.length)]);
			player.getVariables().set(FANTASY_RETURN, String.valueOf(teleportId));
		}
		return super.onTalk(npc, player);
	}
	
	public static void main(String[] args)
	{
		new TeleportToFantasy();
	}
}
