/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.Teleports.TeleportToRaceTrack;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;

/**
 * Monster Derby Track teleport AI.
 * @author Plim
 */
public final class TeleportToRaceTrack extends AbstractNpcAI
{
	// NPC
	private static final int RACE_MANAGER = 30995;
	private static final int[] TELEPORTERS =
	{
	/*id*/    -1,
	/* 1*/ 30320,	// Richlin	1.O[fB̑
	/* 2*/ 30256,	// Bella	2.O[fBȊ
	/* 3*/ 30059,	// Trisha	3.fBȊ
	/* 4*/ 30080,	// Clarissa	4.M̑
	/* 5*/ 30899,	// Flauen	5.ssnClX
	/* 6*/ 30177,	// Valentina	6.I[̑
	/* 7*/ 30848,	// Elisa	7.Af̑
	/* 8*/ 30233,	// Esmeralda	8.t̑
	/* 9*/ 31320,	// Ilyana	9.O[fB̑
	/*10*/ 31275,	// Tatiana	10.S_[h̑
	/*11*/ 31964,	// Bilia	11.V`bcKg̑
	/*12*/ 31210,	// Race Track GK	11.X^[[X(O)
	};
	// Locations
	private static final Location DION_CASTLE_TOWN = new Location(15670, 142983, -2700);
	private static final Location[] RETURN_LOCATIONS =
	{
	/*id*/ null,
	/* 1*/ new Location(-80826, 149775, -3043),
	/* 2*/ new Location(-12672, 122776, -3116),
	/* 3*/ new Location(15670, 142983, -2705),
	/* 4*/ new Location(83400, 147943, -3404),
	/* 5*/ new Location(111409, 219364, -3545),
	/* 6*/ new Location(82956, 53162, -1495),
	/* 7*/ new Location(146331, 25762, -2018),
	/* 8*/ new Location(116819, 76994, -2714),
	/* 9*/ new Location(43835, -47749, -792),
	/*10*/ new Location(147930, -55281, -2728),
	/*11*/ new Location(87386, -143246, -1293),
	/*12*/ new Location(12882, 181053, -3560)
	};
	private static final Location RACE_TRACK_LOCATION = new Location(12661, 181687, -3560);
	// Player Variables
	private static final String MONSTER_RETURN = "MONSTER_RETURN";
	
	private TeleportToRaceTrack()
	{
		super(TeleportToRaceTrack.class.getSimpleName(), "ai/npc/Teleports");
		addStartNpc(RACE_MANAGER);
		addStartNpc(TELEPORTERS);
		addTalkId(RACE_MANAGER);
		addTalkId(TELEPORTERS);
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		if (npc.getId() == RACE_MANAGER)
		{
			final int returnId = player.getVariables().getInt(MONSTER_RETURN, -1);
			
			if (0 < returnId && returnId < RETURN_LOCATIONS.length)
			{
				player.teleToLocation(RETURN_LOCATIONS[returnId]);
			}
			else
			{
				player.sendPacket(new NpcSay(npc.getObjectId(), 0, npc.getId(), "H܂ňႤ@ŗ́HꂶA߂̃fCȊ֑ĂˁB"));
			//	player.sendPacket(new NpcSay(npc.getObjectId(), 0, npc.getId(), "You've arrived here from a different way. I'll send you to Dion Castle Town which is the nearest town."));
				player.teleToLocation(DION_CASTLE_TOWN);
			}
			player.getVariables().remove(MONSTER_RETURN);
		}
		else
		{
			if (player.isInCombat()) return null;	//+[JOJO] X^[[Xɓ̂h
			
			final int teleportId = com.l2jserver.gameserver.util.Util.indexOf(TELEPORTERS, npc.getId());
			
			player.teleToLocation(RACE_TRACK_LOCATION);
			player.getVariables().set(MONSTER_RETURN, String.valueOf(teleportId));
		}
		return super.onTalk(npc, player);
	}
	
	public static void main(String[] args)
	{
		new TeleportToRaceTrack();
	}
}
