/*
 * Copyright (C) 2005-2008 L2J_JP / 2008-2013 L2J-SFJP
 * 
 * This file is part of L2J Server.
 * 
 * L2J Server is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J Server is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package custom.DimensionalMerchants;

import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;

/**
 * ngT|[g Ȅl
 * @author JOJO@L2J-SFJP
 *
 * ֘At@C:
../../../../../datapack_development/data/summon_items.csv
 */

public class DimensionalMerchants extends Quest
{
	private static final String qn = "DimensionalMerchants";
	private static final int DIMENSIONAL_MERCHANT = 32478;	//Ȅl

	private DimensionalMerchants()
	{
		super(-1, qn, "custom");
		addStartNpc(DIMENSIONAL_MERCHANT);
		addTalkId(DIMENSIONAL_MERCHANT);
		addFirstTalkId(DIMENSIONAL_MERCHANT);
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		String htmltext = event;
		QuestState st = player.getQuestState(qn);

		if (event.matches("\\d+"))
		{
			int amuletId = Integer.parseInt(event);
			switch (amuletId)
			{
			case 13017: //ng T|[g A~bgFzCg tFbg		 16045 zCg tFbg
			case 13018: //ng T|[g A~bgFtFA[ vZX	 16046 tFA[ vZX
			case 13019: //ng T|[g A~bgFr[Xg t@C^[		 16044 r[Xg t@C^[
			case 13020: //ng T|[g A~bgFtHbNX EBU[h	 16043 tHbNX EBU[h
			case 13548: //gCiCg ng T|[g A~bg				 16052 gC iCg
			case 13549: //Xsbg }WV ng T|[g A~bg	 16051 Xsbg EBU[h
			case 13550: //AE EBU[h ng T|[g A~bg		 16050 AE EBU[h
			case 13551: //^[g }X^[ ng T|[g A~bg		 16053 ^[g }X^[
				//13385 ng T|[g 1pbNFCxg
				if (tryTakeItems(player, 13385, 1))
				{
					giveItems(player, amuletId, 1);
					htmltext = "32478-ok.htm";
				}
				//13384 ng T|[g 3pbNFCxg
				else if (tryTakeItems(player, 13384, 1))
				{
					giveItems(player, amuletId, 1);
					giveItems(player, 13385, 2);	//
					htmltext = "32478-ok.htm";
				}
				//13274 ng T|[gF7
				//13276 ng T|[gF1pbN
				//13273 ng T|[gF5
				else if ( tryTakeItems(player, 13274, 1)
				       || tryTakeItems(player, 13276, 1)
				       || tryTakeItems(player, 13273, 1) )
				{
					giveItems(player, amuletId, 1);
					htmltext = "32478-ok.htm";
				}
				//13275 ng T|[gF3pbN
				else if (tryTakeItems(player, 13275, 1))
				{
					giveItems(player, amuletId, 1);
					giveItems(player, 13276, 2);	//
					htmltext = "32478-ok.htm";
				}
				else
					htmltext = "32478-11.htm";
				break;


			case 14061: //㋉ng T|[g A~bgFgC iCg				 16052 gC iCg
			case 14062: //㋉ng T|[g A~bgFXsbg }WV	 16051 Xsbg EBU[h
			case 14063: //㋉ng T|[g A~bgFAE EBU[h		 16050 AE EBU[h
			case 14064: //㋉ng T|[g A~bgF^[g }X^[		 16053 ^[g }X^[
				//14291 ㋉ng T|[g 1pbNFCxg
				//14074 ㋉ng T|[gFCxg
				if ( tryTakeItems(player, 14291, 1)
				  || tryTakeItems(player, 14074, 1) )
				{
					giveItems(player, amuletId, 1);
					htmltext = "32478-ok.htm";
				}
				//14290 ㋉ng T|[g 2pbNFCxg
				else if (tryTakeItems(player, 14290, 1))
				{
					giveItems(player, amuletId, 1);
					giveItems(player, 14291, 1);	//
					htmltext = "32478-ok.htm";
				}
				//14248 ㋉ng T|[g 1pbN
				//14065 ㋉ng T|[g
				else if ( tryTakeItems(player, 14248, 1)
				       || tryTakeItems(player, 14065, 1) )
				{
					giveItems(player, amuletId, 1);
					htmltext = "32478-ok.htm";
				}
				//14239 ㋉ng T|[g 2pbN
				else if (tryTakeItems(player, 14239, 1))
				{
					giveItems(player, amuletId, 1);
					giveItems(player, 14248, 1);	//
					htmltext = "32478-ok.htm";
				}
				else
					htmltext = "32478-12.htm";
				break;

			default:
				throw new RuntimeException("onAdvEvent("+event+","+npc.getName()+", "+player.getName()+")");
			}
			st.exitQuest(true);
		}
		return htmltext;
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(qn);
		if (st == null)
		{
			Quest q = QuestManager.getInstance().getQuest(qn);
			st = q.newQuestState(player);
		}
		return "32478.htm";
	}

	private boolean tryTakeItems(L2PcInstance player, int itemId, long count)
	{
		if (getQuestItemsCount(player, itemId) >= count) {
			takeItems(player, itemId, count);
			return true;
		}
		return false;
	}

	public static void main(String[] args)
	{
		new DimensionalMerchants();
	}
}