/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package gracia.AI;

import static com.l2jserver.gameserver.datatables.SkillData.*;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.NpcStringId;

import gracia.AI.NPC.Nemo.Nemo;

/**
 * Maguen AI.
 * @author St3eT
 */
public final class Maguen extends AbstractNpcAI
{
	// Rate
	private static final int SPAWN_MAGUEN_CHANCE = 1000;
	private static final int MAGUEN_PET_CHANCE = 10000;
	private static final int ELITE_MAGUEN_PET_CHANCE = 20;
	// NPC
	private static final int MAGUEN = 18839; // Wild Maguen
	private static final int[] ELITES =
	{
		22750, // Elite Bgurent (Bistakon)
		22751, // Elite Brakian (Bistakon)
		22752, // Elite Groikan (Bistakon)
		22753, // Elite Treykan (Bistakon)
		22757, // Elite Turtlelian (Reptilikon)
		22758, // Elite Krajian (Reptilikon)
		22759, // Elite Tardyon (Reptilikon)
		22763, // Elite Kanibi (Kokracon)
		22764, // Elite Kiriona (Kokracon)
		22765, // Elite Kaiona (Kokracon)
	};
	// Item
	private static final int MAGUEN_PET = 15488; // Maguen Pet Collar
	private static final int ELITE_MAGUEN_PET = 15489; // Elite Maguen Pet Collar
	// Skills
	private static final int MACHINE = getSkillHashCode(9060, 1); // Maguen Machine XL: 9060-1 }OG vY}W@ (ACe: 15487 }OG vY}̎W@)
	private static final int B_BUFF_1 = getSkillHashCode(6343, 1); // Maguen Plasma - Power
	private static final int B_BUFF_2 = getSkillHashCode(6343, 2); // Maguen Plasma - Power
	private static final int C_BUFF_1 = getSkillHashCode(6365, 1); // Maguen Plasma - Speed
	private static final int C_BUFF_2 = getSkillHashCode(6365, 2); // Maguen Plasma - Speed
	private static final int R_BUFF_1 = getSkillHashCode(6366, 1); // Maguen Plasma - Critical
	private static final int R_BUFF_2 = getSkillHashCode(6366, 2); // Maguen Plasma - Critical
	private static final int B_PLASMA1 = getSkillHashCode(6367, 1); // Maguen Plasma - Bistakon
	private static final int B_PLASMA2 = getSkillHashCode(6367, 2); // Maguen Plasma - Bistakon
	private static final int B_PLASMA3 = getSkillHashCode(6367, 3); // Maguen Plasma - Bistakon
	private static final int C_PLASMA1 = getSkillHashCode(6368, 1); // Maguen Plasma - Cokrakon
	private static final int C_PLASMA2 = getSkillHashCode(6368, 2); // Maguen Plasma - Cokrakon
	private static final int C_PLASMA3 = getSkillHashCode(6368, 3); // Maguen Plasma - Cokrakon
	private static final int R_PLASMA1 = getSkillHashCode(6369, 1); // Maguen Plasma - Reptilikon
	private static final int R_PLASMA2 = getSkillHashCode(6369, 2); // Maguen Plasma - Reptilikon
	private static final int R_PLASMA3 = getSkillHashCode(6369, 3); // Maguen Plasma - Reptilikon
	
	public Maguen()
	{
		super(Maguen.class.getSimpleName(), "gracia/AI");
		addKillId(ELITES);
		addSkillSeeId(MAGUEN);
		addSpellFinishedId(MAGUEN);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		switch (event)
		{
			case "SPAWN_MAGUEN":
			{
				assert npc.getVariables().getInt("TEST_MAGUEN") == 0;
				final L2Npc maguen = addSpawn(MAGUEN, npc, true, 0, true);
				maguen.getVariables().set("SUMMON_PLAYER", player);
				maguen.setTitle(player.getName());
				maguen.setIsRunning(true);
				maguen.getAI().setIntention(CtrlIntention.AI_INTENTION_FOLLOW, player);
				maguen.broadcastStatusUpdate();
				showOnScreenMsg(player, NpcStringId.MAGUEN_APPEARANCE, 2, 4000);
				startQuestTimer("DIST_CHECK_TIMER", 1000, maguen, player);
				startQuestTimer("DESPAWN", 60000, maguen, player);
				break;
			}
			///////////////////////////
			// Nemo.java Maguen.java //
			///////////////////////////
			case "DIST_CHECK_TIMER": 
			{
				if (npc.isDead() || !npc.isVisible())
				{
					return null;
				}
				if (npc.calculateDistance(player, true, false) < 100 && npc.getVariables().getInt("IS_NEAR_PLAYER") == 0)
				{
					npc.getVariables().set("IS_NEAR_PLAYER", 1);
					startQuestTimer("FIRST_TIMER", 4000, npc, player);
				}
				else
				{
					startQuestTimer("DIST_CHECK_TIMER", 1000, npc, player);
				}
				break;
			}
			case "FIRST_TIMER":
			{
				npc.getAI().stopFollow();
				final int randomEffect = getRandom(1, 3);	// 1:Blue 2:Cyan 3:Red
				npc.setDisplayEffect(randomEffect);
				npc.getVariables().set("NPC_EFFECT", randomEffect);
				startQuestTimer("SECOND_TIMER", 5000 + getRandom(300), npc, player);
				npc.broadcastSocialAction(getRandom(1, 3));
				break;
			}
			case "SECOND_TIMER":
			{
				final int randomEffect = getRandom(1, 3);
				npc.setDisplayEffect(4);
				npc.setDisplayEffect(randomEffect);
				npc.getVariables().set("NPC_EFFECT", randomEffect);
				startQuestTimer("THIRD_TIMER", 4600 + getRandom(600), npc, player);
				npc.broadcastSocialAction(getRandom(1, 3));
				break;
			}
			case "THIRD_TIMER":
			{
				final int randomEffect = getRandom(1, 3);
				npc.setDisplayEffect(4);
				npc.setDisplayEffect(randomEffect);
				npc.getVariables().set("NPC_EFFECT", randomEffect);
				startQuestTimer("FORTH_TIMER", 4200 + getRandom(900), npc, player);
				npc.broadcastSocialAction(getRandom(1, 3));
				break;
			}
			case "FORTH_TIMER":
			{
				npc.getVariables().set("NPC_EFFECT", 0);
				npc.setDisplayEffect(4);
				startQuestTimer("END_TIMER", 500, npc, player);
				npc.broadcastSocialAction(getRandom(1, 3));
				break;
			}
			case "DESPAWN":
			case "END_TIMER":
			{
				if (npc.getVariables().getInt("TEST_MAGUEN") == 1)	// Nemo.java "summonMaguen"
				{
					player.getEffectList().stopSkillEffects(true, getSkill(B_PLASMA1).getAbnormalType());
					player.getEffectList().stopSkillEffects(true, getSkill(C_PLASMA1).getAbnormalType());
					player.getEffectList().stopSkillEffects(true, getSkill(R_PLASMA1).getAbnormalType());
					nemoAi().notifyEvent("DECREASE_COUNT", npc, player);
				}
				npc.doDie(null);
				break;
			}
		}
		return super.onAdvEvent(event, npc, player);
	}
	
	@Override
	public String onSpellFinished(L2Npc npc, L2PcInstance player, Skill skill)
	{
		final AbnormalType B_EFFECT = getSkill(B_PLASMA1).getAbnormalType();	// <set name="abnormalType" val="SOA_BUFF1" />
		final AbnormalType C_EFFECT = getSkill(C_PLASMA1).getAbnormalType();	// <set name="abnormalType" val="SOA_BUFF2" />
		final AbnormalType R_EFFECT = getSkill(R_PLASMA1).getAbnormalType();	// <set name="abnormalType" val="SOA_BUFF3" />
		assert B_EFFECT == AbnormalType.SOA_BUFF1;
		assert C_EFFECT == AbnormalType.SOA_BUFF2;
		assert R_EFFECT == AbnormalType.SOA_BUFF3;
		
		final BuffInfo b_info = player.getEffectList().getBuffInfoByAbnormalType(B_EFFECT);
		final BuffInfo c_info = player.getEffectList().getBuffInfoByAbnormalType(C_EFFECT);
		final BuffInfo r_info = player.getEffectList().getBuffInfoByAbnormalType(R_EFFECT);
		
		final int b = b_info == null ? 0 : b_info.getSkill().getAbnormalLvl();
		final int c = c_info == null ? 0 : c_info.getSkill().getAbnormalLvl();
		final int r = r_info == null ? 0 : r_info.getSkill().getAbnormalLvl();
		
		if (b == 3 && c == 0 && r == 0)
		{
			showOnScreenMsg(player, NpcStringId.ENOUGH_MAGUEN_PLASMA_BISTAKON_HAVE_GATHERED, 2, 4000);
			player.getEffectList().stopSkillEffects(true, B_EFFECT);
			npc.setTarget(player);
			npc.doCast(getSkill(getRandom(100) < 70 ? B_BUFF_1 : B_BUFF_2));
			maguenPetChance(player);
			startQuestTimer("END_TIMER", 3000, npc, player);
		}
		else if (b == 0 && c == 3 && r == 0)
		{
			showOnScreenMsg(player, NpcStringId.ENOUGH_MAGUEN_PLASMA_COKRAKON_HAVE_GATHERED, 2, 4000);
			player.getEffectList().stopSkillEffects(true, C_EFFECT);
			npc.setTarget(player);
			npc.doCast(getSkill(getRandom(100) < 70 ? C_BUFF_1 : C_BUFF_2));
			maguenPetChance(player);
			startQuestTimer("END_TIMER", 3000, npc, player);
		}
		else if (b == 0 && c == 0 && r == 3)
		{
			showOnScreenMsg(player, NpcStringId.ENOUGH_MAGUEN_PLASMA_LEPTILIKON_HAVE_GATHERED, 2, 4000);
			player.getEffectList().stopSkillEffects(true, R_EFFECT);
			npc.setTarget(player);
			npc.doCast(getSkill(getRandom(100) < 70 ? R_BUFF_1 : R_BUFF_2));
			maguenPetChance(player);
			startQuestTimer("END_TIMER", 3000, npc, player);
		}
		else if (b + c + r == 3)
		{
			if (b == 1 && c == 1 && r == 1)
			{
				player.getEffectList().stopSkillEffects(true, B_EFFECT);
				player.getEffectList().stopSkillEffects(true, C_EFFECT);
				player.getEffectList().stopSkillEffects(true, R_EFFECT);
				showOnScreenMsg(player, NpcStringId.THE_PLASMAS_HAVE_FILLED_THE_AEROSCOPE_AND_ARE_HARMONIZED, 2, 4000);
				int skillToCast = 0;
				switch (getRandom(3))
				{
					case 0:
						skillToCast = getRandom(100) < 70 ? B_BUFF_1 : B_BUFF_2;
						break;
					case 1:
						skillToCast = getRandom(100) < 70 ? C_BUFF_1 : C_BUFF_2;
						break;
					case 2:
						skillToCast = getRandom(100) < 70 ? R_BUFF_1 : R_BUFF_2;
						break;
				}
				
				if (skillToCast != 0)
				{
					npc.setTarget(player);
					npc.doCast(getSkill(skillToCast));
				}
				maguenPetChance(player);
				startQuestTimer("END_TIMER", 3000, npc, player);
			}
			else
			{
				showOnScreenMsg(player, NpcStringId.THE_PLASMAS_HAVE_FILLED_THE_AEROSCOPE_BUT_THEY_ARE_RAMMING_INTO_EACH_OTHER_EXPLODING_AND_DYING, 2, 4000);
				player.getEffectList().stopSkillEffects(true, B_EFFECT);
				player.getEffectList().stopSkillEffects(true, C_EFFECT);
				player.getEffectList().stopSkillEffects(true, R_EFFECT);
			}
		}
		else
		{
			startQuestTimer("END_TIMER", 1000, npc, player);
		}
		npc.setDisplayEffect(4);
		return super.onSpellFinished(npc, player, skill);
	}
	
	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance caster, Skill skill, L2Object[] targets, boolean isSummon)
	{
		if (skill.getReuseHashCode() == MACHINE && caster == npc.getVariables().getObject("SUMMON_PLAYER", L2PcInstance.class))
		{
			if (npc.getVariables().getInt("NPC_EFFECT") != 0 && npc.getVariables().getInt("BLOCKED_SKILLSEE") == 0)
			{
				final AbnormalType B_EFFECT = getSkill(B_PLASMA1).getAbnormalType();
				final AbnormalType C_EFFECT = getSkill(C_PLASMA1).getAbnormalType();
				final AbnormalType R_EFFECT = getSkill(R_PLASMA1).getAbnormalType();
				assert B_EFFECT == AbnormalType.SOA_BUFF1;
				assert C_EFFECT == AbnormalType.SOA_BUFF2;
				assert R_EFFECT == AbnormalType.SOA_BUFF3;
				
				final BuffInfo b_info = caster.getEffectList().getBuffInfoByAbnormalType(B_EFFECT);
				final BuffInfo c_info = caster.getEffectList().getBuffInfoByAbnormalType(C_EFFECT);
				final BuffInfo r_info = caster.getEffectList().getBuffInfoByAbnormalType(R_EFFECT);
				
				final int b = b_info == null ? 0 : b_info.getSkill().getAbnormalLvl();
				final int c = c_info == null ? 0 : c_info.getSkill().getAbnormalLvl();
				final int r = r_info == null ? 0 : r_info.getSkill().getAbnormalLvl();
				
				caster.getEffectList().stopSkillEffects(true, B_EFFECT);
				caster.getEffectList().stopSkillEffects(true, C_EFFECT);
				caster.getEffectList().stopSkillEffects(true, R_EFFECT);
				cancelQuestTimer("FIRST_TIMER", npc, caster);
				cancelQuestTimer("SECOND_TIMER", npc, caster);
				cancelQuestTimer("THIRD_TIMER", npc, caster);
				cancelQuestTimer("FORTH_TIMER", npc, caster);
				npc.getVariables().set("BLOCKED_SKILLSEE", 1);
				
				int skillToCast = 0;
				switch (npc.getVariables().getInt("NPC_EFFECT"))
				{
					case 1:
					{
						switch (b)
						{
							case 0:
								skillToCast = B_PLASMA1;
								break;
							case 1:
								skillToCast = B_PLASMA2;
								break;
							case 2:
								skillToCast = B_PLASMA3;
								break;
						}
						break;
					}
					case 2:
					{
						switch (c)
						{
							case 0:
								skillToCast = C_PLASMA1;
								break;
							case 1:
								skillToCast = C_PLASMA2;
								break;
							case 2:
								skillToCast = C_PLASMA3;
								break;
						}
						break;
					}
					case 3:
					{
						switch (r)
						{
							case 0:
								skillToCast = R_PLASMA1;
								break;
							case 1:
								skillToCast = R_PLASMA2;
								break;
							case 2:
								skillToCast = R_PLASMA3;
								break;
						}
						break;
					}
				}
				
				if (skillToCast != 0)
				{
					npc.setTarget(caster);
					npc.doCast(getSkill(skillToCast));
				}
			}
		}
		return super.onSkillSee(npc, caster, skill, targets, isSummon);
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		if (killer.isInParty())
		{
			final L2PcInstance partyMember = getRandomPartyMember(killer);
			final int i0 = 10 + 10 * killer.getParty().getMemberCount();
			
			if (getRandom(SPAWN_MAGUEN_CHANCE) < i0 && npc.calculateDistance(killer, true, false) < 2000 && npc.calculateDistance(partyMember, true, false) < 2000)
			{
				notifyEvent("SPAWN_MAGUEN", npc, partyMember);
			}
		}
		return super.onKill(npc, killer, isSummon);
	}
	
	private void maguenPetChance(L2PcInstance player)
	{
		if (getRandom(MAGUEN_PET_CHANCE) == 0)
		{
			if (getRandom(ELITE_MAGUEN_PET_CHANCE) == 0)
				giveItems(player, ELITE_MAGUEN_PET, 1);
			else
				giveItems(player, MAGUEN_PET, 1);
		}
	}
	
	private Quest nemoAi()
	{
		return QuestManager.getInstance().getQuest(Nemo.class.getSimpleName());
	}
}