/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package gracia.AI.NPC.Nottingale;

import java.util.HashMap;

import quests.Q10273_GoodDayToFly.Q10273_GoodDayToFly;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.instancemanager.AirShipManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2Position;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.serverpackets.RadarControl;

/**
 * Nottingale AI
 * @author xban1x
 */
public final class Nottingale extends AbstractNpcAI
{
	// NPC
	private static final int NOTTINGALE = 32627;
	// Misc
	private static final HashMap<String, L2Position> RADARS = new HashMap<>();
	static
	{
		RADARS.put("32627-01.html", new L2Position(-184545, 243120, 1581));	// 32557 GWjA R
		RADARS.put("32627-05.html", new L2Position(-192361, 254528, 3598));	// 25623 }X^[ C_[ ohXg[
		RADARS.put("32627-06.html", new L2Position(-174600, 219711, 4424));	// 25624 ̉ bN
		RADARS.put("32627-07.html", new L2Position(-181989, 208968, 4424));	// 25625 oV[ NC[ Gj
		RADARS.put("32627-08.html", new L2Position(-252898, 235845, 5343));	// 25626 jł̎g fBEX
		RADARS.put("32627-09.html", new L2Position(-212819, 209813, 4288));	// sł̎
		RADARS.put("32627-10.html", new L2Position(-246899, 251918, 4352));	// jł̎
	}
	
	public Nottingale()
	{
		super(Nottingale.class.getSimpleName(), "gracia/AI/NPC");
		addStartNpc(NOTTINGALE);
		addTalkId(NOTTINGALE);
		addFirstTalkId(NOTTINGALE);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		String htmltext = null;
		switch (event)
		{
			case "32627-02.html":
			case "32627-03.html":
			case "32627-04.html":
			{
				if (player.getClan() != null)
				{
					if (player.hasClanPrivilege(ClanPrivilege.CL_SUMMON_AIRSHIP) && AirShipManager.getInstance().hasAirShipLicense(player.getClanId()) && !AirShipManager.getInstance().hasAirShip(player.getClanId()))
					{
						htmltext = event;
					}
					else
					{
						final QuestState st = player.getQuestState(Q10273_GoodDayToFly.class.getSimpleName());
						if ((st != null) && st.isCompleted())
						{
							htmltext = event;
						}
						else
						{
							htmltext = "32627-01.html";
							addRadar(player, RADARS.get(htmltext));
						}
					}
				}
				else
				{
					final QuestState st = player.getQuestState(Q10273_GoodDayToFly.class.getSimpleName());
					if ((st != null) && st.isCompleted())
					{
						htmltext = event;
					}
					else
					{
						htmltext = "32627-01.html";
						addRadar(player, RADARS.get(htmltext));
					}
				}
				break;
			}
			case "32627-05.html":
			case "32627-06.html":
			case "32627-07.html":
			case "32627-08.html":
			case "32627-09.html":
			case "32627-10.html":
			{
				htmltext = event;
				addRadar(player, RADARS.get(htmltext));
				break;
			}
		}
		return htmltext;
	}
	
	private void addRadar(L2PcInstance player, L2Position p)
	{
		player.sendPacket(new RadarControl(2, 2, 0, 0, 0));
		player.sendPacket(new RadarControl(0, 2, p.x, p.y, p.z));
	}
}
