/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package gracia.AI.NPC.ZealotOfShilen;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;

/**
 * Zealot of Shilen AI.
 * @author nonom
 */
public final class ZealotOfShilen extends AbstractNpcAI
{
	// NPCs
	private static final int ZEALOT = 18782;
	private static final int[] GUARDS =
	{
		32628,
		32629
	};
	
	public ZealotOfShilen()
	{
		super(ZealotOfShilen.class.getSimpleName(), "gracia/AI/NPC");
		addSpawnId(ZEALOT);
		addSpawnId(GUARDS);
		addNodeArrivedId(GUARDS);	//+[JOJO]
		addFirstTalkId(GUARDS);
	}
	
	@Override
	public boolean onNodeArrived(L2Npc npc)	//[JOJO] onAdvEvent(|[O) --> onNodeArrived(Cxghu)
	{
		// GUARDS[]
		L2GuardInstance guard = (L2GuardInstance) npc;
		if (!guard.isInCombat() && !guard.getKnownList().getKnownPlayers().isEmpty())
		{
			L2World.getInstance().addVisibleObject(guard, guard.getWorldRegion());	// update knownlist
			for (L2Object obj : guard.getKnownList().getKnownObjects().values())
			{
				L2MonsterInstance monster;
				if (obj.isMonster() && !(monster = (L2MonsterInstance) obj).isDead())
				{
					guard.setRunning();
					guard.addDamageHate(monster, 0, 999);
					guard.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, monster, null);
					return true;
				}
			}
		}
		return false;
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		// GUARDS[]
		return (npc.isAttackingNow()) ? "32628-01.html" : npc.getId() + ".html";
	}
	
	@Override
	public String onSpawn(L2Npc npc)
	{
		switch (npc.getNpcId())
		{
			case ZEALOT:
				npc.setIsNoRndWalk(true);
				break;
			case 32628: case 32629: // GUARDS[]
				npc.setIsInvul(true);
				if (!com.l2jserver.Config.NEVER_WALKER_ReturnToSpawnPoint) ((L2Attackable) npc).setCanReturnToSpawnPoint(false);
				break;
		}
		return super.onSpawn(npc);
	}
}
