/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package quests.Q00198_SevenSignsEmbryo;

import static com.l2jserver.gameserver.datatables.SkillData.*;

import java.util.List;
import java.util.logging.Level;

import quests.Q00197_SevenSignsTheSacredBookOfSeal.Q00197_SevenSignsTheSacredBookOfSeal;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.instancezone.InstanceWorld;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.network.NpcStringId;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;

/**
 * Seven Signs, Embryo (198)
 * @author Adry_85
 */
public final class Q00198_SevenSignsEmbryo extends Quest
{
	// NPCs
	private static final int WOOD = 32593;
	// NPCs @instance world HideoutOfTheDawn
	private static final int SHILENS_EVIL_THOUGHTS = 27346;
	private static final int FRANZ = 32597;
	private static final int JAINA = 32617;
	// Items
	private static final int SCULPTURE_OF_DOUBT = 14355;
	private static final int DAWNS_BRACELET = 15312;
	// Misc
	private static final int MIN_LEVEL = 79;
	// Skill
	private static int NPC_HEAL = getSkillHashCode(4065, 8);
	
	public Q00198_SevenSignsEmbryo()
	{
		super(198, Q00198_SevenSignsEmbryo.class.getSimpleName(), "Zu TCAGuI");
		addFirstTalkId(JAINA);
		addStartNpc(WOOD);
		addTalkId(WOOD, FRANZ);
		addKillId(SHILENS_EVIL_THOUGHTS);
		registerQuestItems(SCULPTURE_OF_DOUBT);
	}
	
	void setBusy(int instanceId)	//[JOJO]
	{
		InstanceWorld world = InstanceManager.getInstance().getWorld(instanceId);
		if (world == null)
			return;
		world.status = 1;	// busy = true
	}
	void unsetBusy(int instanceId)	//[JOJO]
	{
		InstanceWorld world = InstanceManager.getInstance().getWorld(instanceId);
		if (world == null)
			return;
		world.status = 0;	// busy = false
	}
	boolean isBusy(int instanceId)	//[JOJO]
	{
		InstanceWorld world = InstanceManager.getInstance().getWorld(instanceId);
		if (world == null)
			return false;
		return world.status != 0;
	}
	L2PcInstance getPlayer(int instanceId)	//[JOJO]
	{
		final List<Integer> players = InstanceManager.getInstance().getInstance(instanceId).getPlayers();
		if (players.size() == 0)
			return null;
		if (players.size() > 1)
			_log.log(Level.WARNING, "getPlayer(" + instanceId + ") -- players.size() > 1");
		final int playerID = players.get(0);
		final L2PcInstance player = L2World.getInstance().getPlayer(playerID);
		if (player == null)
			return null;
		if (player.getInstanceId() != instanceId)
			return null;
		return player;
	}
	L2Npc getNpc(int instanceId, int npcId)	//[JOJO]
	{
		for (L2Npc npc : InstanceManager.getInstance().getInstance(instanceId).getNpcs())
			if (npc.getNpcId() == npcId)
				return npc;
		return null;
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event == "despawn")	// SHILENS_EVIL_THOUGHTS
		{
			if (!npc.isDead())
			{
				final int instanceId = npc.getInstanceId();
				player = getPlayer(instanceId);
				if (player != null && !player.isDead())
					npc.broadcastPacket(new NpcSay(npc, Say2.NPC_ALL, NpcStringId.NEXT_TIME_YOU_WILL_NOT_ESCAPE));
				npc.deleteMe();
				unsetBusy(instanceId);
			}
			return super.onAdvEvent(event, npc, player);
		}
		
		final QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			return null;
		}
		
		String htmltext = null;
		switch (event)
		{
			case "32593-02.html":
			{
				st.startQuest();
				htmltext = event;
				break;
			}
			case "32597-02.html":
			case "32597-03.html":
			case "32597-04.html":
			{
				if (st.isCond(1))
				{
					htmltext = event;
				}
				break;
			}
			case "fight":
			{
				htmltext = "32597-05.html";
				if (st.isCond(1))
				{
					final int instanceId = npc.getInstanceId();
					setBusy(instanceId);
					npc.broadcastPacket(new NpcSay(npc, Say2.NPC_ALL, NpcStringId.S1_THAT_STRANGER_MUST_BE_DEFEATED_HERE_IS_THE_ULTIMATE_HELP).addPcName(player));
					startQuestTimer("heal", getRandom(10000, 30000), npc, player);
					L2MonsterInstance monster = (L2MonsterInstance) addSpawn(SHILENS_EVIL_THOUGHTS, -23734, -9184, -5384, 0, false, 0, false, instanceId);
					monster.broadcastPacket(new NpcSay(monster, Say2.NPC_ALL, NpcStringId.S1_YOU_ARE_NOT_THE_OWNER_OF_THAT_ITEM).addPcName(player));	//[JOJO]
					monster.setRunning();
					monster.addDamageHate(player, 0, 999);
					monster.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, player);
					startQuestTimer("despawn", 300000, monster, null);
				}
				break;
			}
			case "heal":	// FRANZ
			{
				if (isBusy(npc.getInstanceId()))
				{
					if (player.isDead() || !player.isVisible())
					{
						// pass
					}
					else if (!npc.isInsideRadius(player, 600, true, false))
					{
						npc.broadcastPacket(new NpcSay(npc, Say2.NPC_ALL, NpcStringId.LOOK_HERE_S1_DONT_FALL_TOO_FAR_BEHIND).addPcName(player));
					}
					else
					{
						npc.setTarget(player);
						npc.doCast(getSkill(NPC_HEAL));
					}
					startQuestTimer("heal", getRandom(10000, 30000), npc, player);
				}
				break;
			}
			case "32597-08.html":
			case "32597-09.html":
			case "32597-10.html":
			{
				if (st.isCond(2) && st.hasQuestItems(SCULPTURE_OF_DOUBT))
				{
					htmltext = event;
				}
				break;
			}
			case "32597-11.html":
			{
				if (st.isCond(2) && st.hasQuestItems(SCULPTURE_OF_DOUBT))
				{
					st.takeItems(SCULPTURE_OF_DOUBT, -1);
					st.setCond(3, true);
					htmltext = event;
					npc.broadcastPacket(new NpcSay(npc, Say2.NPC_ALL, NpcStringId.WE_WILL_BE_WITH_YOU_ALWAYS));
				}
				break;
			}
			case "32617-02.html":
			{
				htmltext = event;
				break;
			}
		}
		return htmltext;
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		// JAINA
		return "32617-01.html";
	}
	
//	@Override
//	public L2PcInstance getRandomPartyMember(L2PcInstance player, int cond)
//	{
//		final QuestState st = player.getQuestState(getName());
//		return st != null && st.isCond(cond) ? player : null;
//	}
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		// SHILENS_EVIL_THOUGHTS
		cancelQuestTimer("despawn", npc, null);
		
		final int instanceId = npc.getInstanceId();
		final L2PcInstance partyMember = getRandomPartyMember(killer, 1);
		if (partyMember == null)
		{
			unsetBusy(instanceId);
			return null;
		}
		
		final QuestState st = partyMember.getQuestState(getName());
		st.giveItems(SCULPTURE_OF_DOUBT, 1);
		st.setCond(2, true);
		L2Npc franz = getNpc(instanceId, FRANZ);
		franz.broadcastPacket(new NpcSay(franz, Say2.NPC_ALL, NpcStringId.WELL_DONE_S1_YOUR_HELP_IS_MUCH_APPRECIATED).addPcName(partyMember));
		
		npc.broadcastPacket(new NpcSay(npc, Say2.NPC_ALL, NpcStringId.S1_YOU_MAY_HAVE_WON_THIS_TIME_BUT_NEXT_TIME_I_WILL_SURELY_CAPTURE_YOU).addPcName(partyMember));
		npc.deleteMe();
		partyMember.showQuestMovie(14);
		unsetBusy(instanceId);
		return super.onKill(npc, killer, isSummon);
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = getQuestState(player, true);
		String htmltext = getNoQuestMsg(player);
		switch (st.getState())
		{
			case State.COMPLETED:
			{
				htmltext = getAlreadyCompletedMsg(player);
				break;
			}
			case State.CREATED:
			{
				if (npc.getId() == WOOD)
				{
					st = player.getQuestState(Q00197_SevenSignsTheSacredBookOfSeal.class.getSimpleName());
					htmltext = ((player.getLevel() >= MIN_LEVEL) && (st != null) && (st.isCompleted())) ? "32593-01.htm" : "32593-03.html";
				}
				break;
			}
			case State.STARTED:
			{
				if (npc.getId() == WOOD)
				{
					if ((st.getCond() > 0) && (st.getCond() < 3))
					{
						htmltext = "32593-04.html";
					}
					else if (st.isCond(3))
					{
						if (player.getLevel() >= MIN_LEVEL)
						{
							st.addExpAndSp(315108090, 34906059);
							st.giveItems(DAWNS_BRACELET, 1);
							st.giveItems(Inventory.ANCIENT_ADENA_ID, 1500000);
							st.exitQuest(false, true);
							htmltext = "32593-05.html";
						}
						else
						{
							htmltext = "level_check.html";
						}
					}
				}
				else if (npc.getId() == FRANZ)
				{
					switch (st.getCond())
					{
						case 1:
						{
							if (isBusy(npc.getInstanceId()))
							{
								htmltext = "32597-05.html";
							}
							else
							{
								htmltext = "32597-01.html";
							}
							break;
						}
						case 2:
						{
							if (st.hasQuestItems(SCULPTURE_OF_DOUBT))
							{
								htmltext = "32597-07.html";
							}
							break;
						}
						case 3:
						{
							htmltext = "32597-12.html";
							break;
						}
					}
				}
				break;
			}
		}
		return htmltext;
	}
}
