/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package quests.Q00385_YokeOfThePast;

import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;

/**
 * Yoke of the Past (385)
 * @author Pandragon
 */
public final class Q00385_YokeOfThePast extends Quest
{
	// NPCs
	// @formatter:off
	private static final int[] ZIGGURATS =
	{
		31095, 31096, 31097, 31098, 31099, 31100, 31101,
		31102, 31103, 31104, 31105, 31106, 31107, 31108,
		31109, 31110, 31114, 31115, 31116, 31117, 31118,
		31119, 31120, 31121, 31122, 31123, 31124, 31125
	};
	// @formatter:on
	// Item
	private static final int SCROLL_OF_ANCIENT_MAGIC = 5902;
	// Reward
	private static final int BLANK_SCROLL = 5965;
	// Monsters
	private static final SortedIntObjectArrayMap<Double> MONSTER_CHANCES = new SortedIntObjectArrayMap<Double>()
		.append(21144, 0.306) // Catacomb Shadow
		.append(21156, 0.994) // Purgatory Shadow
		.append(21208, 0.146) // Hallowed Watchman
		.append(21209, 0.166) // Hallowed Seer
		.append(21210, 0.202) // Vault Guardian
		.append(21211, 0.212) // Vault Seer
		.append(21213, 0.274) // Hallowed Monk
		.append(21214, 0.342) // Vault Sentinel
		.append(21215, 0.360) // Vault Monk
		.append(21217, 0.460) // Hallowed Priest
		.append(21218, 0.558) // Vault Overlord
		.append(21219, 0.578) // Vault Priest
		.append(21221, 0.710) // Sepulcher Inquisitor
		.append(21222, 0.842) // Sepulcher Archon
		.append(21223, 0.862) // Sepulcher Inquisitor
		.append(21224, 0.940) // Sepulcher Guardian
		.append(21225, 0.970) // Sepulcher Sage
		.append(21226, 0.202) // Sepulcher Guardian
		.append(21227, 0.290) // Sepulcher Sage
		.append(21228, 0.316) // Sepulcher Guard
		.append(21229, 0.426) // Sepulcher Preacher
		.append(21230, 0.646) // Sepulcher Guard
		.append(21231, 0.654) // Sepulcher Preacher
		.append(21236, 0.238) // Barrow Sentinel
		.append(21237, 0.274) // Barrow Monk
		.append(21238, 0.342) // Grave Sentinel
		.append(21239, 0.360) // Grave Monk
		.append(21240, 0.410) // Barrow Overlord
		.append(21241, 0.460) // Barrow Priest
		.append(21242, 0.558) // Grave Overlord
		.append(21243, 0.578) // Grave Priest
		.append(21244, 0.642) // Crypt Archon
		.append(21245, 0.700) // Crypt Inquisitor
		.append(21246, 0.842) // Tomb Archon
		.append(21247, 0.862) // Tomb Inquisitor
		.append(21248, 0.940) // Crypt Guardian
		.append(21249, 0.970) // Crypt Sage
		.append(21250, 0.798) // Tomb Guardian
		.append(21251, 0.710) // Tomb Sage
		.append(21252, 0.684) // Crypt Guard
		.append(21253, 0.574) // Crypt Preacher
		.append(21254, 0.354) // Tomb Guard
		.append(21255, 0.250) // Tomb Preacher
	;
	// Misc
	private static final int MIN_LVL = 20;
	
	public Q00385_YokeOfThePast()
	{
		super(385, Q00385_YokeOfThePast.class.getSimpleName(), "ߋ̑");
		addStartNpc(ZIGGURATS);
		addTalkId(ZIGGURATS);
		addKillId(MONSTER_CHANCES.keySet());
		registerQuestItems(SCROLL_OF_ANCIENT_MAGIC);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		final QuestState qs = getQuestState(player, false);
		String htmltext = null;
		if (qs != null)
		{
			switch (event)
			{
				case "ziggurat-03.htm":
				case "ziggurat-04.htm":
				case "ziggurat-06.htm":
				case "ziggurat-07.htm":
				{
					htmltext = event;
					break;
				}
				case "ziggurat-05.htm":
				{
					if (qs.isCreated())
					{
						qs.startQuest();
						htmltext = event;
					}
					break;
				}
				case "ziggurat-10.html":
				{
					qs.exitQuest(true, true);
					htmltext = event;
					break;
				}
			}
		}
		return htmltext;
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance talker)
	{
		final QuestState qs = getQuestState(talker, true);
		String htmltext = getNoQuestMsg(talker);
		switch (qs.getState())
		{
			case State.CREATED:
			{
				htmltext = (talker.getLevel() >= MIN_LVL) ? "ziggurat-01.htm" : "ziggurat-02.htm";
				break;
			}
			case State.STARTED:
			{
				if (hasQuestItems(talker, SCROLL_OF_ANCIENT_MAGIC))
				{
					rewardItems(talker, BLANK_SCROLL, getQuestItemsCount(talker, SCROLL_OF_ANCIENT_MAGIC));
					takeItems(talker, SCROLL_OF_ANCIENT_MAGIC, -1);
					htmltext = "ziggurat-09.html";
				}
				else
				{
					htmltext = "ziggurat-08.html";
				}
				break;
			}
		}
		return htmltext;
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isSummon)
	{
		final QuestState qs = getRandomPartyMemberState(killer, -1, 3, npc);
		if (qs != null)
		{
			giveItemRandomly(qs.getPlayer(), npc, SCROLL_OF_ANCIENT_MAGIC, 1, 0, MONSTER_CHANCES.get(npc.getId()), true);
		}
		return super.onKill(npc, killer, isSummon);
	}
}
