/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package quests.Q00619_RelicsOfTheOldEmpire;

import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.util.Util;

/**
 * Relics of the Old Empire (619)
 * @author Adry_85, jurchiks
 */
public final class Q00619_RelicsOfTheOldEmpire extends Quest
{
	private static final class DropInfo
	{
		private final double _dropChance;
		private final int _doubleItemChance;
		private final boolean _dropEntrancePass;
		
		DropInfo(double dropChance, int doubleItemChance, boolean dropEntrancePass)
		{
			_dropChance = dropChance;
			_doubleItemChance = doubleItemChance;
			_dropEntrancePass = dropEntrancePass;
		}
		
		double getDropChance()
		{
			return _dropChance;
		}
		
		int getDoubleItemChance()
		{
			return _doubleItemChance;
		}
		
		boolean getDropEntrancePass()
		{
			return _dropEntrancePass;
		}
	}
	
	// NPC
	private static final int GHOST_OF_ADVENTURER = 31538;
	// Items
	private static final int ENTRANCE_PASS_TO_THE_SEPULCHER = 7075;
	private static final int BROKEN_RELIC_PART = 7254;
	// Misc
	private static final int MIN_LEVEL = 75;
	private static final int REQUIRED_RELIC_COUNT = 1000;
	// Reward
	private static final int[] RECIPES =
	{
		6881, // Recipe: Forgotten Blade (60%)
		6883, // Recipe: Basalt Battlehammer (60%)
		6885, // Recipe: Imperial Staff (60%)
		6887, // Recipe: Angel Slayer (60%)
		6891, // Recipe: Dragon Hunter Axe (60%)
		6893, // Recipe: Saint Spear (60%)
		6895, // Recipe: Demon Splinter (60%)
		6897, // Recipe: Heavens Divider (60%)
		6899, // Recipe: Arcana Mace (60%)
		7580, // Recipe: Draconic Bow (60%)
	};
	// Mobs
	private static final SortedIntObjectArrayMap<DropInfo> MOBS = new SortedIntObjectArrayMap<DropInfo>()
		.append(21396, new DropInfo(0.51, 0, true)) // carrion_scarab
		.append(21397, new DropInfo(0.50, 0, true)) // carrion_scarab_a
		.append(21398, new DropInfo(0.95, 0, true)) // soldier_scarab
		.append(21399, new DropInfo(0.84, 0, true)) // soldier_scarab_a
		.append(21400, new DropInfo(0.76, 0, true)) // hexa_beetle
		.append(21401, new DropInfo(0.67, 0, true)) // hexa_beetle_a
		.append(21402, new DropInfo(0.69, 0, true)) // katraxith
		.append(21403, new DropInfo(0.80, 0, true)) // katraxith_a
		.append(21404, new DropInfo(0.90, 0, true)) // tera_beetle
		.append(21405, new DropInfo(0.64, 0, true)) // tera_beetle_a
		.append(21406, new DropInfo(0.87, 0, true)) // imperial_knight
		.append(21407, new DropInfo(0.56, 0, true)) // imperial_knight_a
		.append(21408, new DropInfo(0.82, 0, true)) // imperial_guard
		.append(21409, new DropInfo(0.92, 0, true)) // imperial_guard_a
		.append(21410, new DropInfo(0.81, 0, true)) // guardian_scarab
		.append(21411, new DropInfo(0.66, 0, true)) // guardian_scarab_a
		.append(21412, new DropInfo(1.00, 6, true)) // ustralith
		.append(21413, new DropInfo(0.81, 0, true)) // ustralith_a
		.append(21414, new DropInfo(0.79, 0, true)) // imperial_assassin
		.append(21415, new DropInfo(0.80, 0, true)) // imperial_assassin_a
		.append(21416, new DropInfo(0.82, 0, true)) // imperial_warlord
		.append(21417, new DropInfo(1.00, 27, true)) // imperial_warlord_a
		.append(21418, new DropInfo(0.66, 0, true)) // imperial_highguard
		.append(21419, new DropInfo(0.67, 0, true)) // imperial_highguard_a
		.append(21420, new DropInfo(0.82, 0, true)) // ashuras
		.append(21421, new DropInfo(0.77, 0, true)) // ashuras_a
		.append(21422, new DropInfo(0.88, 0, true)) // imperial_dancer
		.append(21423, new DropInfo(0.94, 0, true)) // imperial_dancer_a
		.append(21424, new DropInfo(1.00, 19, true)) // ashikenas
		.append(21425, new DropInfo(1.00, 21, true)) // ashikenas_a
		.append(21426, new DropInfo(1.00, 8, true)) // abraxian
		.append(21427, new DropInfo(0.74, 0, true)) // abraxian_a
		.append(21428, new DropInfo(0.76, 0, true)) // hasturan
		.append(21429, new DropInfo(0.80, 0, true)) // hasturan_a
		.append(21430, new DropInfo(1.00, 10, true)) // ahrimanes
		.append(21431, new DropInfo(0.94, 0, true)) // ahrimanes_a
		.append(21432, new DropInfo(1.00, 34, true)) // chakram_beetle
		.append(21433, new DropInfo(1.00, 34, true)) // jamadhr_beetle
		.append(21434, new DropInfo(1.00, 90, true)) // priest_of_blood
		.append(21435, new DropInfo(1.00, 60, true)) // sacrifice_guide
		.append(21436, new DropInfo(1.00, 66, true)) // sacrifice_bearer
		.append(21437, new DropInfo(0.69, 0, true)) // sacrifice_scarab
		.append(21798, new DropInfo(0.33, 0, true)) // guard_skeleton_2d
		.append(21799, new DropInfo(0.61, 0, true)) // guard_skeleton_3d
		.append(21800, new DropInfo(0.31, 0, true)) // guard_undead
		.append(18120, new DropInfo(1.00, 28, false)) // r11_roomboss_strong
		.append(18121, new DropInfo(1.00, 21, false)) // r11_roomboss_weak
		.append(18122, new DropInfo(0.93, 0, false)) // r11_roomboss_teleport
		.append(18123, new DropInfo(1.00, 28, false)) // r12_roomboss_strong
		.append(18124, new DropInfo(1.00, 21, false)) // r12_roomboss_weak
		.append(18125, new DropInfo(0.93, 0, false)) // r12_roomboss_teleport
		.append(18126, new DropInfo(1.00, 28, false)) // r13_roomboss_strong
		.append(18127, new DropInfo(1.00, 21, false)) // r13_roomboss_weak
		.append(18128, new DropInfo(0.93, 0, false)) // r13_roomboss_teleport
		.append(18129, new DropInfo(1.00, 28, false)) // r14_roomboss_strong
		.append(18130, new DropInfo(1.00, 21, false)) // r14_roomboss_weak
		.append(18131, new DropInfo(0.93, 0, false)) // r14_roomboss_teleport
		.append(18132, new DropInfo(1.00, 30, false)) // r1_beatle_healer
		.append(18133, new DropInfo(1.00, 20, false)) // r1_scorpion_warrior
		.append(18134, new DropInfo(0.90, 0, false)) // r1_warrior_longatk1_h
		.append(18135, new DropInfo(1.00, 20, false)) // r1_warrior_longatk2
		.append(18136, new DropInfo(1.00, 20, false)) // r1_warrior_selfbuff
		.append(18137, new DropInfo(0.89, 0, false)) // r1_wizard_h
		.append(18138, new DropInfo(1.00, 19, false)) // r1_wizard_clanbuff
		.append(18139, new DropInfo(1.00, 17, false)) // r1_wizard_debuff
		.append(18140, new DropInfo(1.00, 19, false)) // r1_wizard_selfbuff
		.append(18141, new DropInfo(0.76, 0, false)) // r21_scarab_roombosss
		.append(18142, new DropInfo(0.76, 0, false)) // r22_scarab_roombosss
		.append(18143, new DropInfo(0.76, 0, false)) // r23_scarab_roombosss
		.append(18144, new DropInfo(0.76, 0, false)) // r24_scarab_roombosss
		.append(18145, new DropInfo(0.65, 0, false)) // r2_wizard_clanbuff
		.append(18146, new DropInfo(0.66, 0, false)) // r2_warrior_longatk2
		.append(18147, new DropInfo(0.62, 0, false)) // r2_wizard
		.append(18148, new DropInfo(0.72, 0, false)) // r2_warrior
		.append(18149, new DropInfo(0.63, 0, false)) // r2_bomb
		.append(18166, new DropInfo(0.92, 0, false)) // r3_warrior
		.append(18167, new DropInfo(0.92, 0, false)) // r3_warrior_longatk1_h
		.append(18168, new DropInfo(0.93, 0, false)) // r3_warrior_longatk2
		.append(18169, new DropInfo(0.90, 0, false)) // r3_warrior_selfbuff
		.append(18170, new DropInfo(0.90, 0, false)) // r3_wizard_h
		.append(18171, new DropInfo(0.94, 0, false)) // r3_wizard_clanbuff
		.append(18172, new DropInfo(0.89, 0, false)) // r3_wizard_selfbuff
		.append(18173, new DropInfo(0.99, 0, false)) // r41_roomboss_strong
		.append(18174, new DropInfo(1.00, 22, false)) // r41_roomboss_weak
		.append(18175, new DropInfo(0.93, 0, false)) // r41_roomboss_teleport
		.append(18176, new DropInfo(0.99, 0, false)) // r42_roomboss_strong
		.append(18177, new DropInfo(1.00, 22, false)) // r42_roomboss_weak
		.append(18178, new DropInfo(0.93, 0, false)) // r42_roomboss_teleport
		.append(18179, new DropInfo(0.99, 0, false)) // r43_roomboss_strong
		.append(18180, new DropInfo(1.00, 22, false)) // r43_roomboss_weak
		.append(18181, new DropInfo(0.93, 0, false)) // r43_roomboss_teleport
		.append(18182, new DropInfo(0.99, 0, false)) // r44_roomboss_strong
		.append(18183, new DropInfo(1.00, 22, false)) // r44_roomboss_weak
		.append(18184, new DropInfo(0.93, 0, false)) // r44_roomboss_teleport
		.append(18185, new DropInfo(1.00, 23, false)) // r4_healer_srddmagic
		.append(18186, new DropInfo(1.00, 24, false)) // r4_hearler_srdebuff
		.append(18187, new DropInfo(1.00, 20, false)) // r4_warrior
		.append(18188, new DropInfo(0.90, 0, false)) // r4_warrior_longatk1_h
		.append(18189, new DropInfo(1.00, 20, false)) // r4_warrior_longatk2
		.append(18190, new DropInfo(1.00, 20, false)) // r4_warrior_selfbuff
		.append(18191, new DropInfo(0.89, 0, false)) // r4_wizard_h
		.append(18192, new DropInfo(1.00, 19, false)) // r4_wizard_clanbuff
		.append(18193, new DropInfo(1.00, 17, false)) // r4_wizard_debuff
		.append(18194, new DropInfo(1.00, 19, false)) // r4_wizard_selfbuff
		.append(18195, new DropInfo(0.91, 0, false)) // r4_bomb
		.append(18220, new DropInfo(1.00, 24, false)) // r5_healer1
		.append(18221, new DropInfo(1.00, 27, false)) // r5_healer2
		.append(18222, new DropInfo(1.00, 21, false)) // r5_warrior
		.append(18223, new DropInfo(0.90, 0, false)) // r5_warrior_longatk1_h
		.append(18224, new DropInfo(1.00, 22, false)) // r5_warrior_longatk2
		.append(18225, new DropInfo(1.00, 21, false)) // r5_warrior_sbuff
		.append(18226, new DropInfo(0.89, 0, false)) // r5_wizard_h
		.append(18227, new DropInfo(1.00, 53, false)) // r5_wizard_clanbuff
		.append(18228, new DropInfo(1.00, 15, false)) // r5_wizard_debuff
		.append(18229, new DropInfo(1.00, 19, false)) // r5_wizard_slefbuff
		.append(18230, new DropInfo(0.49, 0, false)) // r5_bomb
	;
	
	// @formatter:off
	private static final int[] ARCHON_OF_HALISHA =
	{
		18212, 18213, 18214, 18215, 18216, 18217, 18218, 18219
	};
	// @formatter:on
	
	public Q00619_RelicsOfTheOldEmpire()
	{
		super(619, Q00619_RelicsOfTheOldEmpire.class.getSimpleName(), "鍑̈╨");
		addStartNpc(GHOST_OF_ADVENTURER);
		addTalkId(GHOST_OF_ADVENTURER);
		addKillId(MOBS.keySet());
		addKillId(ARCHON_OF_HALISHA);
		registerQuestItems(BROKEN_RELIC_PART);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		final QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			return null;
		}
		
		String htmltext = null;
		switch (event)
		{
			case "31538-02.htm":
			{
				st.startQuest();
				htmltext = event;
				break;
			}
			case "31538-05.html":
			{
				htmltext = event;
				break;
			}
			case "31538-06.html":
			{
				if (st.getQuestItemsCount(BROKEN_RELIC_PART) >= REQUIRED_RELIC_COUNT)
				{
					st.rewardItems(RECIPES[getRandom(RECIPES.length)], 1);
					st.takeItems(BROKEN_RELIC_PART, REQUIRED_RELIC_COUNT);
					htmltext = event;
				}
				break;
			}
			case "31538-08.html":
			{
				st.exitQuest(true, true);
				htmltext = event;
				break;
			}
		}
		return htmltext;
	}
	
	@Override
	public String onKill(L2Npc npc, L2PcInstance player, boolean isSummon)
	{
		final QuestState st = getRandomPartyMemberState(player, -1, 3, npc);
		if (st != null)
		{
			int npcId = npc.getId();
			if (Util.contains(ARCHON_OF_HALISHA, npcId))
			{
				final int itemCount = ((getRandom(100) < 79) ? 4 : 3);
				st.giveItemRandomly(npc, BROKEN_RELIC_PART, itemCount, 0, 1.0, true);
			}
			else
			{
				final DropInfo info = MOBS.get(npcId);
				final int itemCount;
				
				if (info.getDoubleItemChance() > 0)
				{
					itemCount = ((getRandom(100) < info.getDoubleItemChance()) ? 2 : 1);
				}
				else
				{
					itemCount = 1;
				}
				
				st.giveItemRandomly(npc, BROKEN_RELIC_PART, itemCount, 0, info.getDropChance(), true);
				
				if (info.getDropEntrancePass())
				{
					st.giveItemRandomly(npc, ENTRANCE_PASS_TO_THE_SEPULCHER, 1, 0, 1.0 / 30, false);
				}
			}
		}
		return super.onKill(npc, player, isSummon);
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(getName());
		String htmltext = getNoQuestMsg(player);
		if (st == null)
		{
			return htmltext;
		}
		
		if (st.isCreated())
		{
			htmltext = ((player.getLevel() >= MIN_LEVEL) ? "31538-01.htm" : "31538-03.html");
		}
		else if (st.isStarted())
		{
			htmltext = ((getQuestItemsCount(player, BROKEN_RELIC_PART) >= REQUIRED_RELIC_COUNT) ? "31538-04.html" : "31538-07.html");
		}
		return htmltext;
	}
}
