/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package quests.Q10283_RequestOfIceMerchant;

import java.util.Queue;

import quests.Q00115_TheOtherSideOfTruth.Q00115_TheOtherSideOfTruth;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;

/**
 * Request of Ice Merchant (10283)
 * @author Gnacik
 * @version 2013-02-07 Updated to High Five
 */
public class Q10283_RequestOfIceMerchant extends Quest
{
	// NPCs
	private static final int RAFFORTY = 32020;	// v
	private static final int KIER = 32022;	// LG[
	private static final int JINIA = 32760;	// WjA(LG[̉)
	// Location
	private static final Location MOVE_TO_END = new Location(104457, -107010, -3698, 0);
	// Misc
	private boolean _jiniaOnSpawn = false;
	
	public Q10283_RequestOfIceMerchant()
	{
		super(10283, Q10283_RequestOfIceMerchant.class.getSimpleName(), "X̗");
		addStartNpc(RAFFORTY);
		addTalkId(RAFFORTY, KIER, JINIA);
		addFirstTalkId(JINIA);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		switch (event)
		{
			case "spawn":	// KIER 32022-01.html
				if (_jiniaOnSpawn)
				{
					return "32022-02.html";
				}
				else
				{
					_jiniaOnSpawn = true;
					L2Npc jinia = addSpawn(JINIA, 104473, -107549, -3695, 44954, false, 0);
					startQuestTimer("despawn", 180000, jinia, null);
					return null;
				}
				//break;
			case "despawn":	// JINIA
				_jiniaOnSpawn = false;
				npc.deleteMe();
				return null;
		}
		
		String htmltext = event;
		final QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			return htmltext;
		}
		
		switch (event)
		{
			case "32020-03.htm":	// RAFFORTY
				st.startQuest();
				break;
			case "32020-07.htm":	// RAFFORTY
				st.setCond(2, true);
				break;
			case "32760-04.html":	// JINIA
				cancelQuestTimer("despawn", npc, null);
				st.giveAdena(190000, true);
				st.addExpAndSp(627000, 50300);
				st.exitQuest(false, true);
				npc.setRunning();
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, MOVE_TO_END);
				startQuestTimer("despawn", 2000, npc, null);
				break;
		}
		return htmltext;
	}
	
	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
		if (npc.getInstanceId() > 0)
		{
			// JINIA Q10284_AcquisitionOfDivineSword | Q10285_MeetingSirra | Q10286_ReunionWithSirra | Q10287_StoryOfThoseLeft (AWg)
			final Queue<AbstractEventListener> eventQuests;
			if ((eventQuests = npc.getTemplate().getListeners(EventType.ON_NPC_TALK)) != null) {
				Quest quest = null;
				int count = 0;
				for (AbstractEventListener e : eventQuests) {
					Quest q = e.getQuest();
					if (!q.isQuests())
						continue;
					QuestState st = player.getQuestState(q.getName());
					if (st != null && st.isStarted()) {
						quest = q;
						++count;
					}
				}
				if (count == 1 && quest != null) {
					handlers.bypasshandlers.QuestLink.showQuestWindow(player, npc, quest.getName());
					return null;
				}
			}
			return "32760-10.html";
		}
		else
		{
			// JINIA Q10283_RequestOfIceMerchant (LG[̉)
			final QuestState st = player.getQuestState(getName());
			if ((st != null) && st.isCond(2))
			{
				return "32760-01.html";
			}
			return null;
		}
	}
	
	@Override
	public String onTalk(L2Npc npc, L2PcInstance player)
	{
		String htmltext = getNoQuestMsg(player);
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			return htmltext;
		}
		
		switch (npc.getId())
		{
			case RAFFORTY:
				switch (st.getState())
				{
					case State.CREATED:
						QuestState _prev = player.getQuestState(Q00115_TheOtherSideOfTruth.class.getSimpleName());
						htmltext = ((_prev != null) && _prev.isCompleted() && (player.getLevel() >= 82)) ? "32020-01.htm" : "32020-00.htm";
						break;
					case State.STARTED:
						if (st.isCond(1))
						{
							htmltext = "32020-04.htm";
						}
						else if (st.isCond(2))
						{
							htmltext = "32020-08.htm";
						}
						break;
					case State.COMPLETED:
						htmltext = "32020-09.htm";
						break;
				}
				break;
			case KIER:
				if (st.isCond(2))
				{
					htmltext = "32022-00.html";	//[JOJO] -01.html --> -00.html
				}
				break;
			case JINIA:
				if (st.isCond(2))
				{
					htmltext = "32760-02.html";
				}
				break;
		}
		return htmltext;
	}
}
