//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.arrayMaps;

import static jp.sf.l2j.arrayMaps.SortedArrayMap.*;

import java.util.Arrays;
import java.util.Map;
import java.util.Map.Entry;

/*
 * @auther JOJO
 */
public class SortedIntBooleanArrayMap
{
	private int[] _keys;
	private boolean[] _values;
	public final boolean NULL;
	
	public boolean getNoEntryValue()
	{
		return NULL;
	}
	
	public SortedIntBooleanArrayMap()
	{
		this(BOOLEAN_NULL);
	}
	
	public SortedIntBooleanArrayMap(boolean nullValue)
	{
		this(nullValue, EMPTY_INT_ARRAY, EMPTY_BOOLEAN_ARRAY);
	}
	
	public SortedIntBooleanArrayMap(int[] keys, boolean[] values)
	{
		this(BOOLEAN_NULL, keys, values);
	}
	
	public SortedIntBooleanArrayMap(boolean nullValue, int[] keys, boolean[] values)
	{
		NULL = nullValue;
		_keys = keys;
		_values = values;
		sort();
	}
	
	public SortedIntBooleanArrayMap(Map<Integer, Boolean> t)
	{
		this(BOOLEAN_NULL, t);
	}
	
	public SortedIntBooleanArrayMap(boolean nullValue, Map<Integer, Boolean> t)
	{
		NULL = nullValue;
		int length = t.size();
		int[] tmpKeys = new int[length];
		boolean[] tmpValues = new boolean[length];
		
		Boolean w;
		int index = 0;
		for (Entry<Integer, Boolean> e : t.entrySet())
		{
			tmpKeys[index] = e.getKey();
			tmpValues[index] = (w = e.getValue()) == null ? NULL : w;
			++index;
		}
		_keys = tmpKeys;
		_values = tmpValues;
		sort();
	}
	
	public void clear()
	{
		_keys = EMPTY_INT_ARRAY;
		_values = EMPTY_BOOLEAN_ARRAY;
	}
	
	public boolean containsKey(int key)
	{
		return Arrays.binarySearch(_keys, key) >= 0;
	}
	
	public boolean containsValue(boolean value)
	{
		for (int index = _values.length; --index >= 0;)
			if (_values[index] == value)
				return true;
		return false;
	}
	
	public boolean get(int key)
	{
		return getOrDefault(key, NULL);
	}
	
	public boolean getOrDefault(int key, boolean defaultValue)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return defaultValue;
	}
	
	public boolean isEmpty()
	{
		return _keys.length == 0;
	}
	
	public int[] keySet()
	{
		return _keys;
	}
	
	public int[] keys()
	{
		return _keys;
	}
	
	public boolean put(int key, boolean value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0) {
			boolean prev = _values[index];
			_values[index] = value;
			return prev;
		} else {
			return insertEntry(-(index + 1), key, value);
		}
	}
	
	public boolean putIfAbsent(int key, boolean value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return insertEntry(-(index + 1), key, value);
	}
	
	public void putAll(Map<Integer, Boolean> t)
	{
		for (Entry<Integer, Boolean> e : t.entrySet())
			put(e.getKey(), e.getValue());
	}
	
	public boolean remove(int key)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return removeAt(index);
		else
			return NULL;
	}
	
	public int size()
	{
		return _keys.length;
	}
	
	public boolean[] values()
	{
		return _values;
	}
	
	public SortedIntBooleanArrayMap append(int key, boolean value)
	{
		boolean prev = put(key, value);
		if (prev != NULL) throw new IllegalArgumentException("Duplicate key:" + key + " value:" + value + " previus:" + prev);
		return this;
	}
	
	public SortedIntBooleanArrayMap add(int key, boolean value)
	{
		return append(key, value);
	}
	
	private boolean removeAt(int index)
	{
		final int length = _keys.length - 1;
		if (length < 0)
			return NULL;
		int[] tmpKeys = new int[length];
		boolean[] tmpValues = new boolean[length];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index + 1, tmpKeys, index, n);
			System.arraycopy(_values, index + 1, tmpValues, index, n);
		}
		boolean prev = _values[index];
		_keys = tmpKeys;
		_values = tmpValues;
		return prev;
	}
	
	public int indexOfKey(int key)
	{
		return Arrays.binarySearch(_keys, key);
	}
	
	public int indexOfValue(boolean value)
	{
		for (int index = 0, length = _values.length; index < length; ++index)
			if (_values[index] == value)
				return index;
		return -1;
	}
	
	private boolean insertEntry(int index, int key, boolean value)
	{
		final int length = _keys.length;
		int[] tmpKeys = new int[length + 1];
		boolean[] tmpValues = new boolean[length + 1];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		tmpKeys[index] = key;
		tmpValues[index] = value;
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index, tmpKeys, index + 1, n);
			System.arraycopy(_values, index, tmpValues, index + 1, n);
		}
		_keys = tmpKeys;
		_values = tmpValues;
		return NULL;
	}
	
	public int keyAt(int index)
	{
		return _keys[index];
	}
	
	public boolean valueAt(int index)
	{
		return _values[index];
	}
	
	public int getKey(int index)
	{
		return keyAt(index);
	}
	
	public boolean getValue(int index)
	{
		return valueAt(index);
	}
	
	public boolean setValue(int index, boolean value)
	{
		boolean prev = _values[index];
		_values[index] = value;
		return prev;
	}
	
	public void fill(boolean value)
	{
		Arrays.fill(_values, value);
	}
	
	public void sort()
	{
		sort(0, _keys.length - 1);
	}
	
	private void sort(int left, int right)
	{
		if (left >= right) return;
		int pivot = _keys[(left + right) / 2];
		int i = left;
		int j = right;
		for (;;) {
			while (_keys[i] < pivot) ++i;
			while (pivot < _keys[j]) --j;
			if (i >= j) break;
			int key = _keys[i]; _keys[i] = _keys[j]; _keys[j] = key;
			boolean value = _values[i]; _values[i] = _values[j]; _values[j] = value;
			++i;
			--j;
		}
		sort(left,  i - 1);
		sort(j + 1, right);
	}
}
