//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.arrayMaps;

import static jp.sf.l2j.arrayMaps.SortedArrayMap.*;

import java.util.Arrays;
import java.util.Map;
import java.util.Map.Entry;

/*
 * @auther JOJO
 */
public class SortedIntFloatArrayMap
{
	private int[] _keys;
	private float[] _values;
	public final float NULL;
	
	public float getNoEntryValue()
	{
		return NULL;
	}
	
	public SortedIntFloatArrayMap()
	{
		this(FLOAT_NULL);
	}
	
	public SortedIntFloatArrayMap(float nullValue)
	{
		this(nullValue, EMPTY_INT_ARRAY, EMPTY_FLOAT_ARRAY);
	}
	
	public SortedIntFloatArrayMap(int[] keys, float[] values)
	{
		this(FLOAT_NULL, keys, values);
	}
	
	public SortedIntFloatArrayMap(float nullValue, int[] keys, float[] values)
	{
		NULL = nullValue;
		_keys = keys;
		_values = values;
		sort();
	}
	
	public SortedIntFloatArrayMap(Map<Integer, Float> t)
	{
		this(FLOAT_NULL, t);
	}
	
	public SortedIntFloatArrayMap(float nullValue, Map<Integer, Float> t)
	{
		NULL = nullValue;
		int length = t.size();
		int[] tmpKeys = new int[length];
		float[] tmpValues = new float[length];
		
		Float w;
		int index = 0;
		for (Entry<Integer, Float> e : t.entrySet())
		{
			tmpKeys[index] = e.getKey();
			tmpValues[index] = (w = e.getValue()) == null ? NULL : w;
			++index;
		}
		_keys = tmpKeys;
		_values = tmpValues;
		sort();
	}
	
	public void clear()
	{
		_keys = EMPTY_INT_ARRAY;
		_values = EMPTY_FLOAT_ARRAY;
	}
	
	public boolean containsKey(int key)
	{
		return Arrays.binarySearch(_keys, key) >= 0;
	}
	
	public boolean containsValue(float value)
	{
		for (int index = _values.length; --index >= 0;)
			if (_values[index] == value)
				return true;
		return false;
	}
	
	public float get(int key)
	{
		return getOrDefault(key, NULL);
	}
	
	public float getOrDefault(int key, float defaultValue)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return defaultValue;
	}
	
	public boolean isEmpty()
	{
		return _keys.length == 0;
	}
	
	public int[] keySet()
	{
		return _keys;
	}
	
	public int[] keys()
	{
		return _keys;
	}
	
	public float put(int key, float value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0) {
			float prev = _values[index];
			_values[index] = value;
			return prev;
		} else {
			return insertEntry(-(index + 1), key, value);
		}
	}
	
	public float putIfAbsent(int key, float value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return insertEntry(-(index + 1), key, value);
	}
	
	public void putAll(Map<Integer, Float> t)
	{
		for (Entry<Integer, Float> e : t.entrySet())
			put(e.getKey(), e.getValue());
	}
	
	public float remove(int key)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return removeAt(index);
		else
			return NULL;
	}
	
	public int size()
	{
		return _keys.length;
	}
	
	public float[] values()
	{
		return _values;
	}
	
	public SortedIntFloatArrayMap append(int key, float value)
	{
		float prev = put(key, value);
		if (prev != NULL) throw new IllegalArgumentException("Duplicate key:" + key + " value:" + value + " previus:" + prev);
		return this;
	}
	
	public SortedIntFloatArrayMap add(int key, float value)
	{
		return append(key, value);
	}
	
	private float removeAt(int index)
	{
		final int length = _keys.length - 1;
		if (length < 0)
			return NULL;
		int[] tmpKeys = new int[length];
		float[] tmpValues = new float[length];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index + 1, tmpKeys, index, n);
			System.arraycopy(_values, index + 1, tmpValues, index, n);
		}
		float prev = _values[index];
		_keys = tmpKeys;
		_values = tmpValues;
		return prev;
	}
	
	public int indexOfKey(int key)
	{
		return Arrays.binarySearch(_keys, key);
	}
	
	public int indexOfValue(float value)
	{
		for (int index = 0, length = _values.length; index < length; ++index)
			if (_values[index] == value)
				return index;
		return -1;
	}
	
	private float insertEntry(int index, int key, float value)
	{
		final int length = _keys.length;
		int[] tmpKeys = new int[length + 1];
		float[] tmpValues = new float[length + 1];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		tmpKeys[index] = key;
		tmpValues[index] = value;
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index, tmpKeys, index + 1, n);
			System.arraycopy(_values, index, tmpValues, index + 1, n);
		}
		_keys = tmpKeys;
		_values = tmpValues;
		return NULL;
	}
	
	public int keyAt(int index)
	{
		return _keys[index];
	}
	
	public float valueAt(int index)
	{
		return _values[index];
	}
	
	public int getKey(int index)
	{
		return keyAt(index);
	}
	
	public float getValue(int index)
	{
		return valueAt(index);
	}
	
	public float setValue(int index, float value)
	{
		float prev = _values[index];
		_values[index] = value;
		return prev;
	}
	
	public void fill(float value)
	{
		Arrays.fill(_values, value);
	}
	
	public void sort()
	{
		sort(0, _keys.length - 1);
	}
	
	private void sort(int left, int right)
	{
		if (left >= right) return;
		int pivot = _keys[(left + right) / 2];
		int i = left;
		int j = right;
		for (;;) {
			while (_keys[i] < pivot) ++i;
			while (pivot < _keys[j]) --j;
			if (i >= j) break;
			int key = _keys[i]; _keys[i] = _keys[j]; _keys[j] = key;
			float value = _values[i]; _values[i] = _values[j]; _values[j] = value;
			++i;
			--j;
		}
		sort(left,  i - 1);
		sort(j + 1, right);
	}
}
