//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.arrayMaps;

import static jp.sf.l2j.arrayMaps.SortedArrayMap.*;

import java.util.Arrays;
import java.util.Map;
import java.util.Map.Entry;

/*
 * @auther JOJO
 */
public class SortedIntShortArrayMap
{
	private int[] _keys;
	private short[] _values;
	public final short NULL;
	
	public short getNoEntryValue()
	{
		return NULL;
	}
	
	public SortedIntShortArrayMap()
	{
		this(SHORT_NULL);
	}
	
	public SortedIntShortArrayMap(short nullValue)
	{
		this(nullValue, EMPTY_INT_ARRAY, EMPTY_SHORT_ARRAY);
	}
	
	public SortedIntShortArrayMap(int[] keys, short[] values)
	{
		this(SHORT_NULL, keys, values);
	}
	
	public SortedIntShortArrayMap(short nullValue, int[] keys, short[] values)
	{
		NULL = nullValue;
		_keys = keys;
		_values = values;
		sort();
	}
	
	public SortedIntShortArrayMap(Map<Integer, Short> t)
	{
		this(SHORT_NULL, t);
	}
	
	public SortedIntShortArrayMap(short nullValue, Map<Integer, Short> t)
	{
		NULL = nullValue;
		int length = t.size();
		int[] tmpKeys = new int[length];
		short[] tmpValues = new short[length];
		
		Short w;
		int index = 0;
		for (Entry<Integer, Short> e : t.entrySet())
		{
			tmpKeys[index] = e.getKey();
			tmpValues[index] = (w = e.getValue()) == null ? NULL : w;
			++index;
		}
		_keys = tmpKeys;
		_values = tmpValues;
		sort();
	}
	
	public void clear()
	{
		_keys = EMPTY_INT_ARRAY;
		_values = EMPTY_SHORT_ARRAY;
	}
	
	public boolean containsKey(int key)
	{
		return Arrays.binarySearch(_keys, key) >= 0;
	}
	
	public boolean containsValue(short value)
	{
		for (int index = _values.length; --index >= 0;)
			if (_values[index] == value)
				return true;
		return false;
	}
	
	public short get(int key)
	{
		return getOrDefault(key, NULL);
	}
	
	public short getOrDefault(int key, short defaultValue)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return defaultValue;
	}
	
	public boolean isEmpty()
	{
		return _keys.length == 0;
	}
	
	public int[] keySet()
	{
		return _keys;
	}
	
	public int[] keys()
	{
		return _keys;
	}
	
	public short put(int key, short value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0) {
			short prev = _values[index];
			_values[index] = value;
			return prev;
		} else {
			return insertEntry(-(index + 1), key, value);
		}
	}
	
	public short putIfAbsent(int key, short value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return insertEntry(-(index + 1), key, value);
	}
	
	public void putAll(Map<Integer, Short> t)
	{
		for (Entry<Integer, Short> e : t.entrySet())
			put(e.getKey(), e.getValue());
	}
	
	public short remove(int key)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return removeAt(index);
		else
			return NULL;
	}
	
	public int size()
	{
		return _keys.length;
	}
	
	public short[] values()
	{
		return _values;
	}
	
	public SortedIntShortArrayMap append(int key, short value)
	{
		short prev = put(key, value);
		if (prev != NULL) throw new IllegalArgumentException("Duplicate key:" + key + " value:" + value + " previus:" + prev);
		return this;
	}
	
	public SortedIntShortArrayMap add(int key, short value)
	{
		return append(key, value);
	}
	
	private short removeAt(int index)
	{
		final int length = _keys.length - 1;
		if (length < 0)
			return NULL;
		int[] tmpKeys = new int[length];
		short[] tmpValues = new short[length];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index + 1, tmpKeys, index, n);
			System.arraycopy(_values, index + 1, tmpValues, index, n);
		}
		short prev = _values[index];
		_keys = tmpKeys;
		_values = tmpValues;
		return prev;
	}
	
	public int indexOfKey(int key)
	{
		return Arrays.binarySearch(_keys, key);
	}
	
	public int indexOfValue(short value)
	{
		for (int index = 0, length = _values.length; index < length; ++index)
			if (_values[index] == value)
				return index;
		return -1;
	}
	
	private short insertEntry(int index, int key, short value)
	{
		final int length = _keys.length;
		int[] tmpKeys = new int[length + 1];
		short[] tmpValues = new short[length + 1];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		tmpKeys[index] = key;
		tmpValues[index] = value;
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index, tmpKeys, index + 1, n);
			System.arraycopy(_values, index, tmpValues, index + 1, n);
		}
		_keys = tmpKeys;
		_values = tmpValues;
		return NULL;
	}
	
	public int keyAt(int index)
	{
		return _keys[index];
	}
	
	public short valueAt(int index)
	{
		return _values[index];
	}
	
	public int getKey(int index)
	{
		return keyAt(index);
	}
	
	public short getValue(int index)
	{
		return valueAt(index);
	}
	
	public short setValue(int index, short value)
	{
		short prev = _values[index];
		_values[index] = value;
		return prev;
	}
	
	public void fill(short value)
	{
		Arrays.fill(_values, value);
	}
	
	public void sort()
	{
		sort(0, _keys.length - 1);
	}
	
	private void sort(int left, int right)
	{
		if (left >= right) return;
		int pivot = _keys[(left + right) / 2];
		int i = left;
		int j = right;
		for (;;) {
			while (_keys[i] < pivot) ++i;
			while (pivot < _keys[j]) --j;
			if (i >= j) break;
			int key = _keys[i]; _keys[i] = _keys[j]; _keys[j] = key;
			short value = _values[i]; _values[i] = _values[j]; _values[j] = value;
			++i;
			--j;
		}
		sort(left,  i - 1);
		sort(j + 1, right);
	}
}
