//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.arrayMaps;

import static jp.sf.l2j.arrayMaps.SortedArrayMap.*;

import java.util.Arrays;
import java.util.Map;
import java.util.Map.Entry;

/*
 * @auther JOJO
 */
public class SortedLongDoubleArrayMap
{
	private long[] _keys;
	private double[] _values;
	public final double NULL;
	
	public double getNoEntryValue()
	{
		return NULL;
	}
	
	public SortedLongDoubleArrayMap()
	{
		this(DOUBLE_NULL);
	}
	
	public SortedLongDoubleArrayMap(double nullValue)
	{
		this(nullValue, EMPTY_LONG_ARRAY, EMPTY_DOUBLE_ARRAY);
	}
	
	public SortedLongDoubleArrayMap(long[] keys, double[] values)
	{
		this(DOUBLE_NULL, keys, values);
	}
	
	public SortedLongDoubleArrayMap(double nullValue, long[] keys, double[] values)
	{
		NULL = nullValue;
		_keys = keys;
		_values = values;
		sort();
	}
	
	public SortedLongDoubleArrayMap(Map<Long, Double> t)
	{
		this(DOUBLE_NULL, t);
	}
	
	public SortedLongDoubleArrayMap(double nullValue, Map<Long, Double> t)
	{
		NULL = nullValue;
		int length = t.size();
		long[] tmpKeys = new long[length];
		double[] tmpValues = new double[length];
		
		Double w;
		int index = 0;
		for (Entry<Long, Double> e : t.entrySet())
		{
			tmpKeys[index] = e.getKey();
			tmpValues[index] = (w = e.getValue()) == null ? NULL : w;
			++index;
		}
		_keys = tmpKeys;
		_values = tmpValues;
		sort();
	}
	
	public void clear()
	{
		_keys = EMPTY_LONG_ARRAY;
		_values = EMPTY_DOUBLE_ARRAY;
	}
	
	public boolean containsKey(long key)
	{
		return Arrays.binarySearch(_keys, key) >= 0;
	}
	
	public boolean containsValue(double value)
	{
		for (int index = _values.length; --index >= 0;)
			if (_values[index] == value)
				return true;
		return false;
	}
	
	public double get(long key)
	{
		return getOrDefault(key, NULL);
	}
	
	public double getOrDefault(long key, double defaultValue)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return defaultValue;
	}
	
	public boolean isEmpty()
	{
		return _keys.length == 0;
	}
	
	public long[] keySet()
	{
		return _keys;
	}
	
	public long[] keys()
	{
		return _keys;
	}
	
	public double put(long key, double value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0) {
			double prev = _values[index];
			_values[index] = value;
			return prev;
		} else {
			return insertEntry(-(index + 1), key, value);
		}
	}
	
	public double putIfAbsent(long key, double value)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return _values[index];
		else
			return insertEntry(-(index + 1), key, value);
	}
	
	public void putAll(Map<Long, Double> t)
	{
		for (Entry<Long, Double> e : t.entrySet())
			put(e.getKey(), e.getValue());
	}
	
	public double remove(long key)
	{
		int index = Arrays.binarySearch(_keys, key);
		if (index >= 0)
			return removeAt(index);
		else
			return NULL;
	}
	
	public int size()
	{
		return _keys.length;
	}
	
	public double[] values()
	{
		return _values;
	}
	
	public SortedLongDoubleArrayMap append(long key, double value)
	{
		double prev = put(key, value);
		if (prev != NULL) throw new IllegalArgumentException("Duplicate key:" + key + " value:" + value + " previus:" + prev);
		return this;
	}
	
	public SortedLongDoubleArrayMap add(long key, double value)
	{
		return append(key, value);
	}
	
	private double removeAt(int index)
	{
		final int length = _keys.length - 1;
		if (length < 0)
			return NULL;
		long[] tmpKeys = new long[length];
		double[] tmpValues = new double[length];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index + 1, tmpKeys, index, n);
			System.arraycopy(_values, index + 1, tmpValues, index, n);
		}
		double prev = _values[index];
		_keys = tmpKeys;
		_values = tmpValues;
		return prev;
	}
	
	public int indexOfKey(long key)
	{
		return Arrays.binarySearch(_keys, key);
	}
	
	public int indexOfValue(double value)
	{
		for (int index = 0, length = _values.length; index < length; ++index)
			if (_values[index] == value)
				return index;
		return -1;
	}
	
	private double insertEntry(int index, long key, double value)
	{
		final int length = _keys.length;
		long[] tmpKeys = new long[length + 1];
		double[] tmpValues = new double[length + 1];
		if (index > 0) {
			System.arraycopy(_keys, 0, tmpKeys, 0, index);
			System.arraycopy(_values, 0, tmpValues, 0, index);
		}
		tmpKeys[index] = key;
		tmpValues[index] = value;
		int n;
		if ((n = length - index) > 0) {
			System.arraycopy(_keys, index, tmpKeys, index + 1, n);
			System.arraycopy(_values, index, tmpValues, index + 1, n);
		}
		_keys = tmpKeys;
		_values = tmpValues;
		return NULL;
	}
	
	public long keyAt(int index)
	{
		return _keys[index];
	}
	
	public double valueAt(int index)
	{
		return _values[index];
	}
	
	public long getKey(int index)
	{
		return keyAt(index);
	}
	
	public double getValue(int index)
	{
		return valueAt(index);
	}
	
	public double setValue(int index, double value)
	{
		double prev = _values[index];
		_values[index] = value;
		return prev;
	}
	
	public void fill(double value)
	{
		Arrays.fill(_values, value);
	}
	
	public void sort()
	{
		sort(0, _keys.length - 1);
	}
	
	private void sort(int left, int right)
	{
		if (left >= right) return;
		long pivot = _keys[(left + right) / 2];
		int i = left;
		int j = right;
		for (;;) {
			while (_keys[i] < pivot) ++i;
			while (pivot < _keys[j]) --j;
			if (i >= j) break;
			long key = _keys[i]; _keys[i] = _keys[j]; _keys[j] = key;
			double value = _values[i]; _values[i] = _values[j]; _values[j] = value;
			++i;
			--j;
		}
		sort(left,  i - 1);
		sort(j + 1, right);
	}
}
