//@formatter:off
/*
 * Auther: tukune
 * 
 * DON'T CODE FORMAT!
 * DON'T CONVERT TAB <---> SPACE
 * DON'T STRIP TRAILING BLANKS FROM END OF LINE
 */
package jp.sf.l2j.boundArrays;

import java.util.Arrays;
import java.util.Collection;

/**
 * @author JOJO
 */
public class BoundObjectArray<E>
{
	private E[] elementData;
	private int lbound;
	
	public BoundObjectArray(@SuppressWarnings("unchecked") E... values) { this(0, values); }
	
	public BoundObjectArray(int lbound, @SuppressWarnings("unchecked") E... values) {
		this.lbound = lbound;
		elementData = values.length == 0 ? values : Arrays.copyOf(values, 0);
	}
	
	public BoundObjectArray<E> to(int ubound) {
		final int s = ubound - lbound + 1;
		if (s != elementData.length)
			elementData = Arrays.copyOf(elementData, s);
		return this;
	}
	
	private void grow(int newSize) { elementData = Arrays.copyOf(elementData, newSize); }
	
	public int size() { return elementData.length; }
	
	public boolean isEmpty() { return elementData.length == 0; }
	
	public int lbound() { return lbound; }
	
	public int ubound() { return lbound + elementData.length - 1; }
	
	public boolean contains(E element) { return indexOf(element) >= 0; }
	
	public boolean containsKey(int index) {
	//	return lbound() <= index && index <= ubound();
		int pos = index - lbound;
		return 0 <= pos && pos < elementData.length;
	}
	
	public int indexOf(E element) {
		if (element == null) {
			for (int pos = 0; pos < elementData.length; ++pos)
				if (null == elementData[pos])
					return pos;
		} else {
			for (int pos = 0; pos < elementData.length; ++pos)
				if (element.equals(elementData[pos]))
					return pos;
		}
		return -1;
	}
	
	public int lastIndexOf(E element) {
		if (element == null) {
			for (int pos = elementData.length; --pos >= 0;)
				if (null == elementData[pos])
					return pos;
		} else {
			for (int pos = elementData.length; --pos >= 0;)
				if (element.equals(elementData[pos]))
					return pos;
		}
		return -1;
	}
	
	public Object[] toArray() { return Arrays.copyOf(elementData, elementData.length); }
	
	public E get(int index) {
		final int pos = index - lbound;
		return pos >= 0 && pos < elementData.length ? (E) elementData[pos] : null;
	}
	
	public E set(int index, E element) {
		final int pos = index - lbound;
		final E p = (E) elementData[pos];
		elementData[pos] = element;
		return p;
	}
	
	public E put(int index, E element) {
		final int size = elementData.length;
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			grow(size + 1);
	//sure! else if (pos < 0 || pos > size) throw new ArrayIndexOutOfBoundsException();
		final E p = (E) elementData[pos];
		elementData[pos] = element;
		return p;
	}
	
	public BoundObjectArray<E> append(int index, E element) {
		final int size = elementData.length;
		if (size == 0 && lbound == 0)
			lbound = index;
		final int pos = index - lbound;
		if (pos == size)
			grow(size + 1);
	//sure! else if (pos < 0 || pos > size) throw new ArrayIndexOutOfBoundsException();
		elementData[pos] = element;
		return this;
	}
	
	public BoundObjectArray<E> append(E element) {
		final int size = elementData.length;
		final int pos = size;
		grow(size + 1);
		elementData[pos] = element;
		return this;
	}
	
	public void clear() { elementData = Arrays.copyOf(elementData, 0); }
	
	public boolean addAll(E[] a) {
		final int size = elementData.length;
		final int numNew = a.length;
		grow(size + numNew);
		System.arraycopy(a, 0, elementData, size, numNew);
		return numNew != 0;
	}
	
	@SuppressWarnings("unchecked")
	public boolean addAll(Collection<E/*=>TODO:? extends V*/> c) { return addAll((E[]) c.toArray()); }
	
	public void fill(E element) { Arrays.fill(elementData, element); }
	
	public E[] values() { return elementData; }
}
