/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.core;

import com.sun.corba.se.internal.corba.ORB;
import com.sun.corba.se.internal.core.DuplicateServiceContext;
import com.sun.corba.se.internal.core.NoSuchServiceContext;
import com.sun.corba.se.internal.core.ServiceContext;
import com.sun.corba.se.internal.core.ServiceContextData;
import com.sun.corba.se.internal.core.ServiceContextRegistry;
import com.sun.corba.se.internal.core.UnknownServiceContext;
import com.sun.corba.se.internal.iiop.CDRInputStream;
import com.sun.corba.se.internal.iiop.CDROutputStream;
import com.sun.corba.se.internal.iiop.IIOPConnection;
import com.sun.corba.se.internal.iiop.IIOPInputStream;
import com.sun.corba.se.internal.util.Utility;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ServiceContexts {
    private static final int JAVAIDL_ALIGN_SERVICE_ID = -1106033203;
    private ORB orb;
    private Map scMap;
    private boolean addAlignmentOnWrite;
    private IIOPConnection connection;

    private static boolean isDebugging(OutputStream outputStream) {
        CDROutputStream cDROutputStream = (CDROutputStream)outputStream;
        ORB oRB = (ORB)cDROutputStream.getORB();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private static boolean isDebugging(InputStream inputStream) {
        CDRInputStream cDRInputStream = (CDRInputStream)inputStream;
        ORB oRB = (ORB)cDRInputStream.getORB();
        if (oRB == null) {
            return false;
        }
        return oRB.serviceContextDebugFlag;
    }

    private void dprint(String string) {
        Utility.dprint(this, string);
    }

    public static void writeNullServiceContext(OutputStream outputStream) {
        if (ServiceContexts.isDebugging(outputStream)) {
            Utility.dprint("ServiceContexts", "Writing null service context");
        }
        outputStream.write_long(0);
    }

    private void createMapFromInputStream(InputStream inputStream) {
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Constructing ServiceContexts from input stream");
        }
        int n = inputStream.read_long();
        if (this.orb.serviceContextDebugFlag) {
            this.dprint("Number of service contexts = " + n);
        }
        this.scMap = new HashMap(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read_long();
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Reading service context id " + n3);
            }
            byte[] byArray = OctetSeqHelper.read(inputStream);
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Service context" + n3 + " length: " + byArray.length);
            }
            this.scMap.put(new Integer(n3), byArray);
            ++n2;
        }
    }

    public ServiceContexts(InputStream inputStream) {
        this.addAlignmentOnWrite = false;
        this.orb = (ORB)inputStream.orb();
        this.connection = (IIOPConnection)((IIOPInputStream)inputStream).getConnection();
        this.createMapFromInputStream(inputStream);
    }

    private ServiceContext unmarshal(Integer n, byte[] byArray) {
        ServiceContextRegistry serviceContextRegistry = this.orb.getServiceContextRegistry();
        ServiceContextData serviceContextData = serviceContextRegistry.findServiceContextData(n);
        ServiceContext serviceContext = null;
        if (serviceContextData == null) {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Could not find ServiceContextData for " + n + " using UnknownServiceContext");
            }
            serviceContext = new UnknownServiceContext((int)n, byArray);
        } else {
            if (this.orb.serviceContextDebugFlag) {
                this.dprint("Found " + serviceContextData);
            }
            CDRInputStream cDRInputStream = new CDRInputStream(this.orb, byArray, byArray.length);
            cDRInputStream.consumeEndian();
            if (this.connection != null) {
                cDRInputStream.setCodeBaseFromConnection(this.connection);
            }
            try {
                serviceContext = serviceContextData.makeServiceContext(cDRInputStream);
            }
            catch (NoSuchServiceContext noSuchServiceContext) {
                throw new INTERNAL(noSuchServiceContext.toString());
            }
        }
        return serviceContext;
    }

    public ServiceContexts(ORB oRB) {
        this.orb = oRB;
        this.scMap = new HashMap();
        this.addAlignmentOnWrite = false;
    }

    public void addAlignmentPadding() {
        this.addAlignmentOnWrite = true;
    }

    public void write(OutputStream outputStream) {
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Writing service contexts to output stream");
            Utility.printStackTrace();
        }
        int n = this.scMap.size();
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Adding alignment padding");
            }
            ++n;
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context has " + n + " components");
        }
        outputStream.write_long(n);
        this.writeServiceContextsInOrder(outputStream);
        if (this.addAlignmentOnWrite) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing alignment padding");
            }
            outputStream.write_long(-1106033203);
            outputStream.write_long(4);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
            outputStream.write_octet((byte)0);
        }
        if (ServiceContexts.isDebugging(outputStream)) {
            this.dprint("Service context writing complete");
        }
    }

    private void writeServiceContextsInOrder(OutputStream outputStream) {
        Integer n = new Integer(9);
        Object object = this.scMap.remove(n);
        Iterator iterator = this.scMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            this.writeMapEntry(outputStream, n2, this.scMap.get(n2));
        }
        if (object != null) {
            this.writeMapEntry(outputStream, n, object);
            this.scMap.put(n, object);
        }
    }

    private void writeMapEntry(OutputStream outputStream, Integer n, Object object) {
        if (object instanceof byte[]) {
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context bytes for id " + n);
            }
            OctetSeqHelper.write(outputStream, (byte[])object);
        } else {
            ServiceContext serviceContext = (ServiceContext)object;
            if (ServiceContexts.isDebugging(outputStream)) {
                this.dprint("Writing service context " + serviceContext);
            }
            serviceContext.write(outputStream);
        }
    }

    public void put(ServiceContext serviceContext) throws DuplicateServiceContext {
        Integer n = new Integer(serviceContext.getId());
        Object object = this.scMap.get(n);
        if (object != null) {
            throw new DuplicateServiceContext(n.toString());
        }
        this.scMap.put(n, serviceContext);
    }

    public void delete(int n) throws NoSuchServiceContext {
        this.delete(new Integer(n));
    }

    public void delete(Integer n) throws NoSuchServiceContext {
        if (this.scMap.remove(n) == null) {
            throw new NoSuchServiceContext(n.toString());
        }
    }

    public ServiceContext get(int n) throws NoSuchServiceContext {
        return this.get(new Integer(n));
    }

    public ServiceContext get(Integer n) throws NoSuchServiceContext {
        Object object = this.scMap.get(n);
        if (object == null) {
            throw new NoSuchServiceContext();
        }
        if (object instanceof byte[]) {
            ServiceContext serviceContext = this.unmarshal(n, (byte[])object);
            this.scMap.put(n, serviceContext);
            return serviceContext;
        }
        return (ServiceContext)object;
    }
}

