/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.io.ValidationCallback;
import java.io.WriteAbortedException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;

public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private InputStream in;
    private int count;
    private boolean blockDataMode;
    private byte[] buf;
    private int bufpos;
    private int bufsize;
    private DataInputStream dis;
    private IOException abortIOException = null;
    private ClassNotFoundException abortClassNotFoundException = null;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Class currentClass;
    private Object currentGetFields;
    private byte[] data = new byte[1024];
    private char[] cdata = new char[50];
    private static final int CDATA_MAX_LEN = 1000;
    private StringBuffer sbuf = new StringBuffer();
    ObjectStreamClass[] classdesc;
    Class[] classes;
    int spClass;
    private ArrayList wireHandle2Object;
    private int nextWireOffset;
    private ArrayList callbacks;
    private int recursionDepth;
    private byte currCode;
    boolean enableResolve;
    private boolean enableSubclassImplementation;
    private Object[] readObjectArglist = new Object[]{this};
    static /* synthetic */ Class class$java$io$Serializable;

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.enableSubclassImplementation = false;
        this.in = inputStream;
        this.buf = new byte[8];
        this.dis = new DataInputStream(this);
        this.readStreamHeader();
        this.resetStream();
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ObjectStreamConstants.SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.enableSubclassImplementation = true;
    }

    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        if (this.enableSubclassImplementation) {
            return this.readObjectOverride();
        }
        return this.readObject(true);
    }

    protected Object readObjectOverride() throws OptionalDataException, ClassNotFoundException, IOException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Object readObject(boolean bl) throws OptionalDataException, ClassNotFoundException, IOException {
        Object object;
        block48: {
            if (this.blockDataMode) {
                if (this.count == 0) {
                    this.refill();
                }
                if (this.count > 0) {
                    throw new OptionalDataException(this.count);
                }
            }
            this.peekCode();
            Object object2 = this.currentObject;
            ObjectStreamClass objectStreamClass = this.currentClassDesc;
            boolean bl2 = this.setBlockData(false);
            ++this.recursionDepth;
            object = null;
            byte by = this.readCode();
            try {
                try {
                    int n = -1;
                    switch (by) {
                        case 112: {
                            object = null;
                            break;
                        }
                        case 113: {
                            n = this.readInt() - 0x7E0000;
                            try {
                                object = this.wireHandle2Object.get(n);
                                break;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw new StreamCorruptedException("Reference to object never serialized.");
                            }
                        }
                        case 116: 
                        case 124: {
                            long l = by == 116 ? (long)this.readUnsignedShort() : this.readLong();
                            Object object3 = object = this.readUTFBody(l);
                            n = this.assignWireOffset(object);
                            if (this.enableResolve) {
                                object = this.resolveObject(object);
                            }
                            if (object != object3) {
                                this.wireHandle2Object.set(n, object);
                            }
                            break;
                        }
                        case 118: {
                            ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject(bl);
                            if (objectStreamClass2 == null) {
                                throw new StreamCorruptedException("Class not in stream");
                            }
                            object = objectStreamClass2.forClass();
                            if (object == null && bl) {
                                throw objectStreamClass2.pendingException;
                            }
                            this.assignWireOffset(object);
                            break;
                        }
                        case 114: {
                            object = this.inputClassDescriptor();
                            break;
                        }
                        case 125: {
                            object = this.inputProxyClassDescriptor();
                            break;
                        }
                        case 117: {
                            n = this.inputArray(bl);
                            object = this.currentObject;
                            if (this.enableResolve) {
                                object = this.resolveObject(object);
                            }
                            if (object != this.currentObject) {
                                this.wireHandle2Object.set(n, object);
                            }
                            break;
                        }
                        case 115: {
                            n = this.inputObject(bl);
                            object = this.currentObject;
                            if (this.currentObject != null && this.currentClassDesc != null && this.currentClassDesc.isResolvable()) {
                                object = ObjectStreamClass.invokeMethod(this.currentClassDesc.readResolveMethod, object, null);
                            }
                            if (this.enableResolve) {
                                object = this.resolveObject(object);
                            }
                            if (object != this.currentObject) {
                                this.wireHandle2Object.set(n, object);
                            }
                            break;
                        }
                        case 120: {
                            if (!bl2) {
                                throw new StreamCorruptedException("Unexpected end of block data");
                            }
                            this.pushbackCode((byte)120);
                            this.count = -1;
                            throw new OptionalDataException(true);
                        }
                        case 119: 
                        case 122: {
                            if (by == 122) {
                                int n2;
                                int n3;
                                int n4;
                                int n5 = this.in.read();
                                if ((n5 | (n4 = this.in.read()) | (n3 = this.in.read()) | (n2 = this.in.read())) < 0) {
                                    throw new StreamCorruptedException("EOF expecting count");
                                }
                                this.count = n5 << 24 | n4 << 16 | n3 << 8 | n2;
                                if (this.count < 0) {
                                    throw new StreamCorruptedException("Negative block data size");
                                }
                            } else {
                                this.count = this.in.read();
                                if (this.count < 0) {
                                    throw new StreamCorruptedException("EOF expecting count");
                                }
                            }
                            if (!bl2) {
                                throw new StreamCorruptedException("Unexpected blockdata");
                            }
                            throw new OptionalDataException(this.count);
                        }
                        case 123: {
                            this.resetStream();
                            IOException iOException = (IOException)this.readObject();
                            this.resetStream();
                            throw new WriteAbortedException("Writing aborted by exception", iOException);
                        }
                        default: {
                            throw new StreamCorruptedException("Unknown code in readObject " + by);
                        }
                    }
                }
                catch (OptionalDataException optionalDataException) {
                    throw optionalDataException;
                }
                catch (IOException iOException) {
                    if (this.abortIOException == null && this.abortClassNotFoundException == null) {
                        this.abortIOException = iOException;
                    }
                    Object var14_24 = null;
                    --this.recursionDepth;
                    this.currentObject = object2;
                    this.currentClassDesc = objectStreamClass;
                    this.currentClass = this.currentClassDesc != null ? this.currentClassDesc.forClass() : null;
                    this.setBlockData(bl2);
                    break block48;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (this.abortIOException == null && this.abortClassNotFoundException == null) {
                        this.abortClassNotFoundException = classNotFoundException;
                    }
                    Object var14_25 = null;
                    --this.recursionDepth;
                    this.currentObject = object2;
                    this.currentClassDesc = objectStreamClass;
                    this.currentClass = this.currentClassDesc != null ? this.currentClassDesc.forClass() : null;
                    this.setBlockData(bl2);
                }
                Object var14_23 = null;
                --this.recursionDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
                this.currentClass = this.currentClassDesc != null ? this.currentClassDesc.forClass() : null;
                this.setBlockData(bl2);
            }
            catch (Throwable throwable) {
                Object var14_26 = null;
                --this.recursionDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
                this.currentClass = this.currentClassDesc != null ? this.currentClassDesc.forClass() : null;
                this.setBlockData(bl2);
                throw throwable;
            }
        }
        IOException iOException = this.abortIOException;
        if (this.recursionDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            throw iOException;
        }
        ClassNotFoundException classNotFoundException = this.abortClassNotFoundException;
        if (this.recursionDepth == 0) {
            this.abortClassNotFoundException = null;
        }
        if (classNotFoundException != null) {
            throw classNotFoundException;
        }
        if (this.recursionDepth == 0) {
            this.doValidations();
        }
        return object;
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultReadObject");
        }
        ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
        if (objectStreamFieldArray.length > 0) {
            boolean bl = this.setBlockData(false);
            this.inputClassFields(this.currentObject, this.currentClass, objectStreamFieldArray);
            this.setBlockData(bl);
        }
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultReadObject");
        }
        GetFieldImpl getFieldImpl = new GetFieldImpl(this.currentClassDesc);
        this.currentGetFields = getFieldImpl;
        boolean bl = this.setBlockData(false);
        getFieldImpl.read(this);
        this.setBlockData(bl);
        return getFieldImpl;
    }

    public synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        if (this.recursionDepth == 0) {
            throw new NotActiveException("readObject not Active");
        }
        if (objectInputValidation == null) {
            throw new InvalidObjectException("Null is not a valid callback object");
        }
        ValidationCallback validationCallback = new ValidationCallback(objectInputValidation, n);
        if (this.callbacks == null) {
            this.callbacks = new ArrayList();
        }
        if (this.callbacks.isEmpty() || ((ValidationCallback)this.callbacks.get((int)(this.callbacks.size() - 1))).priority >= n) {
            this.callbacks.add(validationCallback);
            return;
        }
        int n2 = this.callbacks.size();
        int n3 = 0;
        while (n3 < n2) {
            ValidationCallback validationCallback2 = (ValidationCallback)this.callbacks.get(n3);
            if (validationCallback2.priority <= n) {
                this.callbacks.add(n3, validationCallback);
                break;
            }
            ++n3;
        }
    }

    private void doValidations() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        int n = this.callbacks.size();
        int n2 = 0;
        while (n2 < n) {
            ValidationCallback validationCallback = (ValidationCallback)this.callbacks.get(n2);
            validationCallback.callback.validateObject();
            ++n2;
        }
        this.callbacks.clear();
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = ObjectInputStream.latestUserDefinedLoader();
        return Class.forName(objectStreamClass.getName(), false, classLoader);
    }

    protected Class resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = ObjectInputStream.latestUserDefinedLoader();
        Class[] classArray = new Class[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            classArray[n] = Class.forName(stringArray[n], false, classLoader);
            ++n;
        }
        try {
            return Proxy.getProxyClass(classLoader, classArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClassNotFoundException(null, illegalArgumentException);
        }
    }

    private static native ClassLoader latestUserDefinedLoader() throws ClassNotFoundException;

    private Class loadClass0(Class clazz, String string) throws ClassNotFoundException {
        ClassLoader classLoader = clazz != null ? clazz.getClassLoader() : ObjectInputStream.latestUserDefinedLoader();
        return Class.forName(string, false, classLoader);
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableResolve;
        if (bl) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(ObjectStreamConstants.SUBSTITUTION_PERMISSION);
            }
            this.enableResolve = true;
        } else {
            this.enableResolve = false;
        }
        return bl2;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = 0;
        short s2 = 0;
        try {
            s = this.readShort();
            s2 = this.readShort();
        }
        catch (EOFException eOFException) {
            throw new StreamCorruptedException("Caught EOFException while reading the stream header");
        }
        if (s != -21267) {
            throw new StreamCorruptedException("InputStream does not contain a serialized object");
        }
        if (s2 != 5) {
            throw new StreamCorruptedException("Version Mismatch, Expected 5 and got " + s2);
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        String string = this.readUTF();
        long l = this.readLong();
        ObjectStreamClass objectStreamClass = new ObjectStreamClass(string, l);
        objectStreamClass.read(this);
        return objectStreamClass;
    }

    private ObjectStreamClass inputClassDescriptor() throws IOException, InvalidClassException, ClassNotFoundException {
        Class clazz;
        ObjectStreamClass objectStreamClass = new ObjectStreamClass(null, 0L);
        int n = this.assignWireOffset(objectStreamClass);
        ObjectStreamClass objectStreamClass2 = this.readClassDescriptor();
        objectStreamClass.lightCopy(objectStreamClass2);
        boolean bl = this.setBlockData(true);
        try {
            clazz = this.resolveClass(objectStreamClass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
            objectStreamClass.pendingException = classNotFoundException;
        }
        this.skipToEndOfBlockData();
        bl = this.setBlockData(bl);
        objectStreamClass.setClass(clazz);
        ObjectStreamClass objectStreamClass3 = (ObjectStreamClass)this.readObject();
        objectStreamClass.setSuperclass(objectStreamClass3);
        return objectStreamClass;
    }

    private ObjectStreamClass inputProxyClassDescriptor() throws IOException, InvalidClassException, ClassNotFoundException {
        Class clazz;
        ObjectStreamClass objectStreamClass = new ObjectStreamClass("", 0L);
        int n = this.assignWireOffset(objectStreamClass);
        int n2 = this.readInt();
        String[] stringArray = new String[n2];
        int n3 = 0;
        while (n3 < n2) {
            stringArray[n3] = this.readUTF();
            ++n3;
        }
        boolean bl = this.setBlockData(true);
        try {
            clazz = this.resolveProxyClass(stringArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
            objectStreamClass.pendingException = classNotFoundException;
        }
        this.skipToEndOfBlockData();
        bl = this.setBlockData(bl);
        objectStreamClass.initProxyClassDesc(clazz);
        objectStreamClass.setClass(clazz);
        ObjectStreamClass objectStreamClass2 = (ObjectStreamClass)this.readObject();
        objectStreamClass.setSuperclass(objectStreamClass2);
        return objectStreamClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int inputArray(boolean bl) throws IOException, ClassNotFoundException {
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
        Class clazz = objectStreamClass.forClass();
        if (clazz == null && bl) {
            throw objectStreamClass.pendingException;
        }
        int n = this.readInt();
        this.currentObject = clazz == null ? null : ObjectInputStream.allocateNewArray(clazz, n);
        int n2 = this.assignWireOffset(this.currentObject);
        if (clazz != null && clazz.getComponentType().isPrimitive()) {
            Class clazz2 = clazz.getComponentType();
            int n3 = this.data.length;
            int n4 = this.data.length;
            if (clazz2 == Boolean.TYPE) {
                boolean[] blArray = (boolean[])this.currentObject;
                int n5 = 0;
                while (n5 < n) {
                    if (n3 >= n4) {
                        int n6 = Math.min(n - n5, n4);
                        this.readFully(this.data, 0, n6);
                        n3 = 0;
                    }
                    blArray[n5] = this.data[n3] != 0;
                    ++n3;
                    ++n5;
                }
                return n2;
            } else if (clazz2 == Byte.TYPE) {
                byte[] byArray = (byte[])this.currentObject;
                int n7 = 0;
                while (n7 < n) {
                    int n8 = Math.min(n - n7, n4);
                    this.readFully(this.data, 0, n8);
                    System.arraycopy(this.data, 0, byArray, n7, n8);
                    n7 += n8;
                }
                return n2;
            } else if (clazz2 == Short.TYPE) {
                short[] sArray = (short[])this.currentObject;
                int n9 = 0;
                while (n9 < n) {
                    if (n3 > n4 - 2) {
                        int n10 = Math.min((n - n9) * 2, n4);
                        this.readFully(this.data, 0, n10);
                        n3 = 0;
                    }
                    sArray[n9] = (short)(((this.data[n3] & 0xFF) << 8) + ((this.data[n3 + 1] & 0xFF) << 0));
                    n3 += 2;
                    ++n9;
                }
                return n2;
            } else if (clazz2 == Integer.TYPE) {
                int[] nArray = (int[])this.currentObject;
                int n11 = 0;
                while (n11 < n) {
                    if (n3 > n4 - 4) {
                        int n12 = Math.min(n - n11 << 2, n4);
                        this.readFully(this.data, 0, n12);
                        n3 = 0;
                    }
                    nArray[n11] = ((this.data[n3] & 0xFF) << 24) + ((this.data[n3 + 1] & 0xFF) << 16) + ((this.data[n3 + 2] & 0xFF) << 8) + ((this.data[n3 + 3] & 0xFF) << 0);
                    n3 += 4;
                    ++n11;
                }
                return n2;
            } else if (clazz2 == Long.TYPE) {
                long[] lArray = (long[])this.currentObject;
                int n13 = 0;
                while (n13 < n) {
                    int n14;
                    if (n3 > n4 - 8) {
                        n14 = Math.min(n - n13 << 3, n4);
                        this.readFully(this.data, 0, n14);
                        n3 = 0;
                    }
                    n14 = ((this.data[n3] & 0xFF) << 24) + ((this.data[n3 + 1] & 0xFF) << 16) + ((this.data[n3 + 2] & 0xFF) << 8) + ((this.data[n3 + 3] & 0xFF) << 0);
                    int n15 = ((this.data[n3 + 4] & 0xFF) << 24) + ((this.data[n3 + 5] & 0xFF) << 16) + ((this.data[n3 + 6] & 0xFF) << 8) + ((this.data[n3 + 7] & 0xFF) << 0);
                    lArray[n13] = ((long)n14 << 32) + ((long)n15 & 0xFFFFFFFFL);
                    n3 += 8;
                    ++n13;
                }
                return n2;
            } else if (clazz2 == Float.TYPE) {
                float[] fArray = (float[])this.currentObject;
                int n16 = 0;
                while (n16 < n) {
                    int n17 = Math.min(n - n16, n4 >> 2);
                    this.readFully(this.data, 0, n17 << 2);
                    ObjectInputStream.bytesToFloats(this.data, 0, fArray, n16, n17);
                    n16 += n17;
                }
                return n2;
            } else if (clazz2 == Double.TYPE) {
                double[] dArray = (double[])this.currentObject;
                int n18 = 0;
                while (n18 < n) {
                    int n19 = Math.min(n - n18, n4 >> 3);
                    this.readFully(this.data, 0, n19 << 3);
                    ObjectInputStream.bytesToDoubles(this.data, 0, dArray, n18, n19);
                    n18 += n19;
                }
                return n2;
            } else {
                if (clazz2 != Character.TYPE) throw new InvalidClassException(clazz.getName());
                char[] cArray = (char[])this.currentObject;
                int n20 = 0;
                while (n20 < n) {
                    if (n3 > n4 - 2) {
                        int n21 = Math.min((n - n20) * 2, n4);
                        this.readFully(this.data, 0, n21);
                        n3 = 0;
                    }
                    cArray[n20] = (char)(((this.data[n3] & 0xFF) << 8) + ((this.data[n3 + 1] & 0xFF) << 0));
                    n3 += 2;
                    ++n20;
                }
            }
            return n2;
        } else {
            Object[] objectArray = (Object[])this.currentObject;
            boolean bl2 = clazz != null;
            int n22 = 0;
            while (n22 < n) {
                Object object = this.readObject(bl2);
                if (objectArray != null) {
                    objectArray[n22] = object;
                }
                ++n22;
            }
        }
        return n2;
    }

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int inputObject(boolean bl) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        Class clazz;
        ObjectStreamClass objectStreamClass;
        int n3 = -1;
        this.currentClassDesc = (ObjectStreamClass)this.readObject();
        this.currentClass = this.currentClassDesc.forClass();
        if (this.currentClass == null && bl) {
            throw this.currentClassDesc.pendingException;
        }
        if (bl) {
            this.currentClassDesc.verifyInstanceDeserialization();
        }
        if (this.currentClassDesc.isExternalizable()) {
            try {
                this.currentObject = this.currentClass == null ? null : ObjectInputStream.allocateNewObject(this.currentClass, this.currentClass);
                n3 = this.assignWireOffset(this.currentObject);
                boolean bl2 = this.blockDataMode;
                try {
                    if (this.currentClassDesc.hasExternalizableBlockDataMode()) {
                        bl2 = this.setBlockData(true);
                    }
                    if (this.currentObject != null) {
                        Externalizable externalizable = (Externalizable)this.currentObject;
                        externalizable.readExternal(this);
                    }
                    Object var6_9 = null;
                    if (!this.currentClassDesc.hasExternalizableBlockDataMode()) return n3;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    if (!this.currentClassDesc.hasExternalizableBlockDataMode()) throw throwable;
                    this.skipToEndOfBlockData();
                    this.setBlockData(bl2);
                    throw throwable;
                }
                this.skipToEndOfBlockData();
                this.setBlockData(bl2);
                return n3;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new InvalidClassException(this.currentClass.getName() + "Missing no-arg constructor for class");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InvalidClassException(this.currentClass.getName(), "IllegalAccessException");
            }
            catch (InstantiationException instantiationException) {
                throw new InvalidClassException(this.currentClass.getName(), "InstantiationException");
            }
        }
        if (this.currentClassDesc.ancestors == null) {
            objectStreamClass = this.currentClassDesc;
            clazz = this.currentClass;
            n2 = this.spClass;
            objectStreamClass = this.currentClassDesc;
            clazz = this.currentClass;
            while (objectStreamClass != null) {
                Class clazz2 = objectStreamClass.forClass();
                Class clazz3 = clazz;
                while (clazz3 != null) {
                    if (clazz2 == clazz3) break;
                    clazz3 = clazz3.getSuperclass();
                }
                if (this.spClass >= this.classes.length) {
                    this.growClassStacks();
                }
                if (clazz3 == null) {
                    this.classdesc[this.spClass] = objectStreamClass;
                    this.classes[this.spClass] = null;
                } else {
                    this.classdesc[this.spClass] = objectStreamClass;
                    this.classes[this.spClass] = clazz3;
                    clazz = clazz3.getSuperclass();
                }
                ++this.spClass;
                objectStreamClass = objectStreamClass.superclass;
            }
            if (clazz != null) {
                while ((class$java$io$Serializable == null ? ObjectInputStream.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(clazz)) {
                    clazz = clazz.getSuperclass();
                }
            }
            n = this.spClass - n2;
            this.currentClassDesc.ancestors = new Class[n + 1];
            int n4 = 0;
            while (n4 < n) {
                this.currentClassDesc.ancestors[n4] = this.classes[n2 + n4];
                ++n4;
            }
            this.currentClassDesc.ancestors[n] = clazz;
            this.spClass = n2;
        }
        n = this.currentClassDesc.ancestors.length - 1;
        clazz = this.currentClassDesc.ancestors[n];
        try {
            this.currentObject = this.currentClass == null ? null : ObjectInputStream.allocateNewObject(this.currentClass, clazz);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new InvalidClassException(clazz.getName() + "Missing no-arg constructor for class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InvalidClassException(clazz.getName(), "IllegalAccessException");
        }
        catch (InstantiationException instantiationException) {
            throw new InvalidClassException(clazz.getName(), "InstantiationException");
        }
        n3 = this.assignWireOffset(this.currentObject);
        n2 = this.spClass;
        objectStreamClass = this.currentClassDesc;
        while (objectStreamClass != null) {
            if (this.spClass >= this.classes.length) {
                this.growClassStacks();
            }
            this.classdesc[this.spClass] = objectStreamClass;
            this.classes[this.spClass] = this.currentClassDesc.ancestors[this.spClass - n2];
            ++this.spClass;
            objectStreamClass = objectStreamClass.superclass;
        }
        try {
            --this.spClass;
            while (this.spClass >= n2) {
                ObjectStreamField[] objectStreamFieldArray;
                this.currentClassDesc = this.classdesc[this.spClass];
                this.currentClass = this.classes[this.spClass];
                this.setBlockData(true);
                if (this.classes[this.spClass] != null) {
                    objectStreamFieldArray = this.currentClassDesc.localClassDescriptor();
                    if (!this.invokeObjectReader(this.currentObject)) {
                        this.defaultReadObject();
                    }
                } else {
                    objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
                    if (objectStreamFieldArray.length > 0) {
                        boolean bl3 = this.setBlockData(false);
                        this.inputClassFields(null, this.currentClass, objectStreamFieldArray);
                        this.setBlockData(bl3);
                    }
                }
                if (this.currentClassDesc.hasWriteObject()) {
                    this.skipToEndOfBlockData();
                }
                this.setBlockData(false);
                --this.spClass;
            }
            Object var11_24 = null;
            this.spClass = n2;
            return n3;
        }
        catch (Throwable throwable) {
            Object var11_25 = null;
            this.spClass = n2;
            throw throwable;
        }
    }

    private void growClassStacks() {
        int n = this.classes.length * 2;
        Class[] classArray = new Class[n];
        ObjectStreamClass[] objectStreamClassArray = new ObjectStreamClass[n];
        System.arraycopy(this.classes, 0, classArray, 0, this.classes.length);
        System.arraycopy(this.classdesc, 0, objectStreamClassArray, 0, this.classes.length);
        this.classes = classArray;
        this.classdesc = objectStreamClassArray;
    }

    /*
     * Unable to fully structure code
     */
    private void skipToEndOfBlockData() throws IOException, ClassNotFoundException {
        if (this.blockDataMode) ** GOTO lbl5
        return;
        {
            this.skip(this.count);
lbl5:
            // 2 sources

            block6: while (true) {
                if (this.count > 0) continue block5;
                switch (this.peekCode()) {
                    case -1: {
                        return;
                    }
                    case 119: 
                    case 122: {
                        this.refill();
                        continue block6;
                    }
                    case 120: {
                        this.readCode();
                        return;
                    }
                }
                this.readObject(false);
            }
        }
    }

    private void resetStream() throws IOException {
        int n;
        if (this.wireHandle2Object == null) {
            this.wireHandle2Object = new ArrayList();
        } else {
            this.wireHandle2Object.clear();
        }
        this.nextWireOffset = 0;
        if (this.classes == null) {
            this.classes = new Class[20];
        } else {
            n = 0;
            while (n < this.classes.length) {
                this.classes[n] = null;
                ++n;
            }
        }
        if (this.classdesc == null) {
            this.classdesc = new ObjectStreamClass[20];
        } else {
            n = 0;
            while (n < this.classdesc.length) {
                this.classdesc[n] = null;
                ++n;
            }
        }
        this.spClass = 0;
        this.setBlockData(true);
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
    }

    private int assignWireOffset(Object object) throws IOException {
        this.wireHandle2Object.add(object);
        if (++this.nextWireOffset != this.wireHandle2Object.size()) {
            throw new StreamCorruptedException("Elements not assigned in order");
        }
        return this.nextWireOffset - 1;
    }

    private byte peekCode() throws IOException, StreamCorruptedException {
        while (this.currCode == 0) {
            int n = this.in.read();
            if (n < 0) {
                throw new EOFException("Expecting code");
            }
            this.currCode = (byte)n;
            if (this.currCode < 112 || this.currCode > 125) {
                throw new StreamCorruptedException("Type code out of range, is " + this.currCode);
            }
            if (this.currCode != 121) continue;
            if (this.recursionDepth != 0 || this.currentObject != null || this.currentClassDesc != null) {
                throw new StreamCorruptedException("Illegal stream state for reset");
            }
            this.resetStream();
            this.currCode = 0;
        }
        return this.currCode;
    }

    private byte readCode() throws IOException, StreamCorruptedException {
        byte by = this.peekCode();
        this.currCode = 0;
        return by;
    }

    private void pushbackCode(byte by) {
        this.currCode = by;
    }

    private boolean setBlockData(boolean bl) throws IOException {
        if (this.blockDataMode == bl) {
            return bl;
        }
        if (this.blockDataMode && this.count > 0) {
            throw new StreamCorruptedException("Unread data");
        }
        this.count = bl ? 0 : -1;
        this.bufpos = 0;
        this.bufsize = 0;
        this.blockDataMode = bl;
        return !bl;
    }

    public int read() throws IOException {
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            try {
                int n = this.bufferData(1);
                return this.buf[n] & 0xFF;
            }
            catch (EOFException eOFException) {
                return -1;
            }
        }
        return this.in.read();
    }

    private void refill() throws IOException {
        byte by;
        this.count = -1;
        try {
            by = this.peekCode();
        }
        catch (EOFException eOFException) {
            return;
        }
        if (by == 119) {
            by = this.readCode();
            int n = this.in.read();
            if (n < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            this.count = n & 0xFF;
        } else if (by == 122) {
            int n;
            int n2;
            int n3;
            by = this.readCode();
            int n4 = this.in.read();
            if ((n4 | (n3 = this.in.read()) | (n2 = this.in.read()) | (n = this.in.read())) < 0) {
                throw new StreamCorruptedException("EOF expecting count");
            }
            int n5 = n4 << 24 | n3 << 16 | n2 << 8 | n;
            if (n5 < 0) {
                throw new StreamCorruptedException("Negative block data size");
            }
            this.count = n5;
        }
    }

    int bufferData(int n) throws IOException {
        this.ensureBufferCapacity(n);
        if (this.blockDataMode) {
            if (n > this.count) {
                throw new InternalError("attempt to read past block end");
            }
            int n2 = this.bufsize - this.bufpos;
            if (n > n2) {
                if (this.bufpos > 0) {
                    System.arraycopy(this.buf, this.bufpos, this.buf, 0, n2);
                    this.bufpos = 0;
                    this.bufsize = n2;
                }
                this.ensureBufferCapacity(this.count);
                this.readFullyInternal(this.buf, this.bufsize, this.count - this.bufsize);
                this.bufsize = this.count;
            }
            int n3 = this.bufpos;
            this.bufpos += n;
            this.count -= n;
            return n3;
        }
        this.readFullyInternal(this.buf, 0, n);
        return 0;
    }

    private void ensureBufferCapacity(int n) {
        if (this.buf.length < n) {
            byte[] byArray = new byte[n];
            if (this.bufsize > 0) {
                System.arraycopy(this.buf, 0, byArray, 0, this.bufsize);
            }
            this.buf = byArray;
        }
    }

    private void readFullyInternal(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = this.in.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.blockDataMode) {
            while (this.count == 0) {
                this.refill();
            }
            if (this.count < 0) {
                return -1;
            }
            n2 = Math.min(n2, this.count);
            int n3 = 0;
            int n4 = this.bufsize - this.bufpos;
            if (n4 > 0) {
                n3 = Math.min(n2, n4);
                System.arraycopy(this.buf, this.bufpos, byArray, n, n3);
                this.bufpos += n3;
            }
            if (n2 > n3) {
                n3 += this.in.read(byArray, n + n3, n2 - n3);
            }
            this.count -= n3;
            return n3;
        }
        return this.in.read(byArray, n, n2);
    }

    public int available() throws IOException {
        if (this.blockDataMode) {
            if (this.count == 0 && this.in.available() > 0) {
                this.refill();
            }
            if (this.count >= 0) {
                return this.count;
            }
            return 0;
        }
        return 0;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public byte readByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public short readShort() throws IOException {
        if (this.blockDataMode && this.count < 2) {
            return this.dis.readShort();
        }
        int n = this.bufferData(2);
        return (short)(((this.buf[n + 0] & 0xFF) << 8) + ((this.buf[n + 1] & 0xFF) << 0));
    }

    public int readUnsignedShort() throws IOException {
        if (this.blockDataMode && this.count < 2) {
            return this.dis.readUnsignedShort();
        }
        int n = this.bufferData(2);
        return ((this.buf[n + 0] & 0xFF) << 8) + ((this.buf[n + 1] & 0xFF) << 0);
    }

    public char readChar() throws IOException {
        if (this.blockDataMode && this.count < 2) {
            return this.dis.readChar();
        }
        int n = this.bufferData(2);
        return (char)(((this.buf[n + 0] & 0xFF) << 8) + ((this.buf[n + 1] & 0xFF) << 0));
    }

    public int readInt() throws IOException {
        if (this.blockDataMode && this.count < 4) {
            return this.dis.readInt();
        }
        int n = this.bufferData(4);
        return ((this.buf[n + 0] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + ((this.buf[n + 3] & 0xFF) << 0);
    }

    public long readLong() throws IOException {
        if (this.blockDataMode && this.count < 8) {
            return this.dis.readLong();
        }
        int n = this.bufferData(8);
        return (((long)this.buf[n + 0] & 0xFFL) << 56) + (((long)this.buf[n + 1] & 0xFFL) << 48) + (((long)this.buf[n + 2] & 0xFFL) << 40) + (((long)this.buf[n + 3] & 0xFFL) << 32) + (((long)this.buf[n + 4] & 0xFFL) << 24) + (((long)this.buf[n + 5] & 0xFFL) << 16) + (((long)this.buf[n + 6] & 0xFFL) << 8) + (((long)this.buf[n + 7] & 0xFFL) << 0);
    }

    public float readFloat() throws IOException {
        if (this.blockDataMode && this.count < 4) {
            return this.dis.readFloat();
        }
        int n = this.bufferData(4);
        return Float.intBitsToFloat(((this.buf[n + 0] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + ((this.buf[n + 3] & 0xFF) << 0));
    }

    public double readDouble() throws IOException {
        if (this.blockDataMode && this.count < 8) {
            return this.dis.readDouble();
        }
        int n = this.bufferData(8);
        return Double.longBitsToDouble((((long)this.buf[n + 0] & 0xFFL) << 56) + (((long)this.buf[n + 1] & 0xFFL) << 48) + (((long)this.buf[n + 2] & 0xFFL) << 40) + (((long)this.buf[n + 3] & 0xFFL) << 32) + (((long)this.buf[n + 4] & 0xFFL) << 24) + (((long)this.buf[n + 5] & 0xFFL) << 16) + (((long)this.buf[n + 6] & 0xFFL) << 8) + (((long)this.buf[n + 7] & 0xFFL) << 0));
    }

    public void readFully(byte[] byArray) throws IOException {
        this.dis.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.dis.readFully(byArray, n, n2);
    }

    public int skipBytes(int n) throws IOException {
        return this.dis.skipBytes(n);
    }

    public String readLine() throws IOException {
        return this.dis.readLine();
    }

    public String readUTF() throws IOException {
        return this.readUTFBody(this.readUnsignedShort());
    }

    private String readUTFBody(long l) throws IOException {
        long l2 = l;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.cdata.length;
        if (l > (long)n4 && n4 < 1000) {
            this.cdata = new char[(int)Math.min(l, 1000L)];
            n4 = this.cdata.length;
        }
        while (l2 > 0L) {
            int n5 = n2 - n;
            if (n5 > 0) {
                System.arraycopy(this.data, n, this.data, 0, n5);
            }
            int n6 = (int)Math.min(l2, (long)(this.data.length - n5));
            this.dis.readFully(this.data, n5, n6);
            n2 = n5 + n6;
            l2 -= (long)n6;
            n = 0;
            try {
                int n7 = l2 > 0L ? n2 - 2 : n2;
                while (n < n7) {
                    if (n3 >= n4) {
                        this.sbuf.append(this.cdata);
                        n3 = 0;
                    }
                    int n8 = this.data[n++] & 0xFF;
                    switch (n8 >> 4) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: {
                            this.cdata[n3++] = (char)n8;
                            break;
                        }
                        case 12: 
                        case 13: {
                            byte by = this.data[n++];
                            if ((by & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.cdata[n3++] = (char)((n8 & 0x1F) << 6 | by & 0x3F);
                            break;
                        }
                        case 14: {
                            byte by = this.data[n++];
                            byte by2 = this.data[n++];
                            if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                                throw new UTFDataFormatException();
                            }
                            this.cdata[n3++] = (char)((n8 & 0xF) << 12 | (by & 0x3F) << 6 | (by2 & 0x3F) << 0);
                            break;
                        }
                        default: {
                            throw new UTFDataFormatException();
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new UTFDataFormatException();
            }
        }
        if (n3 > 0) {
            this.sbuf.append(this.cdata, 0, n3);
        }
        String string = this.sbuf.toString();
        this.sbuf.setLength(0);
        return string;
    }

    private boolean invokeObjectReader(Object object) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (this.currentClassDesc.readObjectMethod == null) {
            return false;
        }
        try {
            this.currentClassDesc.readObjectMethod.invoke(object, this.readObjectArglist);
            return true;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("interal error");
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
    }

    private void inputClassFields(Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws InvalidClassException, StreamCorruptedException, ClassNotFoundException, IOException {
        if (this.currentClassDesc.numPrimBytes > 0) {
            if (this.data.length < this.currentClassDesc.numPrimBytes) {
                this.data = new byte[this.currentClassDesc.numPrimBytes];
            }
            this.readFully(this.data, 0, this.currentClassDesc.numPrimBytes);
            if (object != null) {
                ObjectInputStream.setPrimitiveFieldValues(object, this.currentClassDesc.primFieldIDs, this.currentClassDesc.primFieldTypecodes, this.data);
            }
        }
        int n = objectStreamFieldArray.length - this.currentClassDesc.numObjFields;
        int n2 = 0;
        while (n2 < this.currentClassDesc.numObjFields) {
            Field field = objectStreamFieldArray[n + n2].getField();
            boolean bl = field != null;
            Object object2 = this.readObject(bl);
            if (object != null && field != null) {
                try {
                    ObjectInputStream.setObjectFieldValue(object, this.currentClassDesc.objFieldIDs[n2], this.currentClassDesc.objFieldTypes[n2], object2);
                }
                catch (ClassCastException classCastException) {
                    throw new ClassCastException("Assigning instance of class " + object2.getClass().getName() + " to field " + clazz.getName() + '#' + field.getName());
                }
                catch (Exception exception) {
                    throw new InvalidClassException(clazz.getName(), "Invalid field " + field.getName());
                }
            }
            ++n2;
        }
    }

    private static native void setPrimitiveFieldValues(Object var0, long[] var1, char[] var2, byte[] var3);

    private static native void setObjectFieldValue(Object var0, long var1, Class var3, Object var4);

    private static native Object allocateNewObject(Class var0, Class var1) throws InstantiationException, IllegalAccessException;

    private static native Object allocateNewArray(Class var0, int var1);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static final class GetFieldImpl
    extends GetField {
        private byte[] data;
        private Object[] objects;
        private ObjectStreamClass desc;
        static /* synthetic */ Class class$java$lang$Object;

        public ObjectStreamClass getObjectStreamClass() {
            return this.desc;
        }

        public boolean defaulted(String string) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, null);
            return objectStreamField == null;
        }

        public boolean get(String string, boolean bl) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Boolean.TYPE);
            if (objectStreamField == null) {
                return bl;
            }
            return this.data[objectStreamField.getOffset()] != 0;
        }

        public char get(String string, char c) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Character.TYPE);
            if (objectStreamField == null) {
                return c;
            }
            int n = objectStreamField.getOffset();
            return (char)(((this.data[n] & 0xFF) << 8) + (this.data[n + 1] & 0xFF));
        }

        public byte get(String string, byte by) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Byte.TYPE);
            if (objectStreamField == null) {
                return by;
            }
            return this.data[objectStreamField.getOffset()];
        }

        public short get(String string, short s) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Short.TYPE);
            if (objectStreamField == null) {
                return s;
            }
            int n = objectStreamField.getOffset();
            return (short)(((this.data[n] & 0xFF) << 8) + (this.data[n + 1] & 0xFF));
        }

        public int get(String string, int n) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Integer.TYPE);
            if (objectStreamField == null) {
                return n;
            }
            int n2 = objectStreamField.getOffset();
            return ((this.data[n2] & 0xFF) << 24) + ((this.data[n2 + 1] & 0xFF) << 16) + ((this.data[n2 + 2] & 0xFF) << 8) + (this.data[n2 + 3] & 0xFF);
        }

        public long get(String string, long l) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Long.TYPE);
            if (objectStreamField == null) {
                return l;
            }
            int n = objectStreamField.getOffset();
            int n2 = ((this.data[n] & 0xFF) << 24) + ((this.data[n + 1] & 0xFF) << 16) + ((this.data[n + 2] & 0xFF) << 8) + (this.data[n + 3] & 0xFF);
            int n3 = ((this.data[n + 4] & 0xFF) << 24) + ((this.data[n + 5] & 0xFF) << 16) + ((this.data[n + 6] & 0xFF) << 8) + (this.data[n + 7] & 0xFF);
            long l2 = ((long)n2 << 32) + ((long)n3 & 0xFFFFFFFFL);
            return l2;
        }

        public float get(String string, float f) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Float.TYPE);
            if (objectStreamField == null) {
                return f;
            }
            int n = objectStreamField.getOffset();
            int n2 = ((this.data[n] & 0xFF) << 24) + ((this.data[n + 1] & 0xFF) << 16) + ((this.data[n + 2] & 0xFF) << 8) + (this.data[n + 3] & 0xFF);
            return Float.intBitsToFloat(n2);
        }

        public double get(String string, double d) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, Double.TYPE);
            if (objectStreamField == null) {
                return d;
            }
            int n = objectStreamField.getOffset();
            int n2 = ((this.data[n] & 0xFF) << 24) + ((this.data[n + 1] & 0xFF) << 16) + ((this.data[n + 2] & 0xFF) << 8) + (this.data[n + 3] & 0xFF);
            int n3 = ((this.data[n + 4] & 0xFF) << 24) + ((this.data[n + 5] & 0xFF) << 16) + ((this.data[n + 6] & 0xFF) << 8) + (this.data[n + 7] & 0xFF);
            long l = ((long)n2 << 32) + ((long)n3 & 0xFFFFFFFFL);
            return Double.longBitsToDouble(l);
        }

        public Object get(String string, Object object) throws IOException, IllegalArgumentException {
            ObjectStreamField objectStreamField = this.checkField(string, class$java$lang$Object == null ? (class$java$lang$Object = GetFieldImpl.class$("java.lang.Object")) : class$java$lang$Object);
            if (objectStreamField == null) {
                return object;
            }
            return this.objects[objectStreamField.getOffset()];
        }

        private ObjectStreamField checkField(String string, Class clazz) throws IllegalArgumentException {
            ObjectStreamField objectStreamField;
            ObjectStreamField objectStreamField2;
            ObjectStreamField objectStreamField3 = objectStreamField2 = clazz == null ? this.desc.getField(string) : this.desc.getField(string, clazz);
            if (objectStreamField2 != null) {
                if (clazz != null && clazz != objectStreamField2.getType()) {
                    throw new IllegalArgumentException("field type incorrect");
                }
                return objectStreamField2;
            }
            ObjectStreamClass objectStreamClass = this.desc.localClassDescriptor();
            if (objectStreamClass == null) {
                throw new IllegalArgumentException("No local class descriptor");
            }
            ObjectStreamField objectStreamField4 = objectStreamField = clazz == null ? objectStreamClass.getField(string) : objectStreamClass.getField(string, clazz);
            if (objectStreamField == null) {
                throw new IllegalArgumentException("no such field");
            }
            if (clazz != null && clazz != objectStreamField.getType() && (clazz.isPrimitive() || objectStreamField.getType().isPrimitive())) {
                throw new IllegalArgumentException("field type incorrect");
            }
            return null;
        }

        void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            if (this.data != null) {
                objectInputStream.readFully(this.data, 0, this.data.length);
            }
            if (this.objects != null) {
                int n = 0;
                while (n < this.objects.length) {
                    this.objects[n] = objectInputStream.readObject(false);
                    ++n;
                }
            }
        }

        GetFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            if (this.desc.numPrimBytes > 0) {
                this.data = new byte[this.desc.numPrimBytes];
            }
            if (this.desc.numObjFields > 0) {
                this.objects = new Object[this.desc.numObjFields];
            }
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;
    }
}

