/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverInfo;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class DriverManager {
    static final SQLPermission SET_LOG_PERMISSION = new SQLPermission("setLog");
    private static Vector drivers = new Vector();
    private static int loginTimeout = 0;
    private static PrintWriter logWriter = null;
    private static PrintStream logStream = null;
    private static boolean initialized = false;

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static synchronized void setLogWriter(PrintWriter printWriter) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = null;
        logWriter = printWriter;
    }

    public static synchronized Connection getConnection(String string, Properties properties) throws SQLException {
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(string, properties, classLoader);
    }

    public static synchronized Connection getConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        if (string2 != null) {
            properties.put("user", string2);
        }
        if (string3 != null) {
            properties.put("password", string3);
        }
        return DriverManager.getConnection(string, properties, classLoader);
    }

    public static synchronized Connection getConnection(String string) throws SQLException {
        Properties properties = new Properties();
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        return DriverManager.getConnection(string, properties, classLoader);
    }

    public static synchronized Driver getDriver(String string) throws SQLException {
        DriverManager.println("DriverManager.getDriver(\"" + string + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        int n = 0;
        while (n < drivers.size()) {
            DriverInfo driverInfo = (DriverInfo)drivers.elementAt(n);
            if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
                DriverManager.println("    skipping: " + driverInfo);
            } else {
                try {
                    DriverManager.println("    trying " + driverInfo);
                    if (driverInfo.driver.acceptsURL(string)) {
                        DriverManager.println("getDriver returning " + driverInfo);
                        return driverInfo.driver;
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            ++n;
        }
        DriverManager.println("getDriver: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    public static synchronized void registerDriver(Driver driver) throws SQLException {
        if (!initialized) {
            DriverManager.initialize();
        }
        DriverInfo driverInfo = new DriverInfo();
        driverInfo.driver = driver;
        driverInfo.driverClass = driver.getClass();
        driverInfo.driverClassName = driverInfo.driverClass.getName();
        drivers.addElement(driverInfo);
        DriverManager.println("registerDriver: " + driverInfo);
    }

    public static synchronized void deregisterDriver(Driver driver) throws SQLException {
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        DriverManager.println("DriverManager.deregisterDriver: " + driver);
        DriverInfo driverInfo = null;
        int n = 0;
        while (n < drivers.size()) {
            driverInfo = (DriverInfo)drivers.elementAt(n);
            if (driverInfo.driver == driver) break;
            ++n;
        }
        if (n >= drivers.size()) {
            DriverManager.println("    couldn't find driver to unload");
            return;
        }
        if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
            throw new SecurityException();
        }
        drivers.removeElementAt(n);
    }

    public static synchronized Enumeration getDrivers() {
        Vector vector = new Vector();
        if (!initialized) {
            DriverManager.initialize();
        }
        ClassLoader classLoader = DriverManager.getCallerClassLoader();
        int n = 0;
        while (n < drivers.size()) {
            DriverInfo driverInfo = (DriverInfo)drivers.elementAt(n);
            if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
                DriverManager.println("    skipping: " + driverInfo);
            } else {
                vector.addElement(driverInfo.driver);
            }
            ++n;
        }
        return vector.elements();
    }

    public static void setLoginTimeout(int n) {
        loginTimeout = n;
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static synchronized void setLogStream(PrintStream printStream) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SET_LOG_PERMISSION);
        }
        logStream = printStream;
        logWriter = printStream != null ? new PrintWriter(printStream) : null;
    }

    public static PrintStream getLogStream() {
        return logStream;
    }

    public static synchronized void println(String string) {
        if (logWriter != null) {
            logWriter.println(string);
            logWriter.flush();
        }
    }

    private static Class getCallerClass(ClassLoader classLoader, String string) {
        Class clazz = null;
        try {
            clazz = Class.forName(string, true, classLoader);
        }
        catch (Exception exception) {
            clazz = null;
        }
        return clazz;
    }

    /*
     * Unable to fully structure code
     */
    private static void loadInitialDrivers() {
        try {
            var0 = (String)AccessController.doPrivileged(new GetPropertyAction("jdbc.drivers"));
        }
        catch (Exception var1_1) {
            var0 = null;
        }
        DriverManager.println("DriverManager.initialize: jdbc.drivers = " + var0);
        if (var0 != null) ** GOTO lbl24
        return;
lbl-1000:
        // 1 sources

        {
            var1_2 = var0.indexOf(58);
            if (var1_2 < 0) {
                var2_3 = var0;
                var0 = "";
            } else {
                var2_3 = var0.substring(0, var1_2);
                var0 = var0.substring(var1_2 + 1);
            }
            if (var2_3.length() == 0) continue;
            try {
                DriverManager.println("DriverManager.Initialize: loading " + var2_3);
                Class.forName(var2_3, true, ClassLoader.getSystemClassLoader());
                continue;
            }
            catch (Exception var3_4) {
                DriverManager.println("DriverManager.Initialize: load failed: " + var3_4);
            }
lbl24:
            // 4 sources

            ** while (var0.length() != 0)
        }
lbl25:
        // 1 sources

    }

    private static synchronized Connection getConnection(String string, Properties properties, ClassLoader classLoader) throws SQLException {
        if (string == null) {
            throw new SQLException("The url cannot be null", "08001");
        }
        DriverManager.println("DriverManager.getConnection(\"" + string + "\")");
        if (!initialized) {
            DriverManager.initialize();
        }
        SQLException sQLException = null;
        int n = 0;
        while (n < drivers.size()) {
            block9: {
                DriverInfo driverInfo = (DriverInfo)drivers.elementAt(n);
                if (DriverManager.getCallerClass(classLoader, driverInfo.driverClassName) != driverInfo.driverClass) {
                    DriverManager.println("    skipping: " + driverInfo);
                } else {
                    try {
                        DriverManager.println("    trying " + driverInfo);
                        Connection connection = driverInfo.driver.connect(string, properties);
                        if (connection != null) {
                            DriverManager.println("getConnection returning " + driverInfo);
                            return connection;
                        }
                    }
                    catch (SQLException sQLException2) {
                        if (sQLException != null) break block9;
                        sQLException = sQLException2;
                    }
                }
            }
            ++n;
        }
        if (sQLException != null) {
            DriverManager.println("getConnection failed: " + sQLException);
            throw sQLException;
        }
        DriverManager.println("getConnection: no suitable driver");
        throw new SQLException("No suitable driver", "08001");
    }

    static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        DriverManager.loadInitialDrivers();
        DriverManager.println("JDBC DriverManager initialized");
    }

    private DriverManager() {
    }

    private static native ClassLoader getCallerClassLoader();
}

