/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableColumn
implements Serializable {
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    private int preferredWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport;

    public TableColumn() {
        this(0);
    }

    public TableColumn(int n) {
        this(n, 75, null, null);
    }

    public TableColumn(int n, int n2) {
        this(n, n2, null, null);
    }

    public TableColumn(int n, int n2, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        this.modelIndex = n;
        this.width = n2;
        this.preferredWidth = n2;
        this.cellRenderer = tableCellRenderer;
        this.cellEditor = tableCellEditor;
        this.minWidth = 15;
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.resizedPostingDisableCount = 0;
        this.headerValue = null;
    }

    private void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    private void firePropertyChange(String string, int n, int n2) {
        if (n != n2) {
            this.firePropertyChange(string, new Integer(n), new Integer(n2));
        }
    }

    private void firePropertyChange(String string, boolean bl, boolean bl2) {
        if (bl != bl2) {
            this.firePropertyChange(string, new Boolean(bl), new Boolean(bl2));
        }
    }

    public void setModelIndex(int n) {
        int n2 = this.modelIndex;
        this.modelIndex = n;
        this.firePropertyChange("modelIndex", n2, n);
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setIdentifier(Object object) {
        Object object2 = this.identifier;
        this.identifier = object;
        this.firePropertyChange("identifier", object2, object);
    }

    public Object getIdentifier() {
        return this.identifier != null ? this.identifier : this.getHeaderValue();
    }

    public void setHeaderValue(Object object) {
        Object object2 = this.headerValue;
        this.headerValue = object;
        this.firePropertyChange(HEADER_VALUE_PROPERTY, object2, object);
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.headerRenderer;
        this.headerRenderer = tableCellRenderer;
        this.firePropertyChange(HEADER_RENDERER_PROPERTY, tableCellRenderer2, tableCellRenderer);
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        TableCellRenderer tableCellRenderer2 = this.cellRenderer;
        this.cellRenderer = tableCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, tableCellRenderer2, tableCellRenderer);
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        TableCellEditor tableCellEditor2 = this.cellEditor;
        this.cellEditor = tableCellEditor;
        this.firePropertyChange("cellEditor", tableCellEditor2, tableCellEditor);
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setWidth(int n) {
        int n2 = this.width;
        this.width = Math.min(Math.max(n, this.minWidth), this.maxWidth);
        this.firePropertyChange("width", n2, this.width);
    }

    public int getWidth() {
        return this.width;
    }

    public void setPreferredWidth(int n) {
        int n2 = this.preferredWidth;
        this.preferredWidth = Math.min(Math.max(n, this.minWidth), this.maxWidth);
        this.firePropertyChange("preferredWidth", n2, this.preferredWidth);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setMinWidth(int n) {
        int n2 = this.minWidth;
        this.minWidth = Math.max(n, 0);
        if (this.width < n) {
            this.setWidth(n);
        }
        if (this.preferredWidth < n) {
            this.setPreferredWidth(n);
        }
        this.firePropertyChange("minWidth", n2, this.minWidth);
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMaxWidth(int n) {
        int n2 = this.maxWidth;
        this.maxWidth = Math.max(this.minWidth, n);
        if (this.width > n) {
            this.setWidth(n);
        }
        if (this.preferredWidth > n) {
            this.setPreferredWidth(n);
        }
        this.firePropertyChange("maxWidth", n2, this.maxWidth);
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setResizable(boolean bl) {
        boolean bl2 = this.isResizable;
        this.isResizable = bl;
        this.firePropertyChange("isResizable", bl2, this.isResizable);
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public void sizeWidthToFit() {
        if (this.headerRenderer == null) {
            return;
        }
        Component component = this.headerRenderer.getTableCellRendererComponent(null, this.getHeaderValue(), false, false, 0, 0);
        int n = component.getPreferredSize().width;
        this.setWidth(n);
    }

    public void disableResizedPosting() {
        ++this.resizedPostingDisableCount;
    }

    public void enableResizedPosting() {
        --this.resizedPostingDisableCount;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JTableHeader jTableHeader;
                if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                    this.setForeground(jTableHeader.getForeground());
                    this.setBackground(jTableHeader.getBackground());
                    this.setFont(jTableHeader.getFont());
                }
                this.setText(object == null ? "" : object.toString());
                this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
                return this;
            }
        };
        defaultTableCellRenderer.setHorizontalAlignment(0);
        return defaultTableCellRenderer;
    }
}

