/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class FillLayout
extends Layout {
    public int type = 256;

    public FillLayout() {
    }

    public FillLayout(int type) {
        this.type = type;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        Control[] children = composite.getChildren();
        int count = children.length;
        int maxWidth = 0;
        int maxHeight = 0;
        int i = 0;
        while (i < count) {
            Control child = children[i];
            Point pt = child.computeSize(-1, -1, flushCache);
            maxWidth = Math.max(maxWidth, pt.x);
            maxHeight = Math.max(maxHeight, pt.y);
            ++i;
        }
        if (this.type == 256) {
            return new Point(count * maxWidth, maxHeight);
        }
        return new Point(maxWidth, count * maxHeight);
    }

    protected void layout(Composite composite, boolean flushCache) {
        Rectangle rect = composite.getClientArea();
        Control[] children = composite.getChildren();
        int count = children.length;
        if (count == 0) {
            return;
        }
        if (this.type == 256) {
            int x = rect.x + rect.width % count / 2;
            int width = rect.width / count;
            int y = rect.y;
            int height = rect.height;
            int i = 0;
            while (i < count) {
                Control child = children[i];
                child.setBounds(x, y, width, height);
                x += width;
                ++i;
            }
            return;
        }
        int x = rect.x;
        int width = rect.width;
        int y = rect.y + rect.height % count / 2;
        int height = rect.height / count;
        int i = 0;
        while (i < count) {
            Control child = children[i];
            child.setBounds(x, y, width, height);
            y += height;
            ++i;
        }
    }
}

