/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class XPathMatcher {
    protected static final boolean DEBUG_ALL = false;
    protected static final boolean DEBUG_METHODS = false;
    protected static final boolean DEBUG_METHODS2 = false;
    protected static final boolean DEBUG_METHODS3 = false;
    protected static final boolean DEBUG_MATCH = false;
    protected static final boolean DEBUG_STACK = false;
    protected static final boolean DEBUG_ANY = false;
    private XPath.LocationPath[] fLocationPaths;
    private boolean fShouldBufferContent;
    private boolean fBufferContent;
    private StringBuffer fMatchedBuffer = new StringBuffer();
    private boolean[] fMatched;
    private String fMatchedString;
    private IntStack[] fStepIndexes;
    private int[] fCurrentStep;
    private int[] fNoMatchDepth;
    protected SymbolTable fSymbolTable;
    protected IdentityConstraint fIDConstraint;

    public XPathMatcher(XPath xPath) {
        this(xPath, false, null);
    }

    public XPathMatcher(XPath xPath, boolean bl, IdentityConstraint identityConstraint) {
        this.fLocationPaths = xPath.getLocationPaths();
        this.fShouldBufferContent = bl;
        this.fIDConstraint = identityConstraint;
        this.fStepIndexes = new IntStack[this.fLocationPaths.length];
        int n = 0;
        while (n < this.fStepIndexes.length) {
            this.fStepIndexes[n] = new IntStack();
            ++n;
        }
        this.fCurrentStep = new int[this.fLocationPaths.length];
        this.fNoMatchDepth = new int[this.fLocationPaths.length];
        this.fMatched = new boolean[this.fLocationPaths.length];
    }

    public boolean isMatched() {
        int n = 0;
        while (n < this.fLocationPaths.length) {
            if (this.fMatched[n]) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean getIsSelector() {
        return this.fIDConstraint == null;
    }

    public IdentityConstraint getIDConstraint() {
        return this.fIDConstraint;
    }

    public String getMatchedString() {
        return this.fMatchedString;
    }

    protected void matched(String string, XSSimpleType xSSimpleType, boolean bl) throws XNIException {
    }

    public void startDocumentFragment(SymbolTable symbolTable) throws XNIException {
        this.clear();
        int n = 0;
        while (n < this.fLocationPaths.length) {
            this.fStepIndexes[n].clear();
            this.fCurrentStep[n] = 0;
            this.fNoMatchDepth[n] = 0;
            this.fMatched[n] = false;
            ++n;
        }
        this.fSymbolTable = symbolTable;
    }

    /*
     * Unable to fully structure code
     */
    public void startElement(QName var1_1, XMLAttributes var2_2, XSElementDecl var3_3) throws XNIException {
        var4_4 = 0;
        while (var4_4 < this.fLocationPaths.length) {
            block24: {
                block26: {
                    block25: {
                        block23: {
                            var5_5 = this.fCurrentStep[var4_4];
                            this.fStepIndexes[var4_4].push(var5_5);
                            if (!this.fMatched[var4_4] && this.fNoMatchDepth[var4_4] <= 0) break block23;
                            v0 = var4_4;
                            this.fNoMatchDepth[v0] = this.fNoMatchDepth[v0] + 1;
                            break block24;
                        }
                        var6_6 = this.fLocationPaths[var4_4].steps;
                        while (this.fCurrentStep[var4_4] < var6_6.length && var6_6[this.fCurrentStep[var4_4]].axis.type == 3) {
                            v1 = var4_4;
                            this.fCurrentStep[v1] = this.fCurrentStep[v1] + 1;
                        }
                        if (this.fCurrentStep[var4_4] != var6_6.length) break block25;
                        this.fMatched[var4_4] = true;
                        var7_7 = 0;
                        while (var7_7 < var4_4 && !this.fMatched[var7_7]) {
                            ++var7_7;
                        }
                        if (var7_7 == var4_4) {
                            this.fBufferContent = this.fShouldBufferContent;
                        }
                        break block24;
                    }
                    var7_7 = this.fCurrentStep[var4_4];
                    while (this.fCurrentStep[var4_4] < var6_6.length && var6_6[this.fCurrentStep[var4_4]].axis.type == 4) {
                        v2 = var4_4;
                        this.fCurrentStep[v2] = this.fCurrentStep[v2] + 1;
                    }
                    if (this.fCurrentStep[var4_4] != var6_6.length) break block26;
                    v3 = var4_4;
                    this.fNoMatchDepth[v3] = this.fNoMatchDepth[v3] + 1;
                    break block24;
                }
                if (this.fCurrentStep[var4_4] != var5_5 && this.fCurrentStep[var4_4] <= var7_7 || var6_6[this.fCurrentStep[var4_4]].axis.type != 1) ** GOTO lbl47
                var8_8 = var6_6[this.fCurrentStep[var4_4]];
                var9_11 = var8_8.nodeTest;
                if (var9_11.type == 1 && !var9_11.name.equals(var1_1)) {
                    if (this.fCurrentStep[var4_4] > var7_7) {
                        this.fCurrentStep[var4_4] = var7_7;
                    } else {
                        v4 = var4_4;
                        this.fNoMatchDepth[v4] = this.fNoMatchDepth[v4] + 1;
                    }
                } else {
                    v5 = var4_4;
                    this.fCurrentStep[v5] = this.fCurrentStep[v5] + 1;
lbl47:
                    // 2 sources

                    if (this.fCurrentStep[var4_4] == var6_6.length) {
                        this.fMatched[var4_4] = true;
                        var8_9 = 0;
                        while (var8_9 < var4_4 && !this.fMatched[var8_9]) {
                            ++var8_9;
                        }
                        if (var8_9 == var4_4) {
                            this.fBufferContent = this.fShouldBufferContent;
                        }
                    } else if (this.fCurrentStep[var4_4] < var6_6.length && var6_6[this.fCurrentStep[var4_4]].axis.type == 2) {
                        var8_10 = var2_2.getLength();
                        if (var8_10 > 0) {
                            var9_11 = var6_6[this.fCurrentStep[var4_4]].nodeTest;
                            var10_12 = new QName();
                            var11_13 = null;
                            if (var3_3 != null && (var12_15 = var3_3.fType) != null && var12_15.getXSType() == 1) {
                                var13_16 = (XSComplexTypeDecl)var12_15;
                                var11_13 = var13_16.getAttrGrp();
                            }
                            var12_14 = 0;
                            while (var12_14 < var8_10) {
                                var2_2.getName(var12_14, var10_12);
                                if (var9_11.type != 1 || var9_11.name.equals(var10_12)) {
                                    v6 = var4_4;
                                    this.fCurrentStep[v6] = this.fCurrentStep[v6] + 1;
                                    if (this.fCurrentStep[var4_4] != var6_6.length) break;
                                    this.fMatched[var4_4] = true;
                                    var13_17 = 0;
                                    while (var13_17 < var4_4 && !this.fMatched[var13_17]) {
                                        ++var13_17;
                                    }
                                    if (var13_17 != var4_4) break;
                                    this.fMatchedString = var14_18 = var2_2.getValue(var12_14);
                                    var15_19 = null;
                                    if (var11_13 != null && (var16_20 = var11_13.getAttributeUse(var10_12.uri, var10_12.localpart)) != null) {
                                        var17_21 = var16_20.fAttrDecl;
                                        var15_19 = var17_21.fType;
                                    }
                                    this.matched(this.fMatchedString, var15_19, false);
                                    break;
                                }
                                ++var12_14;
                            }
                        }
                        if (!this.fMatched[var4_4]) {
                            if (this.fCurrentStep[var4_4] > var7_7) {
                                this.fCurrentStep[var4_4] = var7_7;
                            } else {
                                v7 = var4_4;
                                this.fNoMatchDepth[v7] = this.fNoMatchDepth[v7] + 1;
                            }
                        }
                    }
                }
            }
            ++var4_4;
        }
    }

    public void characters(XMLString xMLString) throws XNIException {
        int n = 0;
        while (n < this.fLocationPaths.length) {
            if (this.fBufferContent && this.fNoMatchDepth[n] == 0) {
                this.fMatchedBuffer.append(xMLString);
                break;
            }
            ++n;
        }
    }

    public void endElement(QName qName, XSElementDecl xSElementDecl) {
        int n = 0;
        while (n < this.fLocationPaths.length) {
            block13: {
                block12: {
                    block11: {
                        if (this.fNoMatchDepth[n] <= 0) break block11;
                        int n2 = n;
                        this.fNoMatchDepth[n2] = this.fNoMatchDepth[n2] - 1;
                        break block12;
                    }
                    int n3 = 0;
                    while (n3 < n && !this.fMatched[n3]) {
                        ++n3;
                    }
                    if (n3 < n) break block13;
                    if (this.fBufferContent) {
                        XSTypeDecl xSTypeDecl;
                        this.fBufferContent = false;
                        this.fMatchedString = this.fMatchedBuffer.toString();
                        XSSimpleType xSSimpleType = null;
                        if (xSElementDecl != null && (xSTypeDecl = xSElementDecl.fType) != null) {
                            if (xSTypeDecl.getXSType() == 1) {
                                XSComplexTypeDecl xSComplexTypeDecl = (XSComplexTypeDecl)xSTypeDecl;
                                xSSimpleType = xSComplexTypeDecl.getXSSimpleType();
                            } else {
                                xSSimpleType = (XSSimpleType)xSTypeDecl;
                            }
                        }
                        if (xSElementDecl != null) {
                            this.matched(this.fMatchedString, xSSimpleType, xSElementDecl.isNillable());
                        } else {
                            this.matched(this.fMatchedString, xSSimpleType, false);
                        }
                    }
                    this.clear();
                }
                this.fCurrentStep[n] = this.fStepIndexes[n].pop();
            }
            ++n;
        }
    }

    public void endDocumentFragment() throws XNIException {
        this.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = super.toString();
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        stringBuffer.append(string);
        int n2 = 0;
        while (n2 < this.fLocationPaths.length) {
            stringBuffer.append('[');
            XPath.Step[] stepArray = this.fLocationPaths[n2].steps;
            int n3 = 0;
            while (n3 < stepArray.length) {
                if (n3 == this.fCurrentStep[n2]) {
                    stringBuffer.append('^');
                }
                stringBuffer.append(stepArray[n2].toString());
                if (n3 < stepArray.length - 1) {
                    stringBuffer.append('/');
                }
                ++n3;
            }
            if (this.fCurrentStep[n2] == stepArray.length) {
                stringBuffer.append('^');
            }
            stringBuffer.append(']');
            stringBuffer.append(',');
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void clear() {
        this.fBufferContent = false;
        this.fMatchedBuffer.setLength(0);
        this.fMatchedString = null;
        int n = 0;
        while (n < this.fLocationPaths.length) {
            this.fMatched[n] = false;
            ++n;
        }
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

