/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class StackLayout
extends AbstractHintLayout {
    protected Dimension calculateMinimumSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getMinimumSize(wHint, hHint));
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    protected Dimension calculatePreferredSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            d.union(child.getPreferredSize(wHint, hHint));
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }

    public void layout(IFigure figure) {
        Rectangle r = figure.getClientArea();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            child.setBounds(r);
            ++i;
        }
    }
}

