/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.geometry;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public final class PrecisionRectangle
extends Rectangle {
    public double preciseHeight;
    public double preciseWidth;
    public double preciseX;
    public double preciseY;

    PrecisionRectangle() {
    }

    public PrecisionRectangle(Rectangle rect) {
        super(rect);
        this.preciseX = rect.x;
        this.preciseY = rect.y;
        this.preciseWidth = rect.width;
        this.preciseHeight = rect.height;
    }

    public Rectangle getCopy() {
        PrecisionRectangle result = new PrecisionRectangle();
        result.preciseX = this.preciseX;
        result.preciseY = this.preciseY;
        result.preciseWidth = this.preciseWidth;
        result.preciseHeight = this.preciseHeight;
        result.updateInts();
        return result;
    }

    public void performScale(double factor) {
        this.preciseX *= factor;
        this.preciseY *= factor;
        this.preciseWidth *= factor;
        this.preciseHeight *= factor;
        this.updateInts();
    }

    public void performTranslate(int dx, int dy) {
        this.preciseX += (double)dx;
        this.preciseY += (double)dy;
        this.x += dx;
        this.y += dy;
    }

    public Rectangle resize(Dimension sizeDelta) {
        this.preciseWidth += (double)sizeDelta.width;
        this.preciseHeight += (double)sizeDelta.height;
        this.updateInts();
        return this;
    }

    public void setHeight(double value) {
        this.preciseHeight = value;
        this.height = (int)Math.floor(this.preciseHeight + 1.0E-9);
    }

    public void setWidth(double value) {
        this.preciseWidth = value;
        this.width = (int)Math.floor(this.preciseWidth + 1.0E-9);
    }

    public void setX(double value) {
        this.preciseX = value;
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
    }

    public void setY(double value) {
        this.preciseY = value;
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
    }

    public Rectangle translate(Point p) {
        this.preciseX += (double)p.x;
        this.preciseY += (double)p.y;
        this.updateInts();
        return this;
    }

    private void updateInts() {
        this.x = (int)Math.floor(this.preciseX + 1.0E-9);
        this.y = (int)Math.floor(this.preciseY + 1.0E-9);
        this.width = (int)Math.floor(this.preciseWidth + this.preciseX + 1.0E-9) - this.x;
        this.height = (int)Math.floor(this.preciseHeight + this.preciseY + 1.0E-9) - this.y;
    }
}

