/*
 * Decompiled with CFR 0.152.
 */
package latte.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import latte.action.ActionCancelException;
import latte.action.AllAction;
import latte.model.LMAssociation;
import latte.model.LMAttribute;
import latte.model.LMClass;
import latte.model.LMClassDiag;
import latte.model.LMDefinition;
import latte.model.LMDiag;
import latte.model.LMElement;
import latte.model.LMFigure;
import latte.model.LMInterface;
import latte.model.LMMethod;
import latte.model.LMPackage;
import latte.model.LMRelation;
import latte.util.MsgUtil;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class LatteData
extends Observable {
    private LMPackage rootPackage_ = null;
    private ArrayList lmRelList_ = new ArrayList();
    private LMElement selectedElement_ = null;
    private boolean isNeedSaving_ = false;
    private File file_ = null;
    private static SAXParserFactory factory__ = null;
    private static SAXParser parser__ = null;

    static {
        try {
            factory__ = SAXParserFactory.newInstance();
            parser__ = factory__.newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LatteData() {
        this.rootPackage_ = new LMPackage();
        this.rootPackage_.setName("\u30eb\u30fc\u30c8\u30d1\u30c3\u30b1\u30fc\u30b8");
        this.setNeedRepaint();
        this.setSelectedElement(this.rootPackage_);
    }

    public void addRelation(LMRelation rel) {
        this.lmRelList_.add(rel);
    }

    public void removeRelation(LMRelation rel) {
        ((AbstractCollection)this.lmRelList_).remove(rel);
    }

    public void checkSaving(Shell s) throws ActionCancelException, IOException {
        if (!this.isNeedSaving_) {
            return;
        }
        int ret = MsgUtil.showYesNoCancelMsg(s, "\u30c7\u30fc\u30bf\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u4fdd\u5b58\u3057\u307e\u3059\u304b\uff1f");
        switch (ret) {
            case 64: {
                break;
            }
            case 128: {
                return;
            }
            case 256: {
                throw new ActionCancelException();
            }
        }
        AllAction.FILE_SAVE.execute(null);
    }

    public void clear() {
        this.getRootPackage().getDefinitions().clear();
        this.getLmRelList().clear();
        this.setSelectedElement(null);
        this.setFile(null);
        this.isNeedSaving_ = false;
        this.setNeedRepaint();
    }

    public void load() throws Exception {
        LMElement.setCurId(0);
        LatteDataHandler handler = new LatteDataHandler();
        parser__.parse(this.file_.getAbsolutePath(), (DefaultHandler)handler);
        this.setDefLinkObject(this.rootPackage_);
        this.setRelLinkObject();
        this.setNeedRepaint();
        this.isNeedSaving_ = false;
        this.setSelectedElement(this.rootPackage_);
    }

    public void setNeedSaving() {
        this.isNeedSaving_ = true;
        this.setNeedRepaint();
    }

    public void setNeedRepaint() {
        this.setChanged();
    }

    private void setDefLinkObject(LMPackage pkg) {
        Iterator ite = ((AbstractList)pkg.getDefinitions()).iterator();
        while (ite.hasNext()) {
            LMDefinition def = (LMDefinition)ite.next();
            if (def instanceof LMPackage) {
                this.setDefLinkObject((LMPackage)def);
            }
            if (!(def instanceof LMDiag)) continue;
            LMDiag diag = (LMDiag)def;
            Iterator figs = ((AbstractList)diag.getLmFiguresList()).iterator();
            while (figs.hasNext()) {
                LMFigure fig = (LMFigure)figs.next();
                fig.setLmDef(this.getLMDefById(this.rootPackage_, fig.getLmDefId()));
            }
        }
    }

    private void setRelLinkObject() {
        Iterator ite = ((AbstractList)this.getLmRelList()).iterator();
        while (ite.hasNext()) {
            LMRelation rel = (LMRelation)ite.next();
            rel.setFrom(this.getLMDefById(this.rootPackage_, rel.getFromId()));
            rel.setTo(this.getLMDefById(this.rootPackage_, rel.getToId()));
        }
    }

    private LMDefinition getLMDefById(LMPackage pkg, int id) {
        Iterator ite = ((AbstractList)pkg.getDefinitions()).iterator();
        while (ite.hasNext()) {
            LMDefinition def = (LMDefinition)ite.next();
            if (def.getId() == id) {
                return def;
            }
            if (def instanceof LMPackage) {
                LMDefinition d = this.getLMDefById((LMPackage)def, id);
                if (d == null) continue;
                return d;
            }
            if (!(def instanceof LMClassDiag)) continue;
            LMClassDiag diag = (LMClassDiag)def;
            Iterator ite2 = ((AbstractList)diag.getLmFiguresList()).iterator();
            while (ite2.hasNext()) {
                LMDefinition def2 = (LMDefinition)ite2.next();
                if (def2.getId() != id) continue;
                return def2;
            }
        }
        return null;
    }

    public void save() throws IllegalStateException, IOException {
        if (this.file_ == null) {
            throw new IllegalStateException("\u30d5\u30a1\u30a4\u30eb\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        PrintWriter writer = new PrintWriter(new FileOutputStream(this.file_));
        writer.println("<?xml version=\"1.0\" encoding=\"Shift_JIS\" ?>");
        this.writeLatteDataRecusivly(writer, this.getRootPackage(), 0);
        writer.flush();
        writer.close();
        this.isNeedSaving_ = false;
    }

    private void writeRelation(PrintWriter writer) {
        Iterator ite = ((AbstractList)this.lmRelList_).iterator();
        while (ite.hasNext()) {
            LMRelation lmRel = (LMRelation)ite.next();
            String qName = lmRel.getClass().getName().substring(12);
            writer.print("  <" + qName);
            writer.print(" name=\"" + lmRel.getName() + "\"");
            writer.print(" id=\"" + lmRel.getId() + "\"");
            writer.print(" from=\"" + lmRel.getFrom().getId() + "\"");
            writer.print(" to=\"" + lmRel.getTo().getId() + "\"");
            if (lmRel.getRoutingCons() != null) {
                writer.print(" rcons_x=\"" + lmRel.getRoutingCons().x + "\"");
                writer.print(" rcons_y=\"" + lmRel.getRoutingCons().y + "\"");
            }
            if (lmRel instanceof LMAssociation) {
                LMAssociation lmAss = (LMAssociation)lmRel;
                writer.print(" navi=\"" + lmAss.getNavigatable() + "\"");
                writer.print(" container=\"" + lmAss.getContainer() + "\"");
            }
            writer.print(">");
            writer.println("</" + qName + ">");
        }
    }

    private void writeLatteDataRecusivly(PrintWriter writer, LMDefinition def, int indent) throws IOException {
        int i = 0;
        while (i < indent) {
            writer.print("  ");
            ++i;
        }
        String qName = null;
        qName = def == this.getRootPackage() ? "LatteData" : def.getClass().getName().substring(12);
        String vId = Integer.toString(def.getId());
        String vName = def.getName();
        boolean isCR = false;
        if (def instanceof LMPackage || def instanceof LMClass || def instanceof LMInterface || def instanceof LMDiag) {
            isCR = true;
        }
        writer.print("<" + qName);
        writer.print(" name=\"" + vName + "\"");
        writer.print(" id=\"" + vId + "\"");
        if (def instanceof LMFigure) {
            LMFigure link = (LMFigure)def;
            int x = link.getX();
            int y = link.getY();
            int linkId = link.getLmDef().getId();
            writer.print(" x=\"" + x + "\"");
            writer.print(" y=\"" + y + "\"");
            writer.print(" lmDefId=\"" + linkId + "\"");
        }
        writer.print(">");
        if (isCR) {
            writer.println();
        }
        if (def instanceof LMPackage) {
            LMPackage pkg = (LMPackage)def;
            Iterator ite = ((AbstractList)pkg.getDefinitions()).iterator();
            while (ite.hasNext()) {
                this.writeLatteDataRecusivly(writer, (LMDefinition)ite.next(), indent + 1);
            }
        } else if (def instanceof LMClass) {
            LMClass cl = (LMClass)def;
            Iterator ite = ((AbstractList)cl.getAttributes()).iterator();
            while (ite.hasNext()) {
                this.writeLatteDataRecusivly(writer, (LMDefinition)ite.next(), indent + 1);
            }
            ite = ((AbstractList)cl.getMethodes()).iterator();
            while (ite.hasNext()) {
                this.writeLatteDataRecusivly(writer, (LMDefinition)ite.next(), indent + 1);
            }
        } else if (def instanceof LMInterface) {
            LMInterface itf = (LMInterface)def;
            Iterator ite = ((AbstractList)itf.getMethodes()).iterator();
            while (ite.hasNext()) {
                this.writeLatteDataRecusivly(writer, (LMDefinition)ite.next(), indent + 1);
            }
        } else if (def instanceof LMDiag) {
            LMDiag diag = (LMDiag)def;
            Iterator ite = ((AbstractList)diag.getLmFiguresList()).iterator();
            while (ite.hasNext()) {
                this.writeLatteDataRecusivly(writer, (LMDefinition)ite.next(), indent + 1);
            }
        }
        if (def == this.getRootPackage()) {
            this.writeRelation(writer);
        }
        if (isCR) {
            int i2 = 0;
            while (i2 < indent) {
                writer.print("  ");
                ++i2;
            }
        }
        writer.println("</" + qName + ">");
    }

    public LMPackage getRootPackage() {
        return this.rootPackage_;
    }

    public LMElement getSelectedElement() {
        return this.selectedElement_;
    }

    public void setSelectedElement(LMElement element) {
        this.selectedElement_ = element;
    }

    public File getFile() {
        return this.file_;
    }

    public void setFile(File file) {
        this.file_ = file;
        this.setNeedRepaint();
    }

    public void selectNone() {
        this.selectNone(this.getRootPackage());
        Iterator ite = ((AbstractList)this.getLmRelList()).iterator();
        while (ite.hasNext()) {
            LMRelation rel = (LMRelation)ite.next();
            rel.setSelected(false);
        }
    }

    private void selectNone(LMDefinition def) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        def.setSelected(false);
                        if (!(def instanceof LMPackage)) break block5;
                        LMPackage pkg = (LMPackage)def;
                        Iterator ite = ((AbstractList)pkg.getDefinitions()).iterator();
                        while (ite.hasNext()) {
                            this.selectNone((LMDefinition)ite.next());
                        }
                        break block6;
                    }
                    if (!(def instanceof LMClass)) break block7;
                    LMClass cl = (LMClass)def;
                    Iterator ite = ((AbstractList)cl.getAttributes()).iterator();
                    while (ite.hasNext()) {
                        this.selectNone((LMDefinition)ite.next());
                    }
                    ite = ((AbstractList)cl.getMethodes()).iterator();
                    while (ite.hasNext()) {
                        this.selectNone((LMDefinition)ite.next());
                    }
                    break block6;
                }
                if (!(def instanceof LMInterface)) break block8;
                LMInterface itf = (LMInterface)def;
                Iterator ite = ((AbstractList)itf.getMethodes()).iterator();
                while (ite.hasNext()) {
                    this.selectNone((LMDefinition)ite.next());
                }
                break block6;
            }
            if (!(def instanceof LMDiag)) break block6;
            LMDiag diag = (LMDiag)def;
            Iterator ite = ((AbstractList)diag.getLmFiguresList()).iterator();
            while (ite.hasNext()) {
                this.selectNone((LMDefinition)ite.next());
            }
        }
    }

    public ArrayList getLmRelList() {
        return this.lmRelList_;
    }

    class LatteDataHandler
    extends DefaultHandler {
        final int LOW_VALUE = -999;

        LatteDataHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            try {
                LMClass parentC;
                LMRelation rel;
                String defName = "";
                int defId = 0;
                int x = 0;
                int y = 0;
                int linkId = 0;
                int fromId = 0;
                int toId = 0;
                int rcons_x = -999;
                int rcons_y = -999;
                int navi = 3;
                int container = 1;
                int i = 0;
                while (i < atts.getLength()) {
                    if (atts.getQName(i).equals("name")) {
                        defName = atts.getValue(i);
                    }
                    if (atts.getQName(i).equals("id")) {
                        defId = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("x")) {
                        x = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("y")) {
                        y = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("lmDefId")) {
                        linkId = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("from")) {
                        fromId = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("to")) {
                        toId = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("rcons_x")) {
                        rcons_x = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("rcons_y")) {
                        rcons_y = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("navi")) {
                        navi = Integer.parseInt(atts.getValue(i));
                    }
                    if (atts.getQName(i).equals("container")) {
                        container = Integer.parseInt(atts.getValue(i));
                    }
                    ++i;
                }
                LMElement.setCurId(Math.max(defId, LMElement.getCurId()));
                if (qName.equals("LatteData")) {
                    LatteData.this.rootPackage_ = new LMPackage();
                    LatteData.this.rootPackage_.setName(defName);
                    LatteData.this.rootPackage_.setId(defId);
                    LatteData.this.setSelectedElement(LatteData.this.rootPackage_);
                    return;
                }
                String typeName = "latte.model." + qName;
                LMDefinition newDef = (LMDefinition)Class.forName(typeName).newInstance();
                LMDefinition parentDef = (LMDefinition)LatteData.this.getSelectedElement();
                newDef.setName(defName);
                newDef.setId(defId);
                newDef.setParent(parentDef);
                if (newDef instanceof LMFigure) {
                    LMFigure link = (LMFigure)newDef;
                    link.setX(x);
                    link.setY(y);
                    link.setLmDefId(linkId);
                } else if (newDef instanceof LMRelation) {
                    rel = (LMRelation)newDef;
                    if (rcons_x != -999 || rcons_y != -999) {
                        Point p = new Point(rcons_x, rcons_y);
                        rel.setRoutingCons(p);
                    }
                    if (rel instanceof LMAssociation) {
                        LMAssociation ass = (LMAssociation)rel;
                        ass.setNavigatable(navi);
                        ass.setContainer(container);
                    }
                }
                if (parentDef instanceof LMPackage && !(newDef instanceof LMRelation)) {
                    LMPackage parentPkg = (LMPackage)parentDef;
                    parentPkg.addDefinition(newDef);
                } else if (parentDef instanceof LMClass && newDef instanceof LMAttribute) {
                    parentC = (LMClass)parentDef;
                    parentC.addAttribute((LMAttribute)newDef);
                } else if (parentDef instanceof LMClass && newDef instanceof LMMethod) {
                    parentC = (LMClass)parentDef;
                    parentC.addMethod((LMMethod)newDef);
                } else if (parentDef instanceof LMInterface) {
                    LMInterface parentI = (LMInterface)parentDef;
                    parentI.addMethod((LMMethod)newDef);
                } else if (parentDef instanceof LMDiag) {
                    LMDiag diag = (LMDiag)parentDef;
                    diag.addLMFigureList((LMFigure)newDef);
                } else if (newDef instanceof LMRelation) {
                    rel = (LMRelation)newDef;
                    rel.setFromId(fromId);
                    rel.setToId(toId);
                    LatteData.this.addRelation(rel);
                }
                LatteData.this.setSelectedElement(newDef);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            LatteData.this.setSelectedElement(((LMDefinition)LatteData.this.getSelectedElement()).getParent());
        }
    }
}

