/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import latte.Latte;
import latte.action.AllAction;
import latte.model.LMAttribute;
import latte.model.LMChangedEvent;
import latte.model.LMClass;
import latte.model.LMClassDiag;
import latte.model.LMDefinition;
import latte.model.LMDiag;
import latte.model.LMInterface;
import latte.model.LMMethod;
import latte.model.LMPackage;
import latte.model.LMSequenceDiag;
import latte.model.LatteData;
import latte.view.DragSourceEnabler;
import latte.view.LVUtil;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class LVTree
extends Tree {
    private Latte latte_ = null;
    private TreeItem curItem_ = null;
    private TreeItem lastItem_ = null;
    private ItemEditor itemEditor_ = null;
    static final String LATTE_DATA = "LATTE_DATA";

    LVTree(Latte latte, Composite parent) {
        super(parent, 0);
        this.latte_ = latte;
        new DragSourceEnabler(this);
        this.createTreePopupMenu();
        this.addSelectionListener(new LVTreeSelectionListener());
        this.addTreeListener(new LVTreeTreeListener());
    }

    void createTreePopupMenu() {
        Menu menu = new Menu((Control)this);
        this.setMenu(menu);
        Menu addMenu = LVUtil.createMenu(menu, "\u8ffd\u52a0");
        LVUtil.createMenuItem(addMenu, AllAction.ADD_CLASS_DIAGRAM);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_SEQUENCE_DIAGRAM);
        new MenuItem(addMenu, 2);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_PACKAGE);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_CLASS);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_INTERFACE);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_ATTRIBUTE);
        LVUtil.createMenuItem(addMenu, AllAction.ADD_METHOD);
        new MenuItem(menu, 2);
        LVUtil.createMenuItem(menu, AllAction.EDIT_CUT);
        LVUtil.createMenuItem(menu, AllAction.EDIT_COPY);
        LVUtil.createMenuItem(menu, AllAction.EDIT_PASTE);
        LVUtil.createMenuItem(menu, AllAction.EDIT_DELETE);
    }

    void updateTree(LMChangedEvent ldce) {
        switch (ldce.getChangedType()) {
            case 0: {
                this.createNewTree();
                break;
            }
            case 1: {
                LMDefinition parentDef = ldce.getParent();
                LMDefinition newDef = (LMDefinition)ldce.getElement();
                TreeItem parentTreeItem = this.searchTreeItemByDef(this.getItems(), parentDef);
                TreeItem newTreeItem = this.addItem(parentTreeItem, newDef);
                this.showItem(newTreeItem);
                this.editItem(newTreeItem);
                break;
            }
            case 2: {
                LMDefinition renameDef = (LMDefinition)ldce.getElement();
                String newName = renameDef.getName();
                TreeItem treeItem = this.searchTreeItemByDef(this.getItems(), renameDef);
                treeItem.setText(newName);
                break;
            }
            case 3: {
                LMDefinition deleteDef = (LMDefinition)ldce.getElement();
                TreeItem deleteTreeItem = this.searchTreeItemByDef(this.getItems(), deleteDef);
                deleteTreeItem.dispose();
            }
        }
    }

    private TreeItem searchTreeItemByDef(TreeItem[] treeItems, LMDefinition def) {
        int i = 0;
        while (i < treeItems.length) {
            if (treeItems[i].getData(LATTE_DATA) == def) {
                return treeItems[i];
            }
            TreeItem treeItem = this.searchTreeItemByDef(treeItems[i].getItems(), def);
            if (treeItem != null) {
                return treeItem;
            }
            ++i;
        }
        return null;
    }

    private void createNewTree() {
        this.removeAll();
        LatteData ld = this.latte_.getLatteData();
        TreeItem root = new TreeItem((Tree)this, 0);
        root.setText(ld.getRootPackage().getName());
        root.setData(LATTE_DATA, (Object)ld.getRootPackage());
        root.setImage(AllAction.ADD_PACKAGE.getImage());
        LMPackage pkg = ld.getRootPackage();
        Iterator it = ((AbstractList)pkg.getDefinitions()).iterator();
        while (it.hasNext()) {
            LMDefinition childDef = (LMDefinition)it.next();
            this.createTreeRecursivly(root, childDef);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void createTreeRecursivly(TreeItem parent, LMDefinition newDef) {
        TreeItem newItem = this.addItem(parent, newDef);
        Iterator it = null;
        if (newDef instanceof LMPackage) {
            it = ((AbstractList)((LMPackage)newDef).getDefinitions()).iterator();
        } else if (newDef instanceof LMClass) {
            ArrayList methodes = ((LMClass)newDef).getMethodes();
            ArrayList attributes = ((LMClass)newDef).getAttributes();
            ArrayList fieldes = new ArrayList();
            fieldes.addAll(attributes);
            fieldes.addAll(methodes);
            it = ((AbstractList)fieldes).iterator();
        } else {
            if (!(newDef instanceof LMInterface)) {
                return;
            }
            it = ((AbstractList)((LMInterface)newDef).getMethodes()).iterator();
        }
        while (it.hasNext()) {
            LMDefinition childDef = (LMDefinition)it.next();
            this.createTreeRecursivly(newItem, childDef);
        }
    }

    public TreeItem addItem(TreeItem parentTreeItem, LMDefinition newDef) {
        TreeItem item = new TreeItem(parentTreeItem, 0);
        item.setText(newDef.getName());
        item.setData(LATTE_DATA, (Object)newDef);
        if (newDef instanceof LMMethod) {
            item.setImage(AllAction.ADD_METHOD.getImage());
        } else if (newDef instanceof LMAttribute) {
            item.setImage(AllAction.ADD_ATTRIBUTE.getImage());
        } else if (newDef instanceof LMClass) {
            item.setImage(AllAction.ADD_CLASS.getImage());
        } else if (newDef instanceof LMInterface) {
            item.setImage(AllAction.ADD_INTERFACE.getImage());
        } else if (newDef instanceof LMPackage) {
            item.setImage(AllAction.ADD_PACKAGE.getImage());
        } else if (newDef instanceof LMClassDiag) {
            item.setImage(AllAction.ADD_CLASS_DIAGRAM.getImage());
        } else if (newDef instanceof LMSequenceDiag) {
            item.setImage(AllAction.ADD_SEQUENCE_DIAGRAM.getImage());
        }
        return item;
    }

    public void deselectAll() {
        super.deselectAll();
        this.lastItem_ = null;
    }

    public ItemEditor getItemEditor() {
        return this.itemEditor_;
    }

    public TreeItem getCurItem() {
        return this.curItem_;
    }

    private void editItem(TreeItem item) {
        TreeEditor treeEditor = new TreeEditor((Tree)this);
        Control c = treeEditor.getEditor();
        if (c != null) {
            c.dispose();
        }
        treeEditor.horizontalAlignment = 16384;
        treeEditor.grabHorizontal = true;
        treeEditor.minimumWidth = 50;
        this.itemEditor_ = new ItemEditor(this, treeEditor, item);
        treeEditor.setEditor((Control)this.itemEditor_, item);
        this.itemEditor_.setFocus();
    }

    class ItemEditor
    extends Composite {
        LVTree latteTree_ = null;
        TreeEditor treeEditor_ = null;
        TreeItem treeItem_ = null;
        Text text_ = new Text((Composite)this, 0);

        ItemEditor(LVTree latteTree, TreeEditor treeEditor, TreeItem treeItem) {
            super((Composite)latteTree, 0);
            this.latteTree_ = latteTree;
            this.treeEditor_ = treeEditor;
            this.treeItem_ = treeItem;
            this.text_.setText(this.treeItem_.getText());
            this.text_.selectAll();
            this.text_.addFocusListener(new FocusListener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void focusLost(FocusEvent e) {
                    ItemEditor.access$0(this.this$1);
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.text_.addTraverseListener(new TraverseListener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void keyTraversed(TraverseEvent te) {
                    switch (te.detail) {
                        case 2: {
                            this.this$1.roolback();
                            te.doit = false;
                            break;
                        }
                        case 4: {
                            ItemEditor.access$0(this.this$1);
                            te.doit = true;
                        }
                    }
                }
            });
            this.addListener(11, new Listener(this){
                final /* synthetic */ ItemEditor this$1;
                {
                    this.this$1 = itemEditor;
                }

                public void handleEvent(Event e) {
                    Rectangle rect = this.this$1.getClientArea();
                    this.this$1.text_.setBounds(rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                }
            });
        }

        private void commit() {
            String newName = this.text_.getText();
            LMDefinition lmDef = (LMDefinition)this.treeItem_.getData(LVTree.LATTE_DATA);
            this.closeItemEditor();
            AllAction.EDIT_RENAME.execute(new Object[]{lmDef, newName});
        }

        public void roolback() {
            this.closeItemEditor();
        }

        private void closeItemEditor() {
            Composite c = this.text_.getParent();
            c.dispose();
            this.treeEditor_.dispose();
        }

        static /* synthetic */ void access$0(ItemEditor itemEditor) {
            itemEditor.commit();
        }
    }

    class LVTreeSelectionListener
    implements SelectionListener {
        LVTreeSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            LVTree.this.curItem_ = (TreeItem)e.item;
            LMDefinition curDef = (LMDefinition)LVTree.this.curItem_.getData(LVTree.LATTE_DATA);
            AllAction.SELECT_DEF.execute(curDef);
            if (LVTree.this.lastItem_ == LVTree.this.curItem_) {
                LVTree.this.editItem(LVTree.this.curItem_);
            }
            LVTree.this.lastItem_ = LVTree.this.curItem_;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            LVTree.this.curItem_ = (TreeItem)e.item;
            LMDefinition curDef = (LMDefinition)LVTree.this.curItem_.getData(LVTree.LATTE_DATA);
            AllAction.SELECT_DEF.execute(curDef);
            if (curDef instanceof LMDiag) {
                LVTree.this.latte_.getMainForm().getDiagFolder().showDiag((LMDiag)curDef);
            }
        }
    }

    class LVTreeTreeListener
    implements TreeListener {
        LVTreeTreeListener() {
        }

        public void treeCollapsed(TreeEvent e) {
        }

        public void treeExpanded(TreeEvent e) {
        }
    }
}

