/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <stdio.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! CWDコマンド
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	dirname	対象ディレクトリ名
 *@retval	int	エラーコード
 *@note
 */
int ftp_cd( LIBOFTP *ftp, const char *dirname )
{
    char str1[512];
    int res;

    if( ftp->socket < 0 ) return LIBOFTP_ERROR;

    /*
     * send CWD command
     */
    snprintf( str1, sizeof(str1)-1, "CWD %s\r\n", dirname );
    if( ftp_send_command( ftp, str1 ) < 0 ) {
	DEBUGPRINT1( "command sending error. %s\n", str1 );
	return LIBOFTP_ERROR_OS;
    }

    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message)-1 );
    if( res != 250 ) {						/* 250: Requested file action okay, completed. */
	DEBUGPRINT1( "command response error. %d\n", res );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    return LIBOFTP_NOERROR;
}
