/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
#define	TRANSFER_SEGMENT_SIZE	1024		/* 一度のrecv()で転送するバイト数 */


/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! ファイル取得してローカルファイルへ
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	fname	サーバ上のファイル名
 *@param	local_fname	ローカルファイル名
 *@retval	int	エラーコード
 *@note
 */
int ftp_get_file( LIBOFTP *ftp, const char *fname, const char *local_fname )
{
    int data_socket;
    int n, res;
    int fd;
    char buf[TRANSFER_SEGMENT_SIZE];

    if( ftp->socket < 0 ) return LIBOFTP_ERROR;

    /*
     * ローカルファイルオープン
     */
    fd = open( local_fname, O_WRONLY|O_CREAT, 0644 );
    if( fd < 0 ) {
	DEBUGPRINT1( "local file open error. %s\n", strerror(errno) );
	copy_strerror();
	return LIBOFTP_ERROR_OS;
    }
	
    /*
     * 受信準備
     */
    if( ftp->flag_passive ) {
	data_socket = ftp_getready_pasv( ftp, "RETR", fname );
    } else {
	data_socket = ftp_getready_active( ftp, "RETR", fname );
    }
    if( data_socket < 0 ) {
	close( fd );
	return data_socket;
    }
    /*
     * タイムアウトが意図通りに働くように、分割してrecvする。
     */
    while( 1 ) {
	n = recv( data_socket, buf, TRANSFER_SEGMENT_SIZE, 0 );
	DEBUGPRINT1( "RECV: n=%d\n", n );
	if( n < 0 ) {
	    int ret;
	    DEBUGPRINT1( "recv error. %s\n", strerror(errno) );
	    if( errno == EAGAIN ) {
		ret = LIBOFTP_ERROR_TIMEOUT;
	    } else {
		ret = LIBOFTP_ERROR_OS;
		copy_strerror();
	    }
	    close( fd );
	    close( data_socket );
	    return ret;
	}
	if( n == 0 ) {
	    break;
	}

	if( write( fd, buf, n ) != n ) {
	    DEBUGPRINT1( "write error. %s\n", strerror(errno) );
	    copy_strerror();
	    close( fd );
	    close( data_socket );
	    return LIBOFTP_ERROR_OS;
	}
    }
    close( fd );
    close( data_socket );

    /*
     * receive response.
     */
    res = ftp_receive_response( ftp, ftp->error_message, sizeof(ftp->error_message)-1 );
    if( res != 226 ) {						/* 226: Closing data connection. */
	DEBUGPRINT1( "got illegal response %d\n", res );
	return res < 0? res: LIBOFTP_ERROR_PROTOCOL;
    }

    return LIBOFTP_NOERROR;
}
