/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


/***** Feature test switches ************************************************/
/***** System headers *******************************************************/
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>


/***** Local headers ********************************************************/
#include "liboftp.h"
#include "sub.h"


/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
/***** Function prototypes **************************************************/
/***** Local variables ******************************************************/
/***** Global variables *****************************************************/
/***** Signal catching functions ********************************************/
/***** Local functions ******************************************************/
/***** Global functions *****************************************************/

/****************************************************************************/
/*! タイムアウト時間設定
 *
 *@param	ftp	LIBOFTPへのポインタ。
 *@param	sec	タイムアウト時間（秒）
 *@retval	int	エラーコード
 *@note
 */
int ftp_timeout( LIBOFTP *ftp, int sec )
{
    struct timeval tval;

    ftp->timeout_sec = sec;
    if( ftp->socket < 0 ) {
	return LIBOFTP_NOERROR;
    }
    
    tval.tv_sec = ftp->timeout_sec;
    tval.tv_usec = 0;
    if( setsockopt( ftp->socket, SOL_SOCKET, SO_SNDTIMEO, &tval, sizeof(struct timeval) ) < 0 ) {
	DEBUGPRINT1( "setsockopt(SO_SNDTIMEO) failed. %s\n", strerror(errno) );
	copy_strerror();
	return LIBOFTP_ERROR_OS;
    }
    if( setsockopt( ftp->socket, SOL_SOCKET, SO_RCVTIMEO, &tval, sizeof(struct timeval) ) < 0 ) {
	DEBUGPRINT1( "setsockopt(SO_RCVTIMEO) failed. %s\n", strerror(errno) );
	copy_strerror();
	return LIBOFTP_ERROR_OS;
    }

    return LIBOFTP_NOERROR;
}
