/*
  liboftp: this is an FTP library to simplify the work to a Developer
  who want to work with FTP servers (RFC 959).

  Copyright (c) 2009 hirohito higashi. All rights reserved.
  This file is distributed under BSD license.
*/


#ifndef	__libOftp_Sub_H_proto_
#define	__libOftp_Sub_H_proto_

/***** Feature test switches ************************************************/
#if 0
#define FTP_DEBUG
#endif


/***** System headers *******************************************************/
#include <string.h>
#include <errno.h>
#ifdef FTP_DEBUG
#include <stdio.h>
#endif


/***** Local headers ********************************************************/
/***** Constat values *******************************************************/
/***** Macros ***************************************************************/
/***** Typedefs *************************************************************/
#ifdef FTP_DEBUG
#define DEBUGPRINT1(f,a1) printf( "(" __FILE__ ") " f,(a1))
#else
#define DEBUGPRINT1(f,a1)
#endif

#define copy_strerror() \
    strncpy( ftp->error_message, strerror(errno), sizeof(ftp->error_message)-1 );



/***** Global variables *****************************************************/
/***** Function prototypes **************************************************/
#ifdef __cplusplus
extern "C" {
#endif
int sendn( int sd, const char *buf, int len, int flags );
int ftp_send_command( LIBOFTP *ftp, const char *cmd );
int ftp_receive_response( LIBOFTP *ftp, char *res_buf, int bufsiz );
int ftp_getready_active( LIBOFTP *ftp, const char *cmd, const char *fname );
int ftp_getready_pasv( LIBOFTP *ftp, const char *cmd, const char *fname );


#if defined( __QNX__ ) && !defined( __QNXNTO__ )
int snprintf( char *, int, char *, ... );
#endif


/***** Inline functions *****************************************************/

#ifdef __cplusplus
}
#endif

#endif
