#include "stdafx.h"
//#include "DialogUtilityImpl.h"
#include "HighlightWindow.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace DialogUtility {

CHighlightWindow::CHighlightWindow(COLORREF color, int width) : m_Brush(color), m_Width(width)
{
}

CHighlightWindow::~CHighlightWindow()
{
	for (int i = 0; i < 4; ++i) {
		m_HighlightWindow[i].DestroyWindow();
	}
}

void CHighlightWindow::Initialize(void)
{
	// window highlight ̂߂̎lp`̎l
	CString strWndClass = AfxRegisterWndClass(0, 0, m_Brush);
	for (int i = 0; i < 4; ++i) {
		m_HighlightWindow[i].Create(strWndClass, _T(""), 0, CRect(0, 0, 0, 0), CWnd::FromHandle(GetDesktopWindow()), 0);
		m_HighlightWindow[i].ModifyStyleEx(WS_EX_APPWINDOW, WS_EX_TOOLWINDOW);
	}
}

void CHighlightWindow::HighlightWindow(CWnd* pWnd)
{
	// highlight
	if (pWnd) {
		CRect rect;
		pWnd->GetWindowRect(rect);

		// window highlight ̂߂̎lp`̎lӂ WIDTH ̕ŕ`
		m_HighlightWindow[0].SetWindowPos(&CWnd::wndTopMost, rect.left, rect.top, rect.Width(), m_Width, 0);
		m_HighlightWindow[1].SetWindowPos(&CWnd::wndTopMost, rect.left, rect.top, m_Width, rect.Height(), 0);
		m_HighlightWindow[2].SetWindowPos(&CWnd::wndTopMost, rect.left, rect.bottom - m_Width, rect.Width(), m_Width, 0);
		m_HighlightWindow[3].SetWindowPos(&CWnd::wndTopMost, rect.right - m_Width, rect.top, m_Width, rect.Height(), 0);

		for (int i = 0; i < 4; ++i) {
			m_HighlightWindow[i].ShowWindow(SW_SHOWNA);
			m_HighlightWindow[i].Invalidate();
		}
	}
	// unhighlight
	else {
		for (int i = 0; i < 4; ++i) {
			m_HighlightWindow[i].ShowWindow(SW_HIDE);
		}
	}
}

}	// namespace DialogUtility
