#include "StdAfx.h"
#include "MiscUtil.h"

namespace GenericUtility {

	std::wstring GetModuleDir()
	{
		WCHAR lpFilename[MAX_PATH];
		// W[t@CpX
		if (!::GetModuleFileNameW(NULL, lpFilename, MAX_PATH)) {
			return L"";
		}

		// W[fBNg
		if (!::PathRemoveFileSpecW(lpFilename)) {
			return L"";
		}

		return lpFilename;
	}

	std::wstring GetStorageFilename(const std::wstring& strFilename)
	{
		WCHAR lpFilename[MAX_PATH];
		// W[fBNg
		::StrCpyNW(lpFilename, GetModuleDir().c_str(), MAX_PATH);

		// wt@Cǉ.
		if (!::PathAppendW(lpFilename, strFilename.c_str())) {
			return strFilename;
		}

		return lpFilename;
	}

	////////////////////////////////////////////////////////////////////////////////

	CString LoadStringRes(UINT uID)
	{
		CString str;
		VERIFY(str.LoadString(uID));
		return str;
	}

	CString ConcatenateStrings(const std::vector<CString>& strings, const CString& sep)
	{
#if 0
		CString ret;

		for (std::vector<CString>::const_iterator it = strings.begin(); it != strings.end(); ++it) {
			if (it != strings.begin()) {
				ret += sep;
			}
			ret += *it;
		}

		return ret;
#else
		// HACK: CString::Append() ͒x̂ŁAx vector ɓĂŌ CString ɕϊ

		std::vector<TCHAR> texts;

		for (std::vector<CString>::const_iterator it = strings.begin(); it != strings.end(); ++it) {
			if (it != strings.begin()) {
				LPCTSTR t = sep.GetString();
				texts.insert(texts.end(), t, t + sep.GetLength());
			}
			LPCTSTR t = it->GetString();
			texts.insert(texts.end(), t, t + it->GetLength());
		}

		// CString ɕϊ
		return CString(&texts[0], static_cast<int>(texts.size()));
#endif
	}

	bool IsValidFilePath(LPCTSTR lpszFilePath)
	{
		// HACK: ΃pXŁAt@C݂邩ǂ
		return !::PathIsRelative(lpszFilePath) && ::PathFileExists(lpszFilePath);
	}

	bool AreValidFilePaths(const std::vector<CString>& filePaths)
	{
		for (std::vector<CString>::const_iterator it = filePaths.begin(); it != filePaths.end(); ++it) {
			// Lȃt@CpXł͂Ȃ
			if (!IsValidFilePath(*it)) {
				// łLłȂ̂
				return false;
			}
		}
		// ׂėLȂ̂
		return true;
	}

	bool IsKeyPressed(int nVertKey)
	{
		// HACK: ŏʃrbg 1 Ȃ̂ŁASHORT Ȃ畉ɂȂ
		return ::GetKeyState(nVertKey) < 0;
	}

	////////////////////////////////////////////////////////////////////////////////

	void ListCtrl_SelectAllItems(CListCtrl& list)
	{
		CSuspendRedraw sr(&list);

		int size = list.GetItemCount();
		for (int i = 0; i < size; ++i) {
			list.SetItemState(i, LVIS_SELECTED, LVIS_SELECTED);
		}
	}

	void ListCtrl_UnselectAllItems(CListCtrl& list)
	{
		CSuspendRedraw sr(&list);

		POSITION pos = list.GetFirstSelectedItemPosition();
		while (pos) {
			list.SetItemState(list.GetNextSelectedItem(pos), 0, LVIS_SELECTED);
		}
	}

	int ListCtrl_GetSelectedItem(const CListCtrl& list)
	{
		POSITION pos = list.GetFirstSelectedItemPosition();
		if (!pos) {
			return -1;
		}

		// IĂŏ̍
		return list.GetNextSelectedItem(pos);
	}

	std::vector<int> ListCtrl_GetAllSelectedItems(const CListCtrl& list)
	{
		std::vector<int> items;

		POSITION pos = list.GetFirstSelectedItemPosition();
		while (pos) {
			items.push_back(list.GetNextSelectedItem(pos));
		}

		return items;
	}

	void ListCtrl_EditSelectedLabel(CListCtrl& list)
	{
		// IĂACe
		int item = ListCtrl_GetSelectedItem(list);
		// IĂAҏW
		if (item >= 0) {
			VERIFY(list.EditLabel(item));
		}
	}

	////////////////////////////////////////////////////////////////////////////////

	namespace {

		/**
		 * Suspend Redraw }l[W.
		 */
		class CSuspendRedrawManager
		{
		public:
			CSuspendRedrawManager()
			{
			}
			~CSuspendRedrawManager()
			{
				ASSERT(m_map.empty());
			}

			/**
			 * VOgCX^X擾.
			 */
			static CSuspendRedrawManager& Instance()
			{
				// HACK: }`XbhΉ
				static CSuspendRedrawManager instance;
				return instance;
			}

			/**
			 * Suspend Redraw EBhEo^.
			 */
			void Register(CWnd* pWnd, bool bRedrawOnEnd)
			{
				if (!pWnd) {
					return;
				}

				// EBhEnh
				HWND hWnd = pWnd->GetSafeHwnd();

				// ł suspend ǂ𒲂ׂ
				RedrawMap::iterator it = m_map.lower_bound(hWnd);
				// suspend ł͂Ȃ
				if (it == m_map.end() || m_map.comp(hWnd, it->first)) {
					RedrawInfo ri(1, bRedrawOnEnd);
					m_map.insert(it, RedrawMap::value_type(hWnd, ri));

					// `~߂
					pWnd->SetRedraw(FALSE);
				}
				// suspend 
				else {
					RedrawInfo& ri = it->second;

					// QƃJE^𑝂₷
					++(ri.first);
					// HACK: ł Redraw on End w肳ĂLɂ
					if (bRedrawOnEnd) {
						ri.second = bRedrawOnEnd;
					}
				}
			}

			/**
			 * Suspend Redraw EBhEo^.
			 */
			void Unregister(CWnd* pWnd)
			{
				if (!pWnd) {
					return;
				}

				// Redraw T
				RedrawMap::iterator it = m_map.find(pWnd->GetSafeHwnd());
				ASSERT(it != m_map.end());
				if (it == m_map.end()) {
					return;
				}

				RedrawInfo& ri = it->second;
				// QƃJE^炷
				if (--(ri.first) <= 0) {
					// QƃJE^ 0 ɂȂ

					// 폜
					m_map.erase(it);

					// `ĊJ
					pWnd->SetRedraw(TRUE);

					// RedrawWindow() s
					if (ri.second) {
						pWnd->RedrawWindow(NULL, NULL, RDW_INVALIDATE | RDW_UPDATENOW);
					}
				}
			}

		private:
			typedef std::pair<UINT_PTR /* QƃJE^ */, bool /* I RedrawWindow()  */> RedrawInfo;
			typedef std::map<HWND, RedrawInfo> RedrawMap;
			RedrawMap m_map;
		};

	}	// anonymous namespace

	CSuspendRedraw::CSuspendRedraw(CWnd* pWnd, bool bRedrawOnEnd)
		: m_pWnd(pWnd)
	{
		if (::IsWindow(m_pWnd->GetSafeHwnd())) {
			CSuspendRedrawManager::Instance().Register(m_pWnd, bRedrawOnEnd);
		}
		else {
			m_pWnd = NULL;
		}
	}

	CSuspendRedraw::~CSuspendRedraw()
	{
		if (m_pWnd) {
			CSuspendRedrawManager::Instance().Unregister(m_pWnd);
		}
	}

	////////////////////////////////////////////////////////////////////////////////

	// HACK: }`XbhΉ

	int CWaitCursorEx::s_refCount = 0;

	CWaitCursorEx::CWaitCursorEx()
	{
		Begin();
	}

	CWaitCursorEx::~CWaitCursorEx()
	{
		End();
	}

	void CWaitCursorEx::Begin()
	{
		ASSERT(s_refCount >= 0);

		// ŏɌĂ΂ꂽ
		if (++s_refCount == 1) {
			// ݒ肷
			AfxGetApp()->DoWaitCursor(1);
		}
		else {
			// HACK: 
			Restore();
		}
	}

	void CWaitCursorEx::Restore()
	{
		AfxGetApp()->DoWaitCursor(0);
	}

	void CWaitCursorEx::End()
	{
		ASSERT(s_refCount > 0);

		// ŌɌĂ΂ꂽ
		if (--s_refCount == 0) {
			// 
			AfxGetApp()->DoWaitCursor(-1);
		}
		else {
			// HACK: 
			Restore();
		}
	}

	bool CWaitCursorEx::IsWaiting()
	{
		return s_refCount > 0;
	}

	////////////////////////////////////////////////////////////////////////////////

	const COSVersion& COSVersion::Instance()
	{
		static const COSVersion instance;
		return instance;
	}

	COSVersion::COSVersion()
	{
		// OS o[W擾
		::ZeroMemory(&m_vi, sizeof(m_vi));
		m_vi.dwOSVersionInfoSize = sizeof(m_vi);
		VERIFY(::GetVersionEx(&m_vi));
	}

	COSVersion::OSType COSVersion::GetOSType() const
	{
		// NT t@~[
		if (IsNTFamily()) {
			if (CheckVersion(6, 1)) {
				return OST_7;
			}
			else if (CheckVersion(6, 0)) {
				return OST_Vista;
			}
			else if (CheckVersion(5, 2)) {
				return OST_2003;
			}
			else if (CheckVersion(5, 1)) {
				return OST_XP;
			}
			else if (CheckVersion(5, 0)) {
				return OST_2k;
			}
			else if (CheckVersion(4, 0)) {
				return OST_NT;
			}
			else {
				return OST_Unknown;
			}
		}
		// 95 t@~[
		else {
			if (CheckVersion(4, 90)) {
				return OST_Me;
			}
			else if (CheckVersion(4, 10)) {
				return OST_98;
			}
			else if (CheckVersion(4, 0)) {
				return OST_95;
			}
			else {
				return OST_Unknown;
			}
		}
	}

	bool COSVersion::IsNTFamily() const
	{
		return m_vi.dwPlatformId == VER_PLATFORM_WIN32_NT;
	}

	bool COSVersion::CheckVersion(DWORD nMajor, DWORD nMinor) const
	{
		return
			// W[o[W傫
			(m_vi.dwMajorVersion > nMajor) ||
			// W[o[WA}Ci[o[W傫
			(m_vi.dwMajorVersion == nMajor && m_vi.dwMinorVersion >= nMinor);
	}

}	// namespace GenericUtility
