// DataGroupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ListPaste.h"
#include "DataGroupDlg.h"

#include "../GenericLib/MiscUtil.h"

/// JgO[v̕\ύX
#define MODIFY_CURRENT_GROUP_NAME

// CDataGroupDlg dialog

CDataGroupDlg::CDataGroupDlg(CListPasteDoc* pDoc, CWnd* pParent /*=NULL*/)
	: CDataGroupDlgBase(CDataGroupDlg::IDD, pParent)
	, m_pDoc(pDoc)
{
	ASSERT(m_pDoc);
}

CDataGroupDlg::~CDataGroupDlg()
{
}

void CDataGroupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDataGroupDlgBase::DoDataExchange(pDX);
	DDX_Control	(pDX, IDC_LIST_DATA_GROUP,		m_listGroups);
}

BEGIN_MESSAGE_MAP(CDataGroupDlg, CDataGroupDlgBase)
	ON_WM_SIZE()
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_DATA_GROUP,			&CDataGroupDlg::OnNMDblclkListGroup)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_DATA_GROUP,			&CDataGroupDlg::OnNMRclickListGroup)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LIST_DATA_GROUP,			&CDataGroupDlg::OnLvnKeyDownListGroup)
#ifdef MODIFY_CURRENT_GROUP_NAME
	ON_NOTIFY(LVN_BEGINLABELEDIT, IDC_LIST_DATA_GROUP,	&CDataGroupDlg::OnLvnBeginLabelEditListGroup)
#endif	// #ifdef MODIFY_CURRENT_GROUP_NAME
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST_DATA_GROUP,	&CDataGroupDlg::OnLvnEndLabelEditListGroup)
END_MESSAGE_MAP()


// CDataGroupDlg message handlers

namespace {

	/////////////////////////////////////////////////////////////////////////////

	/**
	 * O[vXg̃J ID.
	 */
	enum EColumnID {
		CI_Name,        //< O[v.
		CI_Count,       //< O[vɊ܂܂ACe.

		CI_Total,       //< J.
	};

	/**
	 * O[vXg̃Jݒ肷.
	 * ACeŒ蕝ɂ܂܁AtɍL.
	 */
	void ModifyListColumnWidth(CListCtrl& list)
	{
		CRect rect;
		list.GetClientRect(rect);

		// Xg̕
		int nWidth = rect.Width();

		// ACe̍̕ŏl
		static const int COUNT_WIDTH_MIN = 60;

		GenericUtility::CSuspendRedraw sr(&list);
		// HACK: ACe̕߂ (ۂ̍ő啝ƁAŒ`ŏ̑傫)
		list.SetColumnWidth(CI_Count, LVSCW_AUTOSIZE);
		int nCountWidth = max(list.GetColumnWidth(CI_Count), COUNT_WIDTH_MIN);
		// HACK: ߂ACe̕ɊÂāAۂ̕ݒ肷
		list.SetColumnWidth(CI_Name,  nWidth - nCountWidth);
		list.SetColumnWidth(CI_Count, nCountWidth);
	}

}	// anonymous namespace

/////////////////////////////////////////////////////////////////////////////

BOOL CDataGroupDlg::OnInitDialog()
{
	CDataGroupDlgBase::OnInitDialog();

	ASSERT(m_pDoc);

	// O[vXg
	m_listGroups.ModifyStyle(0, LVS_REPORT | LVS_SHOWSELALWAYS | LVS_EDITLABELS);
	m_listGroups.SetExtendedStyle(
		m_listGroups.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP | LVS_EX_DOUBLEBUFFER | LVS_EX_UNDERLINEHOT);
	{
		m_listGroups.InsertColumn(CI_Name,  GenericUtility::LoadStringRes(IDS_COLUMN_GROUP_NAME), LVCFMT_LEFT);
		m_listGroups.InsertColumn(CI_Count, GenericUtility::LoadStringRes(IDS_COLUMN_ITEM_COUNT), LVCFMT_RIGHT);

		// Jݒ肷.
		ModifyListColumnWidth(m_listGroups);
	}

	// XgXV.
	UpdateList(false);
	// JgO[vI
	m_listGroups.SetItemState(static_cast<int>(m_pDoc->GetCurrentGroupIndex()), LVIS_SELECTED , LVIS_SELECTED);

	// _CAȌԂ𕜌.
	RestoreDialog();

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CDataGroupDlg::OnOK() 
{
	ASSERT(m_pDoc);

	// _CAȌԂۑ.
	SaveDialog();

	// ŌɑIĂO[v
	m_nSelectedGroup = GetSelectedItem();

	CDataGroupDlgBase::OnOK();
}

void CDataGroupDlg::OnCancel() 
{
	// _CAȌԂۑ.
	SaveDialog();

	CDataGroupDlgBase::OnCancel();
}

void CDataGroupDlg::OnSize(UINT nType, int cx, int cy)
{
	// HACK: Xĝ}
	GenericUtility::CSuspendRedraw sr(&m_listGroups);

	CDataGroupDlgBase::OnSize(nType, cx, cy);

	if (::IsWindow(m_listGroups.GetSafeHwnd())) {
		// Jݒ肷.
		ModifyListColumnWidth(m_listGroups);
	}
}

void CDataGroupDlg::OnNMDblclkListGroup(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	*pResult = 0;

#if 0	// HACK: NbNŖOҏWA_uNbNŌ둀삵₷̂ŁA_uNbN͖
	ASSERT(m_pDoc);

	int nItem = pNMItemActivate->iItem;
	if (nItem < 0 || (int)m_pDoc->GetGroupCount() <= nItem) {
		return;
	}

	// HACK: _uNbN OK {^̏s
	// HACK: _uNbN̈ڂ̃NbNŁAΏۂ̃O[v͑IĂ͂
	OnOK();
#endif
}

void CDataGroupDlg::OnNMRclickListGroup(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	*pResult = 0;

	// ڂłIĂ邩ǂ
	bool selected = m_listGroups.GetSelectedCount() > 0;

	// j[ʒu
	CPoint point;
	::GetCursorPos(&point);

	// HACK: V[gJbgL[\A\[XɊ܂܂Ă
	// HACK: Accelerator @\g΁Ał͂
	CMenu menu;
	VERIFY(menu.CreatePopupMenu());
	VERIFY(menu.AppendMenu(MF_ENABLED, IDC_EDIT_INSERT, GenericUtility::LoadStringRes(IDC_EDIT_INSERT)));
	VERIFY(menu.AppendMenu(selected ? MF_ENABLED : MF_GRAYED, ID_EDIT_CLEAR, GenericUtility::LoadStringRes(ID_EDIT_CLEAR)));
	VERIFY(menu.AppendMenu(selected ? MF_ENABLED : MF_GRAYED, IDC_EDIT_RENAME, GenericUtility::LoadStringRes(IDC_EDIT_RENAME)));
	VERIFY(menu.AppendMenu(MF_SEPARATOR));
	VERIFY(menu.AppendMenu(selected ? MF_ENABLED : MF_GRAYED, IDC_EDIT_UP, GenericUtility::LoadStringRes(IDC_EDIT_UP)));
	VERIFY(menu.AppendMenu(selected ? MF_ENABLED : MF_GRAYED, IDC_EDIT_DOWN, GenericUtility::LoadStringRes(IDC_EDIT_DOWN)));
	VERIFY(menu.AppendMenu(MF_SEPARATOR));
	VERIFY(menu.AppendMenu(MF_ENABLED, ID_EDIT_SELECT_ALL, GenericUtility::LoadStringRes(ID_EDIT_SELECT_ALL)));

	// ReLXgj[\
	UINT nID = menu.TrackPopupMenuEx(
		TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD,
		point.x, point.y, this, NULL);

	menu.DestroyMenu();

	// ReLXgj[
	// TODO: {Ȃ ID_EDIT_COPY Ȃǂ̃nhŏׂ
	switch (nID) {
	case IDC_EDIT_INSERT:
		DoAdd();
		break;
	case ID_EDIT_CLEAR:
		DoDelete();
		break;
	case IDC_EDIT_RENAME:
		// HACK: IĂ鍀ڂҏW
		GenericUtility::ListCtrl_EditSelectedLabel(m_listGroups);
		break;
	case IDC_EDIT_UP:
		DoMove(true);
		break;
	case IDC_EDIT_DOWN:
		DoMove(false);
		break;
	case ID_EDIT_SELECT_ALL:
		SelectAllItems();
		break;
	}
}

void CDataGroupDlg::OnLvnKeyDownListGroup(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVKEYDOWN *pKeyDown = reinterpret_cast<NMLVKEYDOWN*>(pNMHDR);
	*pResult = 0;

	if (!pKeyDown) {
		return;
	}

	// HACK: \[XɊ܂܂V[gJbgL[gp
	// TODO: {Ȃ TranslateAccelerator ȂǂgAID_EDIT_XXX Ȃǂ̃nhŏׂ

	switch (pKeyDown->wVKey) {
	// Delete
	case VK_DELETE:
		DoDelete();
		break;
	// Insert
	case VK_INSERT:
		DoAdd();
		break;
	// F2
	case VK_F2:
		// HACK: IĂ鍀ڂҏW
		GenericUtility::ListCtrl_EditSelectedLabel(m_listGroups);
		break;
	default:
		if (GenericUtility::IsKeyPressed(VK_CONTROL)) {
			switch (pKeyDown->wVKey) {
			// Ctrl-A
			case 'A':
				SelectAllItems();
				break;
			// 
			case VK_UP:
				DoMove(true);
				// HACK: Ctrl+㉺L[ŃtH[JXڂ̂h
				*pResult = 1;
				break;
			// 
			case VK_DOWN:
				DoMove(false);
				// HACK: Ctrl+㉺L[ŃtH[JXڂ̂h
				*pResult = 1;
				break;
			}
		}
	}
}

void CDataGroupDlg::OnLvnBeginLabelEditListGroup(NMHDR *pNMHDR, LRESULT *pResult)
{
#ifdef MODIFY_CURRENT_GROUP_NAME
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);
	*pResult = 0;

	if (!pDispInfo) {
		return;
	}
	if (pDispInfo->item.iSubItem != 0) {
		return;
	}

	// HACK: JgO[v̂ݑΏ
	if (pDispInfo->item.iItem != m_pDoc->GetCurrentGroupIndex()) {
		return;
	}

	CEdit* edit = m_listGroups.GetEditControl();
	if (!edit) {
		return;
	}

	// HACK: JgO[v͕\ύXĂ̂ŁÃO[vݒ肷
	// HACK: (ׂẴO[vɑ΂Ă̏sĂAƂ肠JgO[v݂̂ΏۂƂĂ)
	edit->SetWindowText(m_pDoc->GetGroupName(pDispInfo->item.iItem));
#endif	// #ifdef MODIFY_CURRENT_GROUP_NAME
}

void CDataGroupDlg::OnLvnEndLabelEditListGroup(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);
	*pResult = 0;

	if (!pDispInfo) {
		return;
	}
	if (!(pDispInfo->item.mask & LVIF_TEXT)) {
		return;
	}
	if (pDispInfo->item.iSubItem != 0) {
		return;
	}

	// O[vύX
	if (m_pDoc->SetGroupName(pDispInfo->item.iItem, pDispInfo->item.pszText)) {
		// XgXV.
		UpdateList(true);
	}
}

/////////////////////////////////////////////////////////////////////////////

int CDataGroupDlg::GetSelectedGroup() const
{
	return m_nSelectedGroup;
}

void CDataGroupDlg::DoDelete()
{
	ASSERT(m_pDoc);

	// IĂACẽCfbNX
	IntVec indices = GetAllSelectedItems();

	// HACK: JgO[v͍폜łȂ
	// HACK: JgO[vIč폜悤ƂƂA_CAO\
	if (indices.size() == 1 && indices.front() == m_pDoc->GetCurrentGroupIndex()) {
		AfxMessageBox(IDS_ERROR_DELETE_CURRENT_GROUP, MB_OK | MB_ICONINFORMATION);
		return;
	}

	for (IntVec::reverse_iterator it = indices.rbegin(); it != indices.rend(); ++it) {
		VERIFY(m_pDoc->DeleteGroup(*it));
	}

	// XgXV
	UpdateList(false);
}

void CDataGroupDlg::DoAdd()
{
	ASSERT(m_pDoc);

	// Iʒu
	int item = GetSelectedItem();
	// ǉʒu
	// (IʒuA邢͑IĂȂΖ)
	// (ǉꂽO[v̈ʒuɂȂ)
	size_t pos = item >= 0 ? item : m_pDoc->GetGroupCount();

	// wʒuɒǉ
	if (m_pDoc->AddGroup(pos, GenericUtility::LoadStringRes(IDS_GROUP_NAME_NEW_GROUP))) {
		// XgXV
		UpdateList(false);

		// ǉO[vҏW
		m_listGroups.EditLabel(static_cast<int>(pos));
		// HACK: ǉO[vI
		m_listGroups.SetItemState(static_cast<int>(pos), LVIS_SELECTED, LVIS_SELECTED);
	}
}

void CDataGroupDlg::DoMove(bool up)
{
	ASSERT(m_pDoc);

	// ړ
	int move = up ? -1 : 1;

	// IĂACe
	IntVec selected = GetAllSelectedItems();

	// ړ
	if (m_pDoc->MoveGroups(CListPasteDoc::IndexVec(selected.begin(), selected.end()), move)) {
		// XgXV
		UpdateList(true, move);
	}
}

void CDataGroupDlg::SelectAllItems()
{
	GenericUtility::ListCtrl_SelectAllItems(m_listGroups);
}

void CDataGroupDlg::UpdateList(bool bKeepSelection, int nSelectOffset)
{
	ASSERT(m_pDoc);

	GenericUtility::CSuspendRedraw sr(&m_listGroups);

	// IĂACe
	IntVec selected;
	if (bKeepSelection) {
		selected = GetAllSelectedItems();
	}

	// ׂč폜.
	m_listGroups.DeleteAllItems();

	// O[v
	size_t nCount = m_pDoc->GetGroupCount();

	// HACK: ݂̃JgO[v
	// HACK: (ACe擾邽߂ɃJgύXĂ̂AŖ߂߂̂)
	size_t nCurrentGroup = m_pDoc->GetCurrentGroupIndex();
	for (size_t i = 0; i < nCount; ++i) {
		// HACK: JgO[vύX
		VERIFY(m_pDoc->SetCurrentGroup(i));

		// O
		CString strName = m_pDoc->GetGroupName(i);
		// ACe
		size_t nItemCount = m_pDoc->GetCurrentTextCount();
		CString strItemCount;
		strItemCount.Format(_T("%d"), nItemCount);

#ifdef MODIFY_CURRENT_GROUP_NAME
		// HACK: JgO[v "[ ... ]" ł
		if (i == nCurrentGroup) {
			strName      = _T("[ ") + strName + _T(" ]");
			strItemCount = _T("[ ") + strItemCount + _T(" ]");
		}
#endif	// #ifdef MODIFY_CURRENT_GROUP_NAME

		// O
		ASSERT(CI_Name == 0);
		m_listGroups.InsertItem(static_cast<int>(i), strName);
		// ACe
		m_listGroups.SetItemText(static_cast<int>(i), CI_Count, strItemCount);
	}
	// HACK: JgO[vɖ߂
	VERIFY(m_pDoc->SetCurrentGroup(nCurrentGroup));

	if (!selected.empty()) {
		// IĂACeIȂ
		for (IntVec::iterator it = selected.begin(); it != selected.end(); ++it) {
			// I.
			m_listGroups.SetItemState(*it + nSelectOffset, LVIS_SELECTED , LVIS_SELECTED);
		}

		// HACK: IĂŏ̍ڂɃtH[JXڂ
		m_listGroups.SetItemState(selected.front() + nSelectOffset, LVIS_FOCUSED, LVIS_FOCUSED);
	}
}

int CDataGroupDlg::GetSelectedItem() const
{
	return GenericUtility::ListCtrl_GetSelectedItem(m_listGroups);
}

CDataGroupDlg::IntVec CDataGroupDlg::GetAllSelectedItems() const
{
	return GenericUtility::ListCtrl_GetAllSelectedItems(m_listGroups);
}

void CDataGroupDlg::OnInitializeDialogSizeHelper(DialogUtility::CDialogSizeHelper& dsh)
{
	using namespace DialogUtility;

	dsh.AddControlForSize(&m_listGroups,            CDialogSizeHelper::SyncTypeBottomRight, TRUE);
	dsh.AddControlForPosition(GetDlgItem(IDOK),     CDialogSizeHelper::SyncTypeBottomRight, TRUE);
	dsh.AddControlForPosition(GetDlgItem(IDCANCEL), CDialogSizeHelper::SyncTypeBottomRight, TRUE);

	// _CAO
	CRect rectDialog;
	GetWindowRect(rectDialog);

	// Xg
	CRect rectList;
	m_listGroups.GetWindowRect(rectList);

	// _CAO̍ŏTCY
	CSize sizeMin;
	sizeMin.cx = rectDialog.Width();
	sizeMin.cy = rectDialog.Height() - rectList.Height();

	dsh.SetParentRange(&sizeMin, NULL);
}

/////////////////////////////////////////////////////////////////////////////
// HACK: _CAȌԂ́AX^eBbNϐɕۑ邾ŁAt@Cɂ͕ۑȂ
// HACK: (ċNƏ)

DialogUtility::CDialogPositionSaver  CDataGroupDlg::m_DialogPosition;
DialogUtility::CListColumnWidthSaver CDataGroupDlg::m_ListColumnWidth;

void CDataGroupDlg::SaveDialog()
{
	// _CAOʒu擾.
	m_DialogPosition.Save(this);
	// Xg̃J擾.
	m_ListColumnWidth.Save(&m_listGroups);
}

void CDataGroupDlg::RestoreDialog()
{
	// _CAOʒu𕜌.
	m_DialogPosition.Restore(this);
	// Xg̃Jʒu𕜌.
	if (!m_ListColumnWidth.Restore(&m_listGroups)) {
		// HACK: JʒułȂA܂lɐݒ肷
		ModifyListColumnWidth(m_listGroups);
	}
}
