
// ListPasteDlg.cpp : t@C
//

#include "stdafx.h"
#include "ListPaste.h"
#include "ListPasteDlg.h"
#include "DataGroupDlg.h"
#include "OptionDlg.h"

#include "../GenericLib/ChangeFontSize.h"
#include "../GenericLib/DragDrop.h"
#include "../GenericLib/MiscUtil.h"
#include "../GenericLib/SerializeObject.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


////////////////////////////////////////////////////////////////////////////////
// AvP[Ṽo[WɎg CAboutDlg _CAO

class CAboutDlg : public CDialog
{
public:
	CAboutDlg(bool bNoLink = false);

// _CAO f[^
	enum {
		/// ʏ About _CAO (LinkCtrl gp)
		IDD = IDD_ABOUTBOX,
		/// LinkCtrl gpȂ About _CAO
		/// HACK: Windows 2000 ł LinkCtrl gpłȂ̂ŁAgKv
		IDD_NOLINK = IDD_ABOUTBOX_NOLINK,
	};

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g

// 
protected:
	DECLARE_MESSAGE_MAP()
	afx_msg void OnNMClickSyslinkUrl(NMHDR *pNMHDR, LRESULT *pResult);
};

CAboutDlg::CAboutDlg(bool bNoLink)
	: CDialog(bNoLink ? CAboutDlg::IDD_NOLINK : CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	ON_NOTIFY(NM_CLICK, IDC_SYSLINK_URL, &OnNMClickSyslinkUrl)
END_MESSAGE_MAP()

void CAboutDlg::OnNMClickSyslinkUrl(NMHDR *pNMHDR, LRESULT *pResult)
{
	*pResult = 0;

	if (!pNMHDR) {
		return;
	}
	PNMLINK pNMLink = (PNMLINK)pNMHDR;

	// URL J
	VERIFY((int)::ShellExecuteW(NULL, L"open", pNMLink->item.szUrl, NULL, NULL, SW_SHOW) > 32);
}

////////////////////////////////////////////////////////////////////////////////

namespace {

	/**
	 * ^C}[ ID (1, 2, 3 ͎gps; see \vc\atlmfc\include\afxdockablepane.h).
	 */
	enum {
		TIMER_ID_BEGIN = 100,

#ifdef LISTPASTEDLG_DELAYEDEXECUTION
		/// xs^C}[ ID
		TIMER_ID_DELAYED_EXECUTION,
#endif	// #ifdef LISTPASTEDLG_DELAYEDEXECUTION
		/// \XV^C}[ ID
		TIMER_ID_UPDATE_TRANSPARENT,
		/// 񓯊̃|[O^C}[ ID
		TIMER_ID_ASYNC_SEARCH,
	};

#ifdef LISTPASTEDLG_DELAYEDEXECUTION
	/// xs^C}[Ԋu (ms)
	static const UINT_PTR DELAYED_EXECUTION_TIMER_INTERVAL = 100;
	/// xsWu ID
	static const UINT_PTR SEARCH_JOB_ID = 0;
#endif	// #ifdef LISTPASTEDLG_DELAYEDEXECUTION

	/// \XV^C}[Ԋu (ms)
	static const UINT_PTR UPDATE_TRANSPARANT_TIMER_INTERVAL = 1000;

	/// 񓯊̃|[O^C}[Ԋu (ms)
	static const UINT_PTR ASYNC_SEARCH_TIMER_INTERVAL = 100;

/// 񓯊m点EBhEbZ[W (R[obN͕ʃXbhŎŝŁAbZ[W|Xg邾ɂ)
#define WM_COMPLETE_ASYNC_SEARCH	(WM_APP + 100)

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * XgRg[̃JA݂̕tɒ߂.
	 * J͈ł邱ƂO.
	 */
	void AdjustColumnWidth(CListCtrl& list)
	{
		CRect rect;
		list.GetClientRect(rect);

		// HACK: Xgƍő咷f[^̂A傫ɂ
		// HACK: (ݕ\Ăf[^̒̍ő咷Ȃ̂ŁAXN[肫Ȃ\.
		// HACK:  ̏ꍇ́AF5 ōĕ\邩ATCY΂悢)
		GenericUtility::CSuspendRedraw sr(&list);
		// HACK: IɃTCY𒲐߂ (ő咷̃f[^܂悤ɂ)
		list.SetColumnWidth(0, LVSCW_AUTOSIZE);
		// HACK: TCY߂̌ʂXgAXg̉tɍL
		list.SetColumnWidth(0, max(rect.Width(), list.GetColumnWidth(0)));
	}

	/**
	 * ^CgEBhE (X^eBbNRg[Ȃ) ƑΏۃEBhE (GfBbgRg[Ȃ) ɑ΂āA
	 * ΏۃEBhE̕臒lȉȂ^CgEBhE\ɂ.
	 * ĂяȍԂ́A^CgEBhE͏ɌŒAΏۃEBhÉ̕u^CgEBhE\̂Ƃ̕vłȂ΂ȂȂ.
	 *
	 * @param[in] pWndParent ^CgEBhEƑΏۃEBhE̐eEBhE (_CAOȂ)
	 * @param[in] pWndTitle  ^CgEBhE (T^Iɂ̓X^eBbNRg[)
	 * @param[in] pWndTarget ΏۃEBhE (̕ɂāA^CgEBhE̕\/\߂)
	 * @param[in] threshold  ^CgEBhE̕\/\؂ւ臒l (ΏۃEBhE̕)
	 * @param[in] margin     ^CgEBhEE[ƑΏۃEBhE[̊Ԃ̃}[W (^CgEBhE\Ƃ)
	 */
	void ControlTitledWindow(CWnd* pWndParent, CWnd* pWndTitle, CWnd* pWndTarget, int threshold, int margin)
	{
		ASSERT(pWndParent);
		ASSERT(pWndTitle);
		ASSERT(pWndTarget);

		// Title ̈ʒuƕ
		CRect rcTitle;
		pWndTitle->GetWindowRect(rcTitle);
		int widthTitle = rcTitle.Width();

		// Target ̈ʒuƕ
		CRect rcTarget;
		pWndTarget->GetWindowRect(rcTarget);
		int widthTarget = rcTarget.Width();

		// ݂̏
		//  * Title ́A傫ʒuŒ
		//  * Target ́Aʒu͕s (Ǒʂɂ)
		//    傫́AuTitle \̂Ƃɂ傤ǂ傫vɂȂĂ
		//  Title  : +---------+
		//  Target : +--------------------------+                or
		//         :              +--------------------------+
		//
		// ύX̏
		//  Title  : +---------+ (\)
		//  Target : +--------------------------+
		//  or
		//  Title  : +---------+ (\)
		//  Target :              +-------------+
		//                     +--+ (margin)

		// ΏۃEBhE̕臒l𒴂Ă
		if (widthTarget > threshold) {
			// ^CgEBhE\
			pWndTitle->ShowWindow(SW_SHOWNA);

			//  Title  : +---------+ (\)
			//  Target :              +-------------+
			//                     +--+ (margin)
			rcTarget.left  = rcTitle.right + margin;
			rcTarget.right = rcTarget.left + widthTarget - (widthTitle + margin);
		}
		else {
			// ^CgEBhE\ɂ
			pWndTitle->ShowWindow(SW_HIDE);

			//  Title  : +---------+ (\)
			//  Target : +--------------------------+
			rcTarget.left  = rcTitle.left;
			rcTarget.right = rcTarget.left + widthTarget;
		}

		pWndParent->ScreenToClient(rcTarget);
		pWndTarget->MoveWindow(rcTarget);
	}

}   // anonymous namespace

////////////////////////////////////////////////////////////////////////////////
// CListPasteDlg _CAO

CListPasteDlg::CListPasteDlg(CWnd* pParent /*=NULL*/)
	: CListPasteDlgBase(CListPasteDlg::IDD, pParent)
	, m_transparentMode(TM_None)
	, m_nCaptureStatus(ECS_None)
	, m_hDragCursor(NULL)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CListPasteDlg::DoDataExchange(CDataExchange* pDX)
{
	CListPasteDlgBase::DoDataExchange(pDX);

	DDX_Control	(pDX, IDC_STATIC_GROUP,			m_stcGroup);
	DDX_Control	(pDX, IDC_COMBO_GROUP,			m_cmbGroup);
	DDX_Control	(pDX, IDC_STATIC_SEARCH,		m_stcSearch);
	DDX_Control	(pDX, IDC_EDIT_SEARCH,			m_edtSearch);
	DDX_Control	(pDX, IDC_LIST_TEXTS,			m_listTexts);

	// HACK: CSystemSettings Ƃ̊Ԃłs
	CString strSearch;
	BOOL bMatchFirst;
	// _CAOɐݒ肷
	if (!pDX->m_bSaveAndValidate) {
		strSearch     = CSystemSettings::Instance().SearchString().c_str();
		bMatchFirst = CSystemSettings::Instance().MatchFirst();
	}
	DDX_Text	(pDX, IDC_EDIT_SEARCH,			strSearch);
	DDX_Check	(pDX, IDC_CHECK_MATCH_FIRST,	bMatchFirst);
	// _CAO擾
	if (pDX->m_bSaveAndValidate) {
		CSystemSettings::Instance().SetSearchString((LPCWSTR)CT2W(strSearch));
		CSystemSettings::Instance().SetMatchFirst(bMatchFirst == TRUE);
	}
}

BOOL CListPasteDlg::PreTranslateMessage(MSG* pMsg)
{
	VERIFY(m_contextMenu.HandleMenuMsg(pMsg));
	return CListPasteDlgBase::PreTranslateMessage(pMsg);
}

BEGIN_MESSAGE_MAP(CListPasteDlg, CListPasteDlgBase)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_QUERYENDSESSION()
	ON_WM_DESTROY()
	ON_WM_SIZE()
	ON_WM_TIMER()
	ON_WM_SETCURSOR()
	ON_MESSAGE(WM_KICKIDLE,						&CListPasteDlg::OnKickIdle)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
	ON_WM_MOUSEMOVE()
	ON_WM_MOUSEWHEEL()
	ON_WM_DRAWCLIPBOARD()
	ON_WM_CHANGECBCHAIN()
	ON_CBN_SELCHANGE(IDC_COMBO_GROUP,			&CListPasteDlg::OnCbnSelchangeComboGroup)
	ON_BN_CLICKED(IDC_BUTTON_GROUP,				&CListPasteDlg::OnBnClickedButtonGroup)
	ON_EN_CHANGE(IDC_EDIT_SEARCH,				&CListPasteDlg::OnEnChangeEdtSearch)
	ON_EN_SETFOCUS(IDC_EDIT_SEARCH,				&CListPasteDlg::OnEnSetFocusEdtSearch)
	ON_EN_KILLFOCUS(IDC_EDIT_SEARCH,			&CListPasteDlg::OnEnKillFocusEdtSearch)
	ON_BN_CLICKED(IDC_CHECK_MATCH_FIRST,		&CListPasteDlg::OnBnClickedChkMatchFirst)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_TEXTS,		&CListPasteDlg::OnNMDblclkListTexts)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_TEXTS,		&CListPasteDlg::OnNMRclickListTexts)
	ON_NOTIFY(LVN_BEGINDRAG, IDC_LIST_TEXTS,	&CListPasteDlg::OnLvnBegindragListTexts)
	ON_NOTIFY(LVN_BEGINRDRAG, IDC_LIST_TEXTS,	&CListPasteDlg::OnLvnBeginrdragListTexts)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LIST_TEXTS,		&CListPasteDlg::OnLvnKeyDownListTexts)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST_TEXTS,	&CListPasteDlg::OnLvnEndLabelEditListTexts)
	ON_NOTIFY(LVN_GETDISPINFO, IDC_LIST_TEXTS,	&CListPasteDlg::OnLvnGetdispinfoListTexts)
	ON_MESSAGE(WM_COMPLETE_ASYNC_SEARCH,		&CListPasteDlg::OnCompleteAsyncSearch)
END_MESSAGE_MAP()


////////////////////////////////////////////////////////////////////////////////
// CListPasteDlg bZ[W nh

BOOL CListPasteDlg::OnInitDialog()
{
	CListPasteDlgBase::OnInitDialog();

	// "o[W..." j[VXe j[ɒǉ܂B

	// IDM_ABOUTBOX ́AVXe R}h͈͓̔ɂȂ΂Ȃ܂B
	ASSERT((IDM_OPTION_DIALOG & 0xFFF0) == IDM_OPTION_DIALOG && IDM_OPTION_DIALOG < 0xF000);
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX && IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		pSysMenu->AppendMenu(MF_SEPARATOR);
		pSysMenu->AppendMenu(MF_STRING, IDM_OPTION_DIALOG, GenericUtility::LoadStringRes(IDS_OPTION_DIALOG));
		pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX,      GenericUtility::LoadStringRes(IDS_ABOUTBOX));
	}

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	////////////////////////////////////////////////////////////////////////////////
	// 

	// \
	InitTransparent();

#ifdef LISTPASTEDLG_DELAYEDEXECUTION
	// xs
	InitializeDelayedExecution(TIMER_ID_DELAYED_EXECUTION);
	// xsWuݒ肷
	SetDelayedExecutor(SEARCH_JOB_ID, boost::bind(&CListPasteDlg::UpdateSearchFunc, this));
#endif	// #ifdef LISTPASTEDLG_DELAYEDEXECUTION

	// EBhEnCCg
	m_HighlightWindow.Initialize();

	// hLg
	m_list.Initialize(&m_listTexts);
	m_doc.Initialize(&m_list, this);

	m_listTexts.ModifyStyle(0, LVS_REPORT | LVS_SHOWSELALWAYS | LVS_EDITLABELS);
	m_listTexts.SetExtendedStyle(
		m_listTexts.GetExtendedStyle() | LVS_EX_FULLROWSELECT | LVS_EX_LABELTIP | LVS_EX_DOUBLEBUFFER);
	m_listTexts.InsertColumn(0, _T("Text"));

	// (ǂݍ݂ɎԂ\)
	GenericUtility::CWaitCursorEx wc;

	// _CAȌԂ𕜌
	if (!Load()) {
		AfxMessageBox(IDS_ERROR_LOAD, MB_OK | MB_ICONERROR);
	}

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

void CListPasteDlg::OnOK()
{
	// (Rs[ɎԂ\)
	GenericUtility::CWaitCursorEx wc;

	// HACK: Rs[
	DoCopy();

#if 0
	CListPasteDlgBase::OnOK();
#endif
}

void CListPasteDlg::OnCancel()
{
	// (݂ɎԂ\)
	GenericUtility::CWaitCursorEx wc;

	// _CAȌԂۑ
	// HACK: f[^ƂɕۑɎԂ邩Ȃ̂ŁAIɕۑƂƏÎݕۑ悤ɂ
	if (!Save()) {
		AfxMessageBox(IDS_ERROR_SAVE, MB_OK | MB_ICONERROR);
	}

	CListPasteDlgBase::OnCancel();
}

void CListPasteDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_OPTION_DIALOG)
	{
		COptionDlg dlgOption;
		if (dlgOption.DoModal() == IDOK) {
			const CSystemSettings& settingsNew = CSystemSettings::Instance();
			const CSystemSettings& settingsOrg = dlgOption.SettingsOrg();
			if (settingsNew.TopMost() != settingsOrg.TopMost()) {
				// TopMost ݒ肷
				SetupTopMost();
			}
			if (settingsNew.WatchClipboardMode() != settingsOrg.WatchClipboardMode()) {
				// Nbv{[hr[Aݒ肷
				SetupWatchClipboard();
			}
			if (settingsNew.ShrinkOnInactive()      != settingsOrg.ShrinkOnInactive() ||
				settingsNew.TransparentOnInactive() != settingsOrg.TransparentOnInactive())
			{
				// \(+ k\)XV
				UpdateTransparent();
			}
		}
	}
	else if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		// Windows 2000 ȑOǂ (Windows 2000 ܂)
		using namespace GenericUtility;
		bool bPreWin2k = COSVersion::Instance().GetOSType() <= COSVersion::OST_2k;
		// HACK: Windows 2000 ȑOȂALinkCtrl gpȂ
		CAboutDlg dlgAbout(bPreWin2k);
		dlgAbout.DoModal();
	}
	else
	{
		CListPasteDlgBase::OnSysCommand(nID, lParam);
	}
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CListPasteDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CListPasteDlgBase::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CListPasteDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

BOOL CListPasteDlg::OnQueryEndSession()
{
	// HACK: _CAȌԂۑ (svH)
	// HACK: (ʂ̐ۂ̓`FbNȂ)
	Save();

	return TRUE;
}

void CListPasteDlg::OnDestroy()
{
	// Nbv{[hr[A`FC폜
	m_clipboardChain.reset();

	CListPasteDlgBase::OnDestroy();
}

void CListPasteDlg::OnSize(UINT nType, int cx, int cy)
{
	// HACK: Xĝ}
	GenericUtility::CSuspendRedraw sr(&m_listTexts);

	CListPasteDlgBase::OnSize(nType, cx, cy);

	// HACK: Ƃ́A"O[v"  "" ̕\ɂ
	if (::IsWindow(m_stcGroup.GetSafeHwnd()) && ::IsWindow(m_cmbGroup.GetSafeHwnd())) {
		ControlTitledWindow(this, &m_stcGroup,  &m_cmbGroup,  140, 1);
	}
	if (::IsWindow(m_stcSearch.GetSafeHwnd()) && ::IsWindow(m_edtSearch.GetSafeHwnd())) {
		ControlTitledWindow(this, &m_stcSearch, &m_edtSearch, 140, 1);
	}

	// Xg̃Jݒ肷
	if (::IsWindow(m_listTexts.GetSafeHwnd())) {
		AdjustColumnWidth(m_listTexts);
	}
}

// HACK: UpdateTransparent()  OnKickIdle() sAS OnTimer() ōs̗͌]n
// HACK: OnKickIdle() ́AANeBuԂł͔rIĂ΂邪AANeBuԂ̂Ƃ͌Ă΂Ȃ
// HACK: OnTimer() ̂Ƃ́AANeBuԂɊւ炸ƊĎĂȂ΂ȂȂA^C}[Ԋuɂĕׂ𒲐߂邱Ƃł

void CListPasteDlg::OnTimer(UINT_PTR nIDEvent)
{
	if (nIDEvent == TIMER_ID_UPDATE_TRANSPARENT) {
		KillTimer(TIMER_ID_UPDATE_TRANSPARENT);

		// HACK: ʏ\̂ƂA^C}[ɂĔANeBuł邱ƂoĔɂ
		if (m_transparentMode == TM_None) {
			// \XV
			UpdateTransparent();
		}
	}
	else if (nIDEvent == TIMER_ID_ASYNC_SEARCH) {
		// HACK: U kill āAIĂēx set 
		KillTimer(TIMER_ID_ASYNC_SEARCH);

		// Xgĕ`悷 (IԂ͂̂܂ / ǉ邾Ȃ̂ŁAĕ`͂Ȃ)
		RedrawTextList(false, false);

		// HACK: 񓯊słƂɌA^C}[Đݒ肷
		// HACK: (炩̃oOŃ^C}[ςȂɂȂ邱Ƃ.
		// HACK:  {IɂƂ͂Ȃ͂ACompleteAsyncSearch() ŕK KillTimer() ĂȂ̂ŁAÔ߃`FbNĂ)
		if (m_doc.IsSearching()) {
			// 񓯊̃|[O^C}[ݒ肷
			SetTimer(TIMER_ID_ASYNC_SEARCH, ASYNC_SEARCH_TIMER_INTERVAL, NULL);
		}
	}

	CListPasteDlgBase::OnTimer(nIDEvent);
}

BOOL CListPasteDlg::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
	if (
		// HACK: NCAg̈悠邢̓^Cgo[ (CNCSimulateDialog  HTCAPTION ݒ肵Ă̂ŁAHTCAPTION ܂߂)
		(nHitTest == HTCLIENT || nHitTest == HTCAPTION) &&
		// HACK: WaitCursor ݒ蒆 (= 񓯊s)
		GenericUtility::CWaitCursorEx::IsWaiting())
	{
		// HACK: WaitCursor 𕜌
		GenericUtility::CWaitCursorEx::Restore();
		// 
		return TRUE;
	}
	else {
		// s
		return CListPasteDlgBase::OnSetCursor(pWnd, nHitTest, message);
	}
}

LRESULT CListPasteDlg::OnKickIdle(WPARAM wParam, LPARAM lParam)
{
	// HACK: ANeBûƂɗ]vȏȂĂނ悤ɁA\̂Ƃ́A
	// HACK: ^C}[ł͂Ȃ OnKickIdle() ŃANeBuł邱ƂoĒʏ\ɂ
	// HACK: (bZ[W߂̂Ƃ WM_KICKIDLE ͂Ȃ̂ŁA TM_Display/TM_Shrink ݂̂ɂȂ)
	if (m_transparentMode != TM_None) {
		// \XV
		UpdateTransparent();
	}

	// HACK: FALSE łȂ΂ȂȂ (TRUE ɂƏdȂ)
	return FALSE;
}

void CListPasteDlg::OnLButtonDown(UINT nFlags, CPoint point)
{
	// }EXLv`[I
	EndCapture();
	CListPasteDlgBase::OnLButtonDown(nFlags, point);
}

void CListPasteDlg::OnLButtonUp(UINT nFlags, CPoint point)
{
	// {^Ń}EXLv`[
	if ((m_nCaptureStatus & ECS_Capturing) && (m_nCaptureStatus & ECS_LeftButton)) {
		// eLXg𑗂
		SendText(point);
		// }EXLv`[I
		EndCapture();
	}
	CListPasteDlgBase::OnLButtonUp(nFlags, point);
}

void CListPasteDlg::OnRButtonDown(UINT nFlags, CPoint point)
{
	// }EXLv`[I
	EndCapture();
	CListPasteDlgBase::OnRButtonDown(nFlags, point);
}

void CListPasteDlg::OnRButtonUp(UINT nFlags, CPoint point)
{
	// E{^Ń}EXLv`[
	if ((m_nCaptureStatus & ECS_Capturing) && !(m_nCaptureStatus & ECS_LeftButton)) {
		// eLXg𑗂
		SendText(point);
		// }EXLv`[I
		EndCapture();
	}
	CListPasteDlgBase::OnRButtonUp(nFlags, point);
}

void CListPasteDlg::OnMouseMove(UINT nFlags, CPoint point)
{
	// }EXLv`[
	if (m_nCaptureStatus & ECS_Capturing) {
		// }EXJ[\ʒuɂEBhE
		CWnd* pWnd = GetWindowFromPoint(point);
		if (pWnd) {
			// EBhEnCCg
			m_HighlightWindow.HighlightWindow(pWnd);
		}
	}
	CListPasteDlgBase::OnMouseMove(nFlags, point);
}

BOOL CListPasteDlg::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt)
{
	// Xg̃tHgTCY}EXzC[ŕύX
	if (DialogUtility::ChangeFontSizeByMouseWheel(&m_listTexts, nFlags, zDelta, pt)) {
		// J𒲐߂
		// HACK: XN[o[̗Lŕς\邽߁AeLXgTCYύXɂsKv
		AdjustColumnWidth(m_listTexts);
		return TRUE;
	}
	else {
		return CListPasteDlgBase::OnMouseWheel(nFlags, zDelta, pt);
	}
}

void CListPasteDlg::OnDrawClipboard()
{
	bool currentGroupUpdated = false;
	if (m_doc.PasteOnDrawClipboard(currentGroupUpdated)) {
		// HACK: Nbv{[hO[vǉꂽȂ̂ŁAXV
		UpdateGroupCombo();
		// HACK: JgO[vXVĂ΁AeXV
		if (currentGroupUpdated) {
			UpdateSearch();
		}
	}

	if (m_clipboardChain) {
		m_clipboardChain->OnDrawClipboard();
	}
}

void CListPasteDlg::OnChangeCbChain(HWND hWndRemove, HWND hWndAfter)
{
	if (m_clipboardChain) {
		m_clipboardChain->OnChangeCbChain(hWndRemove, hWndAfter);
	}
}

void CListPasteDlg::OnCbnSelchangeComboGroup()
{
	// IꂽO[v
	int nCurSel = m_cmbGroup.GetCurSel();
	if (nCurSel != CB_ERR) {
		// ݂̃O[vύX
		m_doc.SetCurrentGroup(nCurSel);

		// eXV
		UpdateSearch();
	}
}

void CListPasteDlg::OnBnClickedButtonGroup()
{
	// HACK: O[v_CAO (ҏW\) JOɁAobNAbvĂ
	// HACK: (Undo pƂ͕ʂ̃obNAbvf[^ɕۑĂ)
	// HACK: BackUp: Jn̈O, Snapshot: N/A, Main: Jn ---> BackUp: Jn̈O, Snapshot: Jn, Main: Jn
	m_doc.BackUp(CListPasteDoc::BU_Snapshot);

	// O[v_CAO\
	CDataGroupDlg dlg(&m_doc, this);
	if (dlg.DoModal() == IDOK) {
		// ŌɑIĂO[v
		int group = dlg.GetSelectedGroup();
		// ݂̃O[vύX
		if (group >= 0) {
			m_doc.SetCurrentGroup(group);
		}

		// HACK: Jn̏ԂAobNAbvƂĕێ悤ɂ
		// HACK: BackUp: Jn̈O, Snapshot: Jn, Main: ύX ---> BackUp: Jn, Snapshot: Jn̈O, Main: ύX
		m_doc.SwapBackUp();
		// HACK: ---> BackUp: Jn, Snapshot: N/A, Main: ύX
		m_doc.ClearBackUp(CListPasteDoc::BU_Snapshot);

		// HACK: O[vR{{bNXXV
		UpdateGroupCombo();
		// eXV
		UpdateSearch();
	}
	else {
		// HACK: ύXej --> obNAbvɖ߂
		// HACK: ʏ̃obNAbvf[^܂߂āAO[v_CAO\ȌԂɊSɖ߂͂
		// HACK: BackUp: Jn̈O, Snapshot: Jn, Main: ύX ---> BackUp: Jn̈O, Snapshot: ύX, Main: Jn
		VERIFY(m_doc.Undo(CListPasteDoc::BU_Snapshot));
		// HACK: ---> BackUp: Jn̈O, Snapshot: N/A, Main: Jn
		m_doc.ClearBackUp(CListPasteDoc::BU_Snapshot);

		// TODO: _CAO\ɔ񓯊ŁArŃLZꂽꍇ́AeXVKv
		// HACK: 񓯊LZȂꍇ́AʂXVKv͂Ȃ
	}
}

void CListPasteDlg::OnEnChangeEdtSearch()
{
	// eXV
	UpdateSearch();
}

void CListPasteDlg::OnEnSetFocusEdtSearch()
{
	// {͂ On ɂ
	if (CSystemSettings::Instance().ControlIme()) {
		m_ImeControl.reset(new GenericUtility::CImeControl(m_edtSearch.GetSafeHwnd(), true));
	}
}

void CListPasteDlg::OnEnKillFocusEdtSearch()
{
	// {͂ɖ߂
	m_ImeControl.reset();
}

void CListPasteDlg::OnBnClickedChkMatchFirst()
{
	// eXV
	UpdateSearch();
}

void CListPasteDlg::OnNMDblclkListTexts(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	*pResult = 0;

	// Nbv{[hɃRs[
	m_doc.Copy();
}

void CListPasteDlg::OnNMRclickListTexts(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	*pResult = 0;

	// IĂ鍀ڂ̐
	UINT selectedCount = m_doc.GetSelectedCount();
	// ڂłIĂ邩ǂ
	bool selected = selectedCount > 0;

	// j[ʒu
	CPoint point;
	::GetCursorPos(&point);

	// HACK: V[gJbgL[\A\[XɊ܂܂Ă
	// HACK: Accelerator @\g΁Ał͂
	CMenu menu;
	VERIFY(menu.CreatePopupMenu());
	VERIFY(menu.AppendMenu(m_doc.CanUndo() ? MF_ENABLED : MF_GRAYED, ID_EDIT_UNDO, GenericUtility::LoadStringRes(ID_EDIT_UNDO)));
	VERIFY(menu.AppendMenu(MF_SEPARATOR));
	VERIFY(menu.AppendMenu(selected ? MF_ENABLED : MF_GRAYED, ID_EDIT_CUT, GenericUtility::LoadStringRes(ID_EDIT_CUT)));
	VERIFY(menu.AppendMenu(selected ? MF_ENABLED : MF_GRAYED, ID_EDIT_COPY, GenericUtility::LoadStringRes(ID_EDIT_COPY)));
	VERIFY(menu.AppendMenu(MF_ENABLED, ID_EDIT_PASTE, GenericUtility::LoadStringRes(ID_EDIT_PASTE)));
	VERIFY(menu.AppendMenu(selected ? MF_ENABLED : MF_GRAYED, ID_EDIT_CLEAR, GenericUtility::LoadStringRes(ID_EDIT_CLEAR)));
	VERIFY(menu.AppendMenu(selected ? MF_ENABLED : MF_GRAYED, IDC_EDIT_EDITTEXT, GenericUtility::LoadStringRes(IDC_EDIT_EDITTEXT)));
	VERIFY(menu.AppendMenu(MF_SEPARATOR));
	VERIFY(menu.AppendMenu(MF_ENABLED, ID_EDIT_SELECT_ALL, GenericUtility::LoadStringRes(ID_EDIT_SELECT_ALL)));
	VERIFY(menu.AppendMenu(MF_SEPARATOR));
	VERIFY(menu.AppendMenu(MF_ENABLED, ID_FILE_SAVE, GenericUtility::LoadStringRes(ID_FILE_SAVE)));
	VERIFY(menu.AppendMenu(MF_SEPARATOR));
	VERIFY(menu.AppendMenu(MF_ENABLED, IDC_VIEW_UPDATE, GenericUtility::LoadStringRes(IDC_VIEW_UPDATE)));

	// [GNXv[[] j[̃R}h ID ̍ŏlƍől
	static const UINT CONTEXT_MENU_CMD_FIRST = 1;
	static const UINT CONTEXT_MENU_CMD_LAST  = 20000;	// HACK: See resource.h

	// HACK: IĂƂ́A炪Lȃt@CłĂAGNXv[[̃ReLXgj[͏oȂ
	// IĂ
	if (selectedCount == 1) {
		// IĂ邷ׂẴeLXg
		std::vector<CString> texts = m_doc.GetSelectedTextVec();
		// IĂB̃t@CpX
		CString& path = texts.front();

		// Lȃt@CpXł
		if (GenericUtility::IsValidFilePath(path)) {
			// ReLXgj[
			VERIFY(m_contextMenu.Initialize(GetSafeHwnd(), path));

			// [GNXv[[] j[
			CMenu menuExplorer;
			VERIFY(menuExplorer.CreatePopupMenu());

			// [GNXv[[] j[̓e擾
			VERIFY(m_contextMenu.QueryContextMenu(
					menuExplorer, 0, CONTEXT_MENU_CMD_FIRST, CONTEXT_MENU_CMD_LAST,
					// HACK: SHIFT Ă CMF_EXTENDEDVERBS gp (Windows GNXv[[Ɠl)
					(pNMItemActivate->uKeyFlags & LVKF_SHIFT) ? CMF_EXTENDEDVERBS : CMF_NORMAL));

			// [GNXv[[] j[ǉ
			VERIFY(menu.AppendMenu(MF_SEPARATOR));
			VERIFY(menu.AppendMenu(MF_POPUP, (UINT_PTR)(HMENU)menuExplorer, GenericUtility::LoadStringRes(IDS_MENU_EXPLORER)));
		}
	}

	// ReLXgj[\
	// HACK: CShellContextMenu::HandleMenuMsg()  WM_INITMENUPOPUP n߂ TPM_NONOTIFY ͕tȂ
	// HACK: \ʃR}h ID  notify Ȃ悤ɁAAppendMenu() ŎgR}h ID ɋCKv
	UINT nID = menu.TrackPopupMenuEx(
		TPM_LEFTALIGN | TPM_RIGHTBUTTON /*| TPM_NONOTIFY*/ | TPM_RETURNCMD,
		point.x, point.y, this, NULL);

	menu.DestroyMenu();

	// TODO: {ɎԂ镔ɂ̂ݓKp
	GenericUtility::CWaitCursorEx wc;

	// ReLXgj[
	// TODO: {Ȃ ID_EDIT_COPY Ȃǂ̃nhŏׂ
	switch (nID) {
	case ID_EDIT_UNDO:
		DoUndo();
		break;
	case ID_EDIT_CUT:
		// HACK: Rs[폜
		DoCopy();
		DoDelete();
		break;
	case ID_EDIT_COPY:
		DoCopy();
		break;
	case ID_EDIT_PASTE:
		DoPaste();
		break;
	case ID_EDIT_CLEAR:
		DoDelete();
		break;
	case IDC_EDIT_EDITTEXT:
		// HACK: IĂ鍀ڂҏW
		GenericUtility::ListCtrl_EditSelectedLabel(m_listTexts);
		break;
	case ID_EDIT_SELECT_ALL:
		SelectAllItems();
		break;
	case ID_FILE_SAVE:
		// HACK: Xg̃ReLXgj[Ȃ̂ŁA{̓Xg̃f[^̂ݕۑׂAׂĕۑĂ
		// HACK: hLgɕύXȂĂۑ
		// TODO: AvP[V [t@C]-[ۑ] ŕۑׂ
		Save(true);
		break;
	case IDC_VIEW_UPDATE:
		// HACK: J𒲐߂
		AdjustColumnWidth(m_listTexts);
		break;
	default:
		if (CONTEXT_MENU_CMD_FIRST <= nID && nID <= CONTEXT_MENU_CMD_LAST) {
			// [GNXv[[] j[s
			VERIFY(m_contextMenu.InvokeCommand(nID));
		}
	}

	m_contextMenu.Terminate();
}

void CListPasteDlg::OnLvnBegindragListTexts(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBeginDragListTexts(pNMHDR, pResult, true);
}

void CListPasteDlg::OnLvnBeginrdragListTexts(NMHDR *pNMHDR, LRESULT *pResult)
{
	OnBeginDragListTexts(pNMHDR, pResult, false);
}

void CListPasteDlg::OnLvnKeyDownListTexts(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVKEYDOWN *pKeyDown = reinterpret_cast<NMLVKEYDOWN*>(pNMHDR);
	*pResult = 0;

	if (!pKeyDown) {
		return;
	}

	// HACK: \[XɊ܂܂V[gJbgL[gp
	// TODO: {Ȃ TranslateAccelerator ȂǂgAID_EDIT_COPY Ȃǂ̃nhŏׂ

	// TODO: {ɎԂ镔ɂ̂ݓKp
	GenericUtility::CWaitCursorEx wc;

	switch (pKeyDown->wVKey) {
	// Delete
	case VK_DELETE:
		DoDelete();
		break;
	// '+'
	case VK_OEM_PLUS:
	case VK_ADD:
		DialogUtility::ChangeFontSize(&m_listTexts, true);
		break;
	// '-'
	case VK_OEM_MINUS:
	case VK_SUBTRACT:
		DialogUtility::ChangeFontSize(&m_listTexts, false);
		break;
	// F2
	case VK_F2:
		// HACK: IĂ鍀ڂҏW
		GenericUtility::ListCtrl_EditSelectedLabel(m_listTexts);
		break;
	// F5
	case VK_F5:
		// HACK: J𒲐߂
		AdjustColumnWidth(m_listTexts);
		break;
	default:
		if (GenericUtility::IsKeyPressed(VK_CONTROL)) {
			switch (pKeyDown->wVKey) {
			// Ctrl-Z
			case 'Z':
				DoUndo();
				break;
			// Ctrl-X
			case 'X':
				// HACK: Rs[폜
				DoCopy();
				DoDelete();
				break;
			// Ctrl-C
			case 'C':
				DoCopy();
				break;
			// Ctrl-V
			case 'V':
				DoPaste();
				break;
			// Ctrl-A
			case 'A':
				SelectAllItems();
				break;
			// Ctrl-S
			case 'S':
				// HACK: Xg̃V[gJbgL[Ȃ̂ŁA{̓Xg̃f[^̂ݕۑׂAׂĕۑĂ
				// HACK: hLgɕύXȂĂۑ
				// TODO: AvP[V [t@C]-[ۑ] ŕۑׂ
				Save(true);
				break;
			}
		}
	}
}

void CListPasteDlg::OnLvnEndLabelEditListTexts(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);
	*pResult = 0;

	if (!pDispInfo) {
		return;
	}
	if (!(pDispInfo->item.mask & LVIF_TEXT)) {
		return;
	}
	if (pDispInfo->item.iSubItem != 0) {
		return;
	}

	// ύX
	if (m_doc.Modify(pDispInfo->item.iItem, (LPCWSTR)CT2W(CString(pDispInfo->item.pszText)))) {
		// eXV
		// TODO: IKv͂Ȃ
		UpdateSearch();
	}
}

void CListPasteDlg::OnLvnGetdispinfoListTexts(NMHDR *pNMHDR, LRESULT *pResult)
{
	NMLVDISPINFO *pDispInfo = reinterpret_cast<NMLVDISPINFO*>(pNMHDR);
	*pResult = 0;

	if (!pDispInfo) {
		return;
	}
	if (!(pDispInfo->item.mask & LVIF_TEXT)) {
		return;
	}
	if (pDispInfo->item.iSubItem != 0) {
		return;
	}

	// eLXg
	const std::wstring& text = m_doc.GetText(pDispInfo->item.iItem);

	// eLXgݒ肷
	// HACK: Rs[ (ftHgobt@gpBӂꂽ͖)
	// HACK: UNICODE rĥƂAwstring ̓eRs[Kv͂Ȃ
	_tcsncpy(pDispInfo->item.pszText, CW2T(text.c_str()), min((size_t)pDispInfo->item.cchTextMax - 1, text.size() + 1));
	pDispInfo->item.pszText[pDispInfo->item.cchTextMax - 1] = _T('\0');
}

LRESULT CListPasteDlg::OnCompleteAsyncSearch(WPARAM wParam, LPARAM lParam)
{
	// HACK: lParam  cancelled p[^킷
	// HACK: See OnCompleteAsyncNotifyFunc()
	CompleteAsyncSearch(lParam != 0);
	return FALSE;
}

////////////////////////////////////////////////////////////////////////////////

void CListPasteDlg::OnInitializeDialogSizeHelper(DialogUtility::CDialogSizeHelper& dsh)
{
	using namespace DialogUtility;
	dsh.AddControlForSize    (GetDlgItem(IDC_COMBO_GROUP),  CDialogSizeHelper::SyncTypeRight,       TRUE);
	dsh.AddControlForPosition(GetDlgItem(IDC_BUTTON_GROUP), CDialogSizeHelper::SyncTypeRight,       TRUE);
	dsh.AddControlForSize    (GetDlgItem(IDC_EDIT_SEARCH),  CDialogSizeHelper::SyncTypeRight,       TRUE);
	dsh.AddControlForSize    (GetDlgItem(IDC_LIST_TEXTS),   CDialogSizeHelper::SyncTypeBottomRight, TRUE);

	// _CAO
	CRect rectDialog;
	GetWindowRect(rectDialog);

	// Xg
	CRect rectList;
	GetDlgItem(IDC_LIST_TEXTS)->GetWindowRect(rectList);

	// _CAO̍ŏTCY
	CSize sizeMin;
	sizeMin.cx = rectDialog.Width();
	sizeMin.cy = rectDialog.Height() - rectList.Height();

	dsh.SetParentRange(&sizeMin, NULL);
}

void CListPasteDlg::UpdateGroupCombo()
{
	// O[v
	size_t size = m_doc.GetGroupCount();

	// NA
	m_cmbGroup.ResetContent();
	for (size_t i = 0; i < size; ++i) {
		// O[vǉ
		m_cmbGroup.AddString(m_doc.GetGroupName(i));
	}

	// ݂̃O[vI
	m_cmbGroup.SetCurSel(static_cast<int>(m_doc.GetCurrentGroupIndex()));
}

void CListPasteDlg::DoCopy()
{
	m_doc.Copy();
}

void CListPasteDlg::DoPaste()
{
	if (m_doc.Paste()) {
		// eXV
		// HACK: {͓\tACeIAʂɂǂꂪ\邩Ȃ
		UpdateSearch();
	}
}

void CListPasteDlg::DoDelete()
{
	m_doc.Delete();

	// eXV
	UpdateSearch();
}

void CListPasteDlg::DoUndo()
{
	if (m_doc.Undo()) {
		// HACK: Undo ŃO[vς邩Ȃ̂ŁAO[vR{{bNXXV
		UpdateGroupCombo();
		// eXV
		UpdateSearch();
	}
}

void CListPasteDlg::SelectAllItems()
{
	GenericUtility::ListCtrl_SelectAllItems(m_listTexts);
}

void CListPasteDlg::UnselectAllItems()
{
	GenericUtility::ListCtrl_UnselectAllItems(m_listTexts);
}

void CListPasteDlg::UpdateSearch()
{
#ifdef LISTPASTEDLG_DELAYEDEXECUTION
	// ^C}[ݒ肷
	SetDelayedExecution(SEARCH_JOB_ID, DELAYED_EXECUTION_TIMER_INTERVAL);
#else	// #ifdef LISTPASTEDLG_DELAYEDEXECUTION
	// HACK: 񓯊̂ŁAɎs
	UpdateSearchFunc();
#endif	// #ifdef LISTPASTEDLG_DELAYEDEXECUTION
}

void CListPasteDlg::UpdateSearchFunc()
{
	if (UpdateData()) {
		// 񓯊
		// HACK: m_doc  this ̕AXbh m_doc IƂɏÎŁAthis n OK
		bool complete = m_doc.SearchAsync(boost::bind(&CListPasteDlg::OnCompleteAsyncNotifyFunc, this, _1));

		// HACK: Ă邩ǂɂ炸AXgĕ`悷
		RedrawTextList(true, true);

		// 񓯊ĂȂ΁A|[O^C}[ݒ肷
		if (!complete) {
			// WaitCursor ݒ肷
			GenericUtility::CWaitCursorEx::Begin();

			// |[O^C}[ݒ肷
			SetTimer(TIMER_ID_ASYNC_SEARCH, ASYNC_SEARCH_TIMER_INTERVAL, NULL);
		}
	}
}

void CListPasteDlg::OnCompleteAsyncNotifyFunc(bool cancelled)
{
	// HACK: WM_COMPLETE_ASYNC_SEARCH Ȃ Post 
	MSG msg;
	if (!PeekMessage(&msg, GetSafeHwnd(), WM_COMPLETE_ASYNC_SEARCH, WM_COMPLETE_ASYNC_SEARCH, PM_NOREMOVE)) {
		VERIFY(PostMessage(WM_COMPLETE_ASYNC_SEARCH, 0, cancelled));
	}
}

void CListPasteDlg::CompleteAsyncSearch(bool cancelled)
{
	// HACK: ƂLZꂽƂ͓

	// HACK: 񓯊łȂ΁A|[O^C}[~߂
	// HACK: ɍČƂA^C}[ݒ肵AƂ̌̃LZʒmɂ肱ɂ
	// HACK: ̏ꍇ̓^C}[~߂Ȃ
	if (!m_doc.IsSearching()) {
		KillTimer(TIMER_ID_ASYNC_SEARCH);
	}

	// Xgĕ`悷 (IԂ͂̂܂ / ǉ邾Ȃ̂ŁAĕ`͂Ȃ)
	RedrawTextList(false, false);

	// WaitCursor 
	// HACK: LZꂽƂR[obN̂ŁAK Begin() Ƒ΂ɂȂ
	// HACK: (̔񓯊sĂĂAEnd() ĂяoĂ悢)
	GenericUtility::CWaitCursorEx::End();
}

void CListPasteDlg::RedrawTextList(bool unselectAll, bool forceInvalidate)
{
	// ĕ`悷
	{
		GenericUtility::CSuspendRedraw sr(&m_listTexts);

		if (unselectAll) {
			// HACK: Iƍĕ`𓯎ɍŝŁAőI
			UnselectAllItems();
		}

		// ڐ
		m_listTexts.SetItemCountEx(static_cast<int>(m_doc.GetSearchedCount()));

		if (forceInvalidate) {
			m_listTexts.Invalidate();
		}
	}

	// J𒲐߂
	// HACK: XN[o[̗Lŕς\邽߁AeLXgύXɂsKv
	// HACK: XN[o[\ꂽŎsKv
	AdjustColumnWidth(m_listTexts);
}

void CListPasteDlg::SetupTopMost()
{
	const CWnd& wnd = CSystemSettings::Instance().TopMost() ? wndTopMost : wndNoTopMost;
	// Z order ݒ肷
	SetWindowPos(&wnd, 0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
	// HACK: TopMost ̏ꍇAc[`bvɍőOʂɈړKv
	m_listTexts.GetToolTips()->SetWindowPos(&wnd, 0, 0, 0, 0, SWP_NOACTIVATE | SWP_NOMOVE | SWP_NOSIZE);
}

void CListPasteDlg::SetupWatchClipboard()
{
	// Nbv{[hr[Aݒ肷
	if (CSystemSettings::Instance().WatchClipboardMode() != CSystemSettings::WCM_None) {
		if (!m_clipboardChain) {
			m_clipboardChain.reset(new GenericUtility::CClipboardChain(this));
		}
	}
	else {
		m_clipboardChain.reset();
	}
}

////////////////////////////////////////////////////////////////////////////////

namespace {

	/**
	 * tO off  on ɂȂǂ𒲂ׂ.
	 * @param[in] org  ȑÕtO
	 * @param[in] now  ݂̃tO
	 * @param[in] mask ׂtO
	 */
	bool IsFlagEnabled(unsigned long org, unsigned long now, unsigned long mask)
	{
		return !(org & mask) && (now & mask);
	}

}	// anonymous namespace

void CListPasteDlg::InitTransparent()
{
	// HACK:  off ŏ
	// HACK: SetTransparent() Ŏۂ off ɂȂ悤ɁA܂tO on ̒lŏĂ
	m_transparentMode = TM_All;
	SetTransparent(TM_None);

	// ݂̏Ԃɏ]āA\XV
	UpdateTransparent();
}

void CListPasteDlg::SetTransparent(unsigned long /* ETransparentMode */ mode)
{
	// łɎw肳ꂽԂɂ
	if (m_transparentMode == mode) {
		return;
	}

	// \𔼓ɂ
	if (IsFlagEnabled(m_transparentMode, mode, TM_Display)) {
		// HACK: C[EBhEݒ肷
		ModifyStyleEx(0, WS_EX_LAYERED);
		// HACK: C[EBhẼlݒ肷
		SetLayeredWindowAttributes(0, CSystemSettings::Instance().TransparentAlpha(), LWA_ALPHA);
	}
	else {
		// HACK: C[EBhE̐ݒO
		// HACK: sɂƂ́Al 255 ɂ̂ł͂ȂAC[EBhE̐ݒOȂ΂ȂȂ
		// HACK: ȂƁAWindows XP ŃTCYύXɂЂǂȂ (Windows 7 ł OK)
		ModifyStyleEx(WS_EX_LAYERED, 0);
	}

	// bZ[W𓧉߂
	if (IsFlagEnabled(m_transparentMode, mode, TM_Message)) {
		ModifyStyleEx(0, WS_EX_TRANSPARENT);
	}
	// bZ[W𓧉߂Ȃ
	else {
		ModifyStyleEx(WS_EX_TRANSPARENT, 0);
	}

	// k\ɂ
	if (IsFlagEnabled(m_transparentMode, mode, TM_Shrink)) {
		// ݂̃EBhEʒuoĂ
		m_NormalDisplayPos.Save(this);

		switch (m_NormalDisplayPos.GetShowCmd()) {
			// HACK: ő剻AŏĂƂ͉Ȃ
			// HACK: (ő剻ĂƂAő剻܂܃EBhETCYύXƁARestore() Ōɖ߂Ȃ.
			// HACK:  ĂȂƂ͂ȂAʓ|Ȃ̂őΏۊOƂ)
			case SW_SHOWMAXIMIZED:
			case SW_SHOWMINIMIZED:
				m_NormalDisplayPos.Reset();
				break;
			default:
			{
				// ݂̎ۂ̃EBhEʒu
				CRect rect;
				GetWindowRect(rect);
				// HACK: ő剻AŏĂ炸Aۂ̃EBhETCYʏ\ƈقȂƂ́A
				// HACK: Windows Aero ɂXibvłƐ
				// HACK: ̏ꍇ́Aő剻ĂƂƓlɁAȂ
				// HACK: GetWindowPlacement()  GetWindowRect() Ŏ擾łʒu̓^XNo[̕قȂ̂ŁATCYrĂ
				// TODO: Windows Aero ɂXibvǂ̔𐳊mɍs
				if (rect.Size() != m_NormalDisplayPos.GetRect().Size()) {
					m_NormalDisplayPos.Reset();
					break;
				}

				// HACK:  0 ɂ (ۂɂ 0 ɂ͂Ȃ炸AKȍŏlɂȂ)
				VERIFY(SetWindowPos(NULL, 0, 0, rect.Width(), 0, SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE | SWP_NOOWNERZORDER));
				break;
			}
		}
	}
	else {
		// HACK: EBhEʒuۑĂ
		if (m_NormalDisplayPos.IsValid()) {
			// HACK: EBhEʒuɖ߂
			m_NormalDisplayPos.Restore(this);
			// HACK: pς݂Ȃ̂ŃNA
			m_NormalDisplayPos.Reset();
		}
	}

	m_transparentMode = mode;
}

void CListPasteDlg::UpdateTransparent()
{
	// ANeBułȂƂɔ\ɂ邩ǂ
	bool bTransparent = CSystemSettings::Instance().TransparentOnInactive();
	// ANeBułȂƂɏk\(^Cgo[݂̂̊ȈՕ\)ɂ邩ǂ
	bool bShrink = CSystemSettings::Instance().ShrinkOnInactive();
	if (bTransparent || bShrink) {
		// J[\ʒu
		CPoint pos;
		::GetCursorPos(&pos);

		// _CAOʒu
		CRect rect;
		GetWindowRect(rect);

		// ANeBuԂǂ
		// (}EXJ[\EBhEɂ邩A邢̓EBhEL[{[htH[JXĂ)
		bool active = rect.PtInRect(pos) || CWnd::GetActiveWindow()->GetSafeHwnd() == GetSafeHwnd();

		// ANeBu
		if (active) {
			// \(+ k\)
			SetTransparent(TM_None);

			// HACK: OnKickIdle() ł́A}EX̓ɂĂ̓_CAOォOꂽƂ !active ł邱Ƃ܂ołȂꍇ
			// HACK: TrackMouseEvent() gpł΂AqRg[钆ł܂ĝ͓
			// HACK: dȂ̂ŁAANeBułԂ̓^C}[ZbgĊĎ邱Ƃɂ
			// HACK: (VrAȏł͂Ȃ̂ŁA^C}[Ԋu͒߂ɎĂ悢)

			// HACK: \XV^C}[ݒ肷
			StartUpdateTransparent();
		}
		else {
			// ANeBułȂ΁A\(+ k\)ɂ
			// HACK: WM_KICKIDLE 󂯎邽߂ɁAbZ[W͔񓧉߂ɂĂ
			SetTransparent((bTransparent ? TM_Display : 0) | (bShrink ? TM_Shrink : 0));

			// HACK: !active ł邱ƂołƂ́AĎWu͂svȂ̂Ń^C}[
			StopUpdateTransparent();
		}
	}
	else {
		// ʏ\ɂ
		SetTransparent(TM_None);
	}
}

void CListPasteDlg::StartUpdateTransparent()
{
	// HACK: 񂫂̏ł͂ȂpĊĎKvł邽߁ADelayedExecution @\͎gpɁAʂɃ^C}[

	// ^C}[ݒ肷
	SetTimer(TIMER_ID_UPDATE_TRANSPARENT, UPDATE_TRANSPARANT_TIMER_INTERVAL, NULL);
}

void CListPasteDlg::StopUpdateTransparent()
{
	// ^C}[
	KillTimer(TIMER_ID_UPDATE_TRANSPARENT);
}

////////////////////////////////////////////////////////////////////////////////

void CListPasteDlg::OnBeginDragListTexts(NMHDR *pNMHDR, LRESULT *pResult, bool bLeftButton)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	*pResult = 0;

	// See CListPasteDoc::Copy()

	// IĂeLXg
	// HACK: t@ChbOhbvƂ̑Ώۃt@C
	std::vector<CString> texts = m_doc.GetSelectedTextVec();
	if (texts.empty()) {
		return;
	}
	// Ώە (s؂ŘA)
	// HACK: eLXghbOhbvƂ̑ΏۃeLXg
	// HACK: (t@ChbOhbvƂ͖ʂɂȂ邪AƂ肠CɂȂ)
	CString strText = GenericUtility::ConcatenateStrings(texts, _T("\r\n"));
	if (strText.IsEmpty()) {
		return;
	}

	// hbOɔ\(+bZ[W)ɂ
	if (CSystemSettings::Instance().TransparentOnDrag()) {
		// HACK: eLXghbÓA\āAbZ[W߂
		// HACK: (_CAỎɂEBhEɃhbvł悤ɂ邽)
		SetTransparent(TM_Display | TM_Message);
	}
	else {
		// HACK: \XV
		// HACK: (ANeBuȂ̂ŁAsɂȂ͂BhbO͂ƃANeBuȂ̂ŁA^C}[Ă悢)
		UpdateTransparent();
	}

	// Shift Ă
	bool bShiftKey = GenericUtility::IsKeyPressed(VK_SHIFT);
	// hbOCL[Ȃ || EhbOVtgL[
	// hbOhbv
	if ((bLeftButton && !bShiftKey) || (!bLeftButton && bShiftKey)) {
		/**
		 * hbOf[^ǉ֐.
		 * @see CDragDrop::AddDragDataFunc.
		 */
		class CAddDragDataFunc
		{
		public:
			/**
			 * hbOf[^ƂăeLXg (or t@C) ǉ.
			 * @param[in] texts    eLXg (ׂẴt@C)
			 * @param[in] lpszText sŘAeLXg
			 */
			static bool AddData(
				GenericUtility::CDragDrop::IAddDragData* addDragData,
				const std::vector<CString>& texts,
				LPCTSTR lpszText)
			{
				if (!addDragData) {
					return false;
				}

				// HACK: eLXgƃt@C𗼕ǉ邱Ƃł
				// HACK: ÂƂ͑ΏۃvOɂė\ʓ邱Ƃ
				// HACK: (eLXgGfB^ɃhbvƂAt@C̃hbv󂯕t̂
				// HACK:  t@CI[v邱Ƃ邪AeLXghbvƂ)
				// HACK: ̂߁AhbOhbvł̓eLXgƃt@Ĉǂ炩݂̂ΏۂƂ邱Ƃɂ
				// HACK: (ALT Ă΁At@CΏۂƂ)

				// HACK: ALT Ă
				if (GenericUtility::IsKeyPressed(VK_MENU)) {
					// HACK: ȃt@CpX܂܂Ƃ͎s
					// HACK: (ȏꍇ̓eLXgΏۂƂl邪AI ALT Ă̂Ŏsقł)
					if (!GenericUtility::AreValidFilePaths(texts)) {
						return false;
					}

					// t@Cǉ
					if (!addDragData->AddFiles(texts)) {
						return false;
					}
				}
				else {
					// eLXgǉ
					if (!addDragData->AddText(lpszText)) {
						return false;
					}
				}

				return true;
			}
		};

		// Ώە (or t@C) hbOhbv
		GenericUtility::CDragDrop::DragData(boost::bind(&CAddDragDataFunc::AddData, _1, boost::ref(texts), strText));

		// HACK: hbOhbvÎŁA\XVČɖ߂ (璷Ăяoł܂Ȃ)
		UpdateTransparent();
	}
	// WM_CHAR ŕ𑗂
	else {
		// hbOeLXg
		m_strDragText = strText;
		// }EXLv`[Jn
		SetCapture();
		m_nCaptureStatus = ECS_Capturing | (bLeftButton ? ECS_LeftButton : 0);
		// J[\ݒ肷
		m_hDragCursor = ::SetCursor(::LoadCursor(NULL, MAKEINTRESOURCE(IDC_IBEAM)));

		// HACK: ܂hbO (EndCapture() Ŕ\ɖ߂)
	}
}

CWnd* CListPasteDlg::GetWindowFromPoint(CPoint pntCient)
{
	// XN[Wł̃}EXJ[\ʒu
	CPoint pntScreen = pntCient;
	ClientToScreen(&pntScreen);

	// }EXJ[\ʒuɂEBhE
	return CWnd::WindowFromPoint(pntScreen);
}

void CListPasteDlg::SendText(CPoint point)
{
	if (m_nCaptureStatus & ECS_Capturing) {
		// }EXJ[\ʒuɂEBhE
		CWnd* pWnd = GetWindowFromPoint(point);
		if (pWnd) {
#if 0
			// EBhEeLXgݒ肷
			pWnd->SetWindowText(m_strDragText);
#else
			// tH[JXݒ肷
			CWnd* pWndFocus = pWnd->SetFocus();

			CT2W t2wDragText(m_strDragText);
			LPCWSTR pText = (LPCWSTR)t2wDragText;
			int size = m_strDragText.GetLength();
			// L[Xg[N𑗐M
			for (int i = 0; i < size; ++i) {
				pWnd->SendMessage(WM_CHAR, pText[i] /* UTF-16 */, 1);
			}

			// tH[JXɖ߂
			if (pWndFocus) {
				pWndFocus->SetFocus();
			}
#endif
		}
	}
}

void CListPasteDlg::EndCapture()
{
	if (m_nCaptureStatus & ECS_Capturing) {
		// }EXLv`[I
		ReleaseCapture();
		m_nCaptureStatus = ECS_None;
		// EBhEnCCg
		m_HighlightWindow.HighlightWindow(NULL);
		// hbÕeLXgNA
		m_strDragText.Empty();
		// J[\𕜌
		if (m_hDragCursor) {
			::SetCursor(m_hDragCursor);
			m_hDragCursor = NULL;
		}

		// HACK: \XVČɖ߂ (璷Ăяoł܂Ȃ)
		UpdateTransparent();
	}
}

////////////////////////////////////////////////////////////////////////////////

namespace {

	/**
	 * CListPasteDlg ̐ݒۑpt@C擾.
	 */
	std::wstring GetListPasteDlgFilename()
	{
		return GenericUtility::GetStorageFilename(L"ListPaste.xml");
	}

	// HACK: N͋֎~At@C̓ǂݏی삵Ă
	/**
	 * Z[uA[h̔rp~[ebNX擾.
	 */
	CString GetMutexName()
	{
		CString name = CString(_T("Mutex:")) + GenericUtility::GetModuleDir().c_str();

		// HACK: '\'  '/' ɕϊ
		name.Replace(_T('\\'), _T('/'));

		return name;
	}
	/// Z[uA[h̔rp~[ebNX
	CMutex g_mtxSaveLoad(FALSE, GetMutexName());

}	// anonymous namespace

bool CListPasteDlg::Save(bool forceDocument)
{
	CSingleLock lock(&g_mtxSaveLoad, TRUE);

	bool ret = true;

	// _CAO
	{
		// _CAOʒu擾
		// HACK: k\ŁAk\ÖʒuۑĂꍇ́Äʒugp
		if ((m_transparentMode & TM_Shrink) && m_NormalDisplayPos.IsValid()) {
			m_DialogPosition = m_NormalDisplayPos;
		}
		else {
			// _CAOʒu擾
			m_DialogPosition.Save(this);
		}
		// Xg̃tHg擾
		m_ListFont.Save(&m_listTexts);
		// HACK: JgO[v擾
		// HACK: See CListPasteDoc::SetCurrentGroup()
		CSystemSettings::Instance().SetCurrentGroup(m_doc.GetCurrentGroupIndex());

		// ۑ
		if (!GenericUtility::SaveObject(GetListPasteDlgFilename().c_str(), *this)) {
			ret = false;
		}
	}

	// HACK: hLg Data Manager
	// ۑ
	if (!m_doc.Save(forceDocument)) {
		ret = false;
	}

	return ret;
}

bool CListPasteDlg::Load()
{
	CSingleLock lock(&g_mtxSaveLoad, TRUE);

	bool ret = true;

	std::wstring filename = GetListPasteDlgFilename();
	// HACK: t@CȂ () ́AƂ݂Ȃ
	if (::PathFileExistsW(filename.c_str())) {
		// _CAO
		if (GenericUtility::LoadObject(filename.c_str(), *this)) {
			// _CAOʒu𕜌
			m_DialogPosition.Restore(this);
			// Xg̃tHg𕜌
			m_ListFont.Restore(&m_listTexts);
		}
		else {
			ret = false;
		}
	}
	// HACK: [hɎsĂAftHgl𔽉f邽߂Ɉȉs
	{
		// _CAOɔf
		UpdateData(FALSE);
		// TopMost ݒ肷
		SetupTopMost();
		// Nbv{[hr[Aݒ肷
		SetupWatchClipboard();
		// \XV
		UpdateTransparent();
	}

	// HACK: hLg Data Manager
	if (!m_doc.Load()) {
		ret = false;
	}
	// HACK: ǂݍݓrŎsꍇAr[Ƀ[hꍇ
	// HACK: dȂ̂łł\
	{
		// HACK: JgO[vݒ肷
		// HACK: See CListPasteDoc::SetCurrentGroup()
		m_doc.SetCurrentGroup(CSystemSettings::Instance().CurrentGroup());

		// O[vR{{bNXXV
		UpdateGroupCombo();

		// eXV
		UpdateSearch();
	}

	return ret;
}
