/**
 * @file  DataManager.h
 * @brief ListPaste f[^}l[WNX`.
 *
 * @author JIN
 *
 * Copyright (C) 2011- JIN All rights reserved.
 */
#pragma once

#include "../GenericLib/ProgressManager.h"

/// Search() ŃvOXLɂ
//#define DATAMANAGER_ENABLE_SEARCH_PROGRESS

namespace ListPasteLib {

	// HACK: f[^ׂ͂ă|C^ł͂Ȃ̂ŎĂ
	// HACK: ̂߁AAdd()  Delete() ̃ptH[}Xɖ肪o\

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * ύXtO.
	 */
	class CDirtyFlag
	{
	public:
		CDirtyFlag()
			// HACK: VK쐬ꂽƂ́AύXtO𗧂ĂĂ
			// HACK: t@Cǂݍō쐬ꂽꍇ́ÂƂɖI off ɂ
			: m_dirty(true)
		{
		}

		/**
		 * ύXĂ邩ǂ擾.
		 */
		bool IsDirty() const
		{
			return m_dirty;
		}
		// HACK:  Save()  SetDirty(false) 邽߂ɁAconst ɂĂ
		/**
		 * ύXtOݒ肷.
		 */
		void SetDirty(bool dirty) const
		{
			m_dirty = dirty;
		}

	private:
		/// ύXtO
		mutable bool m_dirty;
	};

	////////////////////////////////////////////////////////////////////////////////

	// HACK: 蔲 CDirtyFlag  private p ({̓oƂĎׂ)
	/**
	 * f[^O[v.
	 */
	class CDataGroup : private CDirtyFlag
	{
	public:
		CDataGroup();
		CDataGroup(const std::wstring& name);
		~CDataGroup();

		/**
		 * Ǝւ.
		 */
		void Swap(CDataGroup& group);

		/**
		 * O[vݒ肷.
		 */
		void SetName(const std::wstring& name);
		/**
		 * O[v擾.
		 */
		const std::wstring& GetName() const;

		/**
		 * ǉ.
		 * @param[in] index ǉʒu (>= eLXg: ɒǉ)
		 */
		bool Add(size_t index, const std::wstring& text);
		/**
		 * ǉ.
		 * rɕǉꍇ́Axɒǉ.
		 * @param[in] index ǉʒu (>= eLXg: ɒǉ)
		 */
		bool Add(size_t index, const std::vector<std::wstring>& texts);
		/**
		 * ύX.
		 */
		bool Modify(size_t index, const std::wstring& text);
		/**
		 * 폜.
		 */
		bool Delete(size_t index);

		typedef std::deque<std::wstring> WStrings;
		/**
		 * ׂẴeLXg擾.
		 */
		const WStrings& GetTexts() const;

		typedef std::vector<size_t> IndexVec;
		/**
		 * .
		 * @param[in]  search     
		 * @param[in]  matchFirst ̐擪Ƀ}b`邩ǂ
		 * @param[in]  pProgress  vOX (SetProgressRange() ς݂̂)
		 * @param[out] indices    }b`eLXg̃CfbNX
		 */
		void Search(
			const std::wstring& search,
			bool matchFirst,
			IndexVec& indices
#ifdef DATAMANAGER_ENABLE_SEARCH_PROGRESS
			, GenericUtility::CProgressManager* pProgress = NULL
#endif	// #ifdef DATAMANAGER_ENABLE_SEARCH_PROGRESS
			)
			const;

		/**
		 * w肵CfbNX͈͓.
		 * @param[in] begin     JnCfbNX
		 * @param[in] end       ICfbNX (܂܂Ȃ)
		 * @param[in] search    
		 * @param[in] matchFirst ̐擪Ƀ}b`邩ǂ
		 * @param[in] pProgress vOX (StartProgress() ς݂̂)
		 * @param[out] indices    }b`eLXg̃CfbNX
		 */
		void Search(
			size_t begin, size_t end,
			const std::wstring& search,
			bool matchFirst,
			IndexVec& indices
#ifdef DATAMANAGER_ENABLE_SEARCH_PROGRESS
			, GenericUtility::CProgressManager* pProgress = NULL
#endif	// #ifdef DATAMANAGER_ENABLE_SEARCH_PROGRESS
			)
			const;

		/**
		 * ύXĂ邩ǂ擾.
		 */
		bool IsDirty() const;
		/**
		 * ύXtOݒ肷.
		 */
		void SetDirty(bool dirty) const;

	private:
		/// O[v
		std::wstring m_name;
		/// eLXg
		WStrings m_texts;

	private:
		friend class boost::serialization::access;
		template<class Archive>
		void serialize(Archive& ar, const unsigned int version)
		{
			using boost::serialization::make_nvp;

			ar & make_nvp("Name", m_name);
			ar & make_nvp("Texts", m_texts);
		}
	};

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * f[^}l[W.
	 * @note ۑAǂݍ݂ Save/Load łȂ (boost::serialization ɒړnĂ͂ȂȂ; dirty flag ̂)
	 */
	class CDataManager : private CDirtyFlag
	{
	public:
		CDataManager();
		~CDataManager();

		/**
		 * O[vȂ΁AftHgO[vǉ.
		 */
		void SetupDefaultGroup();

	public:
		/**
		 * VACYăt@Cɕۑ.
		 * ύXtOɂ炸AۑȂ.
		 * ۑɐAύXtONA.
		 */
		bool Save(const std::wstring& filename) const;
		/**
		 * t@CǂݍŃfVACY.
		 * ǂݍ񂾌ɕύXtONA邪AftHgꂽ痧Ă.
		 */
		bool Load(const std::wstring& filename);

	public:
		/**
		 * f[^O[v𖖔ɒǉ.
		 */
		bool Add(const std::wstring& name);
		/**
		 * f[^O[v폜.
		 */
		bool Delete(size_t index);
		/**
		 * index Ԗڂ̃f[^O[vړ.
		 * [邢͉[𒴂ꍇ́A[邢͉[ɂȂ.
		 * @param[in] nMove ړ (+: , -: )
		 * @return łړǂ.
		 */
		bool Move(size_t index, INT_PTR nMove);
		/**
		 * f[^O[v𖼑OŌ.
		 * @return ŏ̃CfbNX (~0 : Ȃ)
		 */
		size_t Find(const std::wstring& name) const;

		/**
		 * f[^O[v擾.
		 */
		size_t GetGroupCount() const;

		/**
		 * i Ԗڂ̃f[^O[v擾.
		 */
		CDataGroup& GetGroup(size_t index);
		/**
		 * i Ԗڂ̃f[^O[v擾.
		 */
		const CDataGroup& GetGroup(size_t index) const;

		/**
		 * ݂̃f[^O[v擾.
		 */
		size_t GetCurrentGroupIndex() const;
		/**
		 * ݂̃f[^O[vݒ肷.
		 * @param[in] setDirtyFlag ύXtO𗧂Ă
		 */
		bool SetCurrentGroup(size_t index, bool setDirtyFlag);

		/**
		 * ݂̃f[^O[v擾.
		 */
		CDataGroup& GetCurrentGroup();
		/**
		 * ݂̃f[^O[v擾.
		 */
		const CDataGroup& GetCurrentGroup() const;

		typedef std::vector<CDataGroup> CDataGroupVec;
		/**
		 * ׂẴf[^O[v擾.
		 */
		const CDataGroupVec& GetGroups() const;

		/**
		 * ύXĂ邩ǂ擾.
		 */
		bool IsDirty() const;
		/**
		 * ύXtOݒ肷.
		 */
		void SetDirty(bool dirty) const;

		/**
		 * ftHgO[vݒ肷.
		 */
		static void SetDefaultGroupName(const std::wstring& name);

	private:
		/// JgO[ṽCfbNX
		size_t m_currentGroup;
		/// f[^O[v
		CDataGroupVec m_groups;

		/// ftHgO[v
		static std::wstring s_defaultGroupName;

	private:
		friend class boost::serialization::access;
		template<class Archive>
		void serialize(Archive& ar, const unsigned int version)
		{
			using boost::serialization::make_nvp;

			ar & make_nvp("CurrentGroup", m_currentGroup);
			ar & make_nvp("Groups", m_groups);
		}
	};

	typedef boost::shared_ptr<CDataManager> CDataManagerPtr;

}	// namespace ListPasteLib
