#include "StdAfx.h"
#include "SystemSettings.h"

CSystemSettings::CSystemSettings()
	: m_nCurrentGroup(0)
	, m_bMatchFirst(TRUE)
	, m_bTopMost(true)
	, m_bControlIme(true)
	, m_bShrinkOnInactive(false)
	, m_bTransparentOnInactive(false)
	, m_bTransparentOnDrag(false)
	, m_nTransparentAlpha(64)
	, m_nWatchClipboardMode(WCM_None)
	, m_nClipboardRecordSize(1000)
	, m_bSkipEmptyLines(true)
	, m_bTrimSpaces(true)
	, m_nAsyncSearchThreshold(512)
	, m_nAsyncSearchBlockSize(512)
	, m_nCopyFileThreshold(8192)
	, m_serializeMode(ESM_Binary)
{
}

CSystemSettings::~CSystemSettings()
{
}

CSystemSettings& CSystemSettings::Instance()
{
	static CSystemSettings settings;
	return settings;
}

////////////////////////////////////////////////////////////////////////////////

size_t CSystemSettings::CurrentGroup() const
{
	return m_nCurrentGroup;
}
void CSystemSettings::SetCurrentGroup(size_t val)
{
	m_nCurrentGroup = val;
}

const std::wstring& CSystemSettings::SearchString() const
{
	return m_strSearchString;
}
void CSystemSettings::SetSearchString(const std::wstring& val)
{
	m_strSearchString = val;
}

bool CSystemSettings::MatchFirst() const
{
	return m_bMatchFirst;
}
void CSystemSettings::SetMatchFirst(bool val)
{
	m_bMatchFirst = val;
}

////////////////////////////////////////////////////////////////////////////////

bool CSystemSettings::TopMost() const
{
	return m_bTopMost;
}
void CSystemSettings::SetTopMost(bool val)
{
	m_bTopMost = val;
}

bool CSystemSettings::ControlIme() const
{
	return m_bControlIme;
}
void CSystemSettings::SetControlIme(bool val)
{
	m_bControlIme = val;
}

////////////////////////////////////////////////////////////////////////////////

bool CSystemSettings::ShrinkOnInactive() const
{
	return m_bShrinkOnInactive;
}

void CSystemSettings::SetShrinkOnInactive(bool val)
{
	m_bShrinkOnInactive = val;
}

bool CSystemSettings::TransparentOnInactive() const
{
	return m_bTransparentOnInactive;
}

void CSystemSettings::SetTransparentOnInactive(bool val)
{
	m_bTransparentOnInactive = val;
}

bool CSystemSettings::TransparentOnDrag() const
{
	return m_bTransparentOnDrag;
}

void CSystemSettings::SetTransparentOnDrag(bool val)
{
	m_bTransparentOnDrag = val;
}

BYTE CSystemSettings::TransparentAlpha() const
{
	return m_nTransparentAlpha;
}

void CSystemSettings::SetTransparentAlpha(BYTE val)
{
	m_nTransparentAlpha = val;
}

////////////////////////////////////////////////////////////////////////////////

CSystemSettings::EWatchClipboardMode CSystemSettings::WatchClipboardMode() const
{
	return m_nWatchClipboardMode;
}
void CSystemSettings::SetWatchClipboardMode(EWatchClipboardMode val)
{
	m_nWatchClipboardMode = val;
}

size_t CSystemSettings::ClipboardRecordSize() const
{
	return m_nClipboardRecordSize;
}
void CSystemSettings::SetClipboardRecordSize(size_t val)
{
	m_nClipboardRecordSize = val;
}

////////////////////////////////////////////////////////////////////////////////

bool CSystemSettings::SkipEmptyLines() const
{
	return m_bSkipEmptyLines;
}
void CSystemSettings::SetSkipEmptyLines(bool val)
{
	m_bSkipEmptyLines = val;
}

bool CSystemSettings::TrimSpaces() const
{
	return m_bTrimSpaces;
}
void CSystemSettings::SetTrimSpaces(bool val)
{
	m_bTrimSpaces = val;
}

////////////////////////////////////////////////////////////////////////////////

size_t CSystemSettings::AsyncSearchThreshold() const
{
	return m_nAsyncSearchThreshold;
}

size_t CSystemSettings::AsyncSearchBlockSize() const
{
	return m_nAsyncSearchBlockSize;
}

size_t CSystemSettings::CopyFileThreshold() const
{
	return m_nCopyFileThreshold;
}

CSystemSettings::ESerializeMode CSystemSettings::SerializeMode() const
{
	return m_serializeMode;
}
