/**
 * @file  DlgWithToolTip.h
 * @brief c[`bv\_CAO̊{NX.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#ifndef DLGWITHTOOLTIP_H_
#define DLGWITHTOOLTIP_H_

#include "MessageMap.h"

namespace Dialog {

// HACK: OnToolTipNotify() ŁA\[X ID 𒼐ڐݒ肹Ɉx LoadString() ̂ݒ肷B
// HACK: (\[X ID 𒼐ڐݒ肷ƁȀꍇɓrœr؂邽)
#define DLGWITHTOOLTIP_LOADRESOURCE

/////////////////////////////////////////////////////////////////////////////
/**
 * c[`bv\_CAO̊{NX.
 */
template <class BaseClass_>
class CDlgWithToolTip : public BaseClass_
{
public:
	CDlgWithToolTip()
	{
	}
	CDlgWithToolTip(int nID) : BaseClass_(nID)
	{
	}
	CDlgWithToolTip(int nID, CWnd* pWnd) : BaseClass_(nID, pWnd)
	{
	}

	/// IvV擾֐ (c[wvLǂ).
	typedef boost::function<bool()> IsToolHelpEnabledFunc;

	virtual BOOL OnInitDialog()
	{
		BOOL bRet = BaseClass_::OnInitDialog();
		EnableToolTips();
		return bRet;
	}
	virtual BOOL PreTranslateMessage(MSG* pMsg)
	{
		// HACK: ToolTip ̍쐬 CWnd::FilterToolTipMessage() ōsA
		// HACK:  PreTranslateMessage() ĂяôŁA
		// HACK:  ToolTip ̐ݒ菈sƂɂB
		// HACK: see CWnd::FilterToolTipMessage() in MFC/src/tooltip.cpp

		// BaseClass_::PreTranslateMessage() Õc[`bv
		// WARNING: BaseClass_::PreTranslateMessage() sOɃEBhEnh擾ĂȂ΂ȂȂ
		HWND hWndPrev = AfxGetModuleThreadState()->m_pToolTip->GetSafeHwnd();

		BOOL bRet = BaseClass_::PreTranslateMessage(pMsg);

		// BaseClass_::PreTranslateMessage() ̃c[`bv
		CToolTipCtrl* pToolTip = AfxGetModuleThreadState()->m_pToolTip;
		HWND hWnd = pToolTip->GetSafeHwnd();
		// BaseClass_::PreTranslateMessage() ̎sOŃc[`bvύXĂ
		// (BaseClass_::PreTranslateMessage() Ńc[`bv()쐬ꂽ)
		// WARNING: pToolTip  delete & new Ă邪AAhX蓖Ă\邽
		// WARNING: EBhEnhŔrȂ΂ȂȂ
		if (hWndPrev != hWnd && ::IsWindow(hWnd)) {
#if 0
			// o[c[`bv
			pToolTip->ModifyStyle(0, TTS_BALLOON);
			// xԂ 0 ɂ
			pToolTip->SetDelayTime(TTDT_INITIAL, 0);
			pToolTip->SetDelayTime(TTDT_RESHOW, 0);
			// Ԃőɂ
			pToolTip->SetDelayTime(TTDT_AUTOPOP, SHRT_MAX);
#endif
			// ő啝ݒ肷
			pToolTip->SetMaxTipWidth(1000);
		}

		return bRet;
	}
	afx_msg BOOL OnToolTipNotify(UINT id, NMHDR* pNMHDR, LRESULT* pResult)
	{
		LPNMTTDISPINFO pNMTTDI = (LPNMTTDISPINFO)pNMHDR;
		// }EXJ[\A(c[{^ł͂Ȃ)_CAÕRg[̏ɂ
		if (pNMTTDI->uFlags & TTF_IDISHWND) {
			UINT nID = ::GetDlgCtrlID((HWND)pNMHDR->idFrom);
			if(nID && nID != IDOK && nID != IDCANCEL
				// HACK: TCYσ_CAÕXe[^Xo[ŁAID_VIEW_STATUS_BAR ̃c[`bv\H
				// HACK: DS_MODALFRAME H
				&& nID != ID_VIEW_STATUS_BAR)
			{
#ifdef DLGWITHTOOLTIP_LOADRESOURCE
				m_strToolTip.Empty();
				if (m_strToolTip.LoadString(nID)) {
					pNMTTDI->lpszText = const_cast<LPTSTR>(m_strToolTip.GetString());
				}
				else {
					pNMTTDI->lpszText = NULL;
				}
				pNMTTDI->hinst = NULL;
#else	// #ifdef DLGWITHTOOLTIP_LOADRESOURCE
				pNMTTDI->lpszText = MAKEINTRESOURCE(nID);
				pNMTTDI->hinst = AfxGetResourceHandle();
#endif	// #ifdef DLGWITHTOOLTIP_LOADRESOURCE
			}
		}
		return TRUE;
	}

	BEGIN_MESSAGE_MAP_INLINE(CDlgWithToolTip, BaseClass_)
		ON_NOTIFY_EX(TTN_NEEDTEXT, 0, &OnToolTipNotify)
	END_MESSAGE_MAP()

#ifdef DLGWITHTOOLTIP_LOADRESOURCE
protected:
	CString m_strToolTip;
#endif	// #ifdef DLGWITHTOOLTIP_LOADRESOURCE
};

}	// namespace Dialog

#endif
