#pragma once

#define ARRAY_SIZE(x)	(sizeof(x)/sizeof((x)[0]))

namespace GenericUtility {

	/**
	 * W[fBNg擾.
	 */
	std::wstring GetModuleDir();

	/**
	 * ݒt@CpX擾.
	 *iW[fBNg̒̎wt@C̃t@Cj
	 */
	std::wstring GetStorageFilename(const std::wstring& strFilename);

	/**
	 * t@C݂邩ǂ擾.
	 */
	bool FileExists(const std::wstring& filename);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * 񃊃\[X擾.
	 */
	CString LoadStringRes(UINT uID);

	/**
	 * Zp[^ŋ؂ĘA.
	 */
	CString ConcatenateStrings(const std::vector<CString>& strings, const CString& sep);

	/**
	 * Lȃt@CpXǂ擾.
	 */
	bool IsValidFilePath(LPCTSTR lpszFilePath);
	/**
	 * ׂĂLȃt@CpXǂ擾.
	 */
	bool AreValidFilePaths(const std::vector<CString>& filePaths);

	/**
	 * L[Ă邩ǂ擾.
	 */
	bool IsKeyPressed(int nVertKey);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * Tokenizer ̌ʂ vector<string> Ŏ擾.
	 */
	template <typename Tokenizer>
	std::vector<typename Tokenizer::value_type> GetTokens(Tokenizer& tokens)
	{
		std::vector<typename Tokenizer::value_type> ret;

		for (Tokenizer::iterator it = tokens.begin(); it != tokens.end(); ++it) {
			ret.push_back(*it);
		}

		return ret;
	}

	/**
	 * Zp[^ <sep>  tokenize .
	 */
	template <typename String>
	std::vector<String> TokenizeByChar(const String& str, const typename String::value_type* sep)
	{
		typedef boost::char_separator<String::value_type> Separator;
		typedef boost::tokenizer<Separator, String::const_iterator, String> Tokenizer;
		return GetTokens(Tokenizer(str, Separator(sep)));
	}

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * XĝׂĂ̍ڂI.
	 */
	void ListCtrl_SelectAllItems(CListCtrl& list);

	/**
	 * XĝׂĂ̑I.
	 */
	void ListCtrl_UnselectAllItems(CListCtrl& list);

	/**
	 * XgőIĂŏ̃ACe擾.
	 */
	int ListCtrl_GetSelectedItem(const CListCtrl& list);
	/**
	 * XgőIĂ邷ׂẴACe擾.
	 */
	std::vector<int> ListCtrl_GetAllSelectedItems(const CListCtrl& list);

	/**
	 * Xg̑IĂŏ̍ڂҏW.
	 * IĂȂ΁AȂ.
	 */
	void ListCtrl_EditSelectedLabel(CListCtrl& list);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * RXgN^ Redraw ~AfXgN^ōĊJ.
	 * XgRg[ύXƂȂǂɎgp.
	 * EBhEɑ΂ďd˂Ďgpꍇ́AԊÔ̂LɂȂ.
	 */
	class CSuspendRedraw
	{
	public:
		/**
		 * RXgN^
		 * @param[in] bRedrawOnEnd I RedrawWindow() s邩ǂ
		 *            (CListCtrl ł͂ȂĂ\Ȃ悤ACMFCPropertyGridCtrl Ȃǂł͕Kv)
		 */
		CSuspendRedraw(CWnd* pWnd, bool bRedrawOnEnd = false);
		~CSuspendRedraw();

	private:
		CWnd* m_pWnd;
	};

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * g WaitCursor.
	 *
	 * IuWFNg쐬ƁACWaitCursor Ɠl̂Ƃł.
	 * (RXgN^ŐݒAfXgN^ŉ)
	 *
	 * Begin(), Restore(), End() ́Aʏ WaitCursor ݒ菈.
	 *
	 * ŜƂĎQƃJEgĂāAŌ End() Ƃɖ{ɉ.
	 */
	class CWaitCursorEx
	{
	public:
		/**
		 * WaitCursor ݒ肷.
		 */
		CWaitCursorEx();
		/**
		 * WaitCursor .
		 */
		~CWaitCursorEx();

		/**
		 * WaitCursor ݒ肷.
		 * @see CWinApp::DoWaitCursor(1)
		 */
		static void Begin();
		/**
		 * WaitCursor 𕜌.
		 * @see CWinApp::DoWaitCursor(0)
		 */
		static void Restore();
		/**
		 * WaitCursor .
		 * @see CWinApp::DoWaitCursor(-1)
		 */
		static void End();

		/**
		 * WaitCursor \ǂ擾.
		 */
		static bool IsWaiting();

	private:
		/// QƃJEg
		static int s_refCount;
	};

	////////////////////////////////////////////////////////////////////////////////

	/**
	 *  COM .
	 * operator& Ŏ擾āAfXgN^ŉ.
	 */
	template <typename T>
	class CAutoCoTaskMem
	{
	public:
		CAutoCoTaskMem() : m_pMem(NULL)
		{
		}
		~CAutoCoTaskMem()
		{
			Release();
		}

		void Release()
		{
			if (m_pMem) {
				::CoTaskMemFree(m_pMem);
				m_pMem = NULL;
			}
		}

		T** operator&()
		{
			// HACK: 擾 (Ll) Ƃz肵Ă
			// HACK: łɏLĂ΁AȂ΂ȂȂ
			ASSERT(!m_pMem);
			Release();
			return &m_pMem;
		}

		operator T*()
		{
			return m_pMem;
		}

	private:
		T* m_pMem;
	};

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * OS o[W.
	 */
	class COSVersion
	{
	public:
		/**
		 * VOgCX^X擾.
		 */
		static const COSVersion& Instance();

	public:
		COSVersion();

		/**
		 * OS ^Cv.
		 */
		enum OSType {
			OST_Unknown,

			OST_95,
			OST_98,
			OST_Me,

			OST_NT,
			OST_2k,
			OST_XP,
			OST_2003,
			OST_Vista,
			OST_7,

			OST_Latest = OST_7,
		};

		/**
		 * OS ^Cv擾.
		 */
		OSType GetOSType() const;

	private:
		/**
		 * NT t@~[ǂ𒲂ׂ.
		 */
		bool IsNTFamily() const;

		/**
		 * OS o[Ww肵o[Wȏォǂ𒲂ׂ.
		 */
		bool CheckVersion(DWORD nMajor, DWORD nMinor) const;

	private:
		/// OS o[W
		OSVERSIONINFO m_vi;
	};

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * tO.
	 * l false.
	 */
	class CFlag
	{
	public:
		CFlag() : m_flag(false) {}

		operator bool() const
		{
			return m_flag;
		}

		/**
		 * tOZbg.
		 * RXgN^ŃZbg (true) āAfXgN^ŉ (false) .
		 * qŎgpꍇAƂOLɂȂ.
		 * qł͂Ȃd˂ĎgƂ͂łȂ.
		 */
		class CAutoFlag
		{
		public:
			CAutoFlag(CFlag& flag) : m_flag(flag)
			{
				// ݒ肳ĂȂ
				if (!m_flag) {
					// ݒ肷
					m_flag.m_flag = true;
					// fXgN^ŉ
					m_unset = true;
				}
				else {
					m_unset = false;
				}
			}
			~CAutoFlag()
			{
				// fXgN^ŉ
				if (m_unset) {
					m_flag.m_flag = false;
				}
			}

		private:
			CFlag& m_flag;
			/// fXgN^ŉ邩ǂ
			bool m_unset;
		};

	private:
		/// tO
		bool m_flag;
	};

}	// namespace GenericUtility
