unit Utils;

interface

uses SysUtils, Classes;

type

   TFileData = class(TObject)
   public
      Time: Integer;
      Size: Integer;
      Attr: Integer;
      Name: TFileName;

      procedure Assign(Data : TSearchRec);
      function IsDirectory : Boolean;
      function IsFile      : Boolean;
      function IsVolume    : Boolean;
   end;

   TFileList = class(TObject)
   private
      List     : TList;
      Dir      : String;
      AttrMask : Integer;
   public
      constructor Create;
      destructor Destroy; override;

      function Count : Integer;
      function Get(i : Integer) : TFileData;
      procedure Calculate(Directory : String);
      procedure SetAttrMask(Mask : Integer);
   end;


implementation
constructor TFileList.Create;
begin
   List     := TList.Create;
   AttrMask := 0;
end;

destructor TFileList.Destroy;
var
   i : Integer;
begin
   for i := 0 to List.Count - 1 do
      TFileData(List.Items[i]).Free;
   List.Free;
end;

function TFileList.Count : Integer;
begin
   Count := List.Count;
end;

function TFileList.Get(i : Integer) : TFileData;
begin
//   if i < List.Count then
//   begin
      Get := List.Items[i]
//   end;
end;

procedure TFileList.SetAttrMask(Mask : Integer);
begin
   AttrMask := Mask;
end;

procedure TFileList.Calculate(Directory : String);
var
   Rec : TFileData;
   SearchRec : TSearchRec;
begin

   //
   List.Clear;
   Dir := Directory;
   if FindFirst(Dir, AttrMask, SearchRec) = 0 then // success
   begin
      // add record
      Rec := TFileData.Create;
      Rec.Assign(SearchRec);
      List.Add(Rec);

      while FindNext(SearchRec) = 0 do
      begin
         Rec := TFileData.Create;
         Rec.Assign(SearchRec);
         List.Add(Rec);
      end;
      FindClose(SearchRec);

   end;

end;

//////////////////////////////////////////////////
//////////////////////////////////////////////////
//////////////////////////////////////////////////

procedure TFileData.Assign(Data : TSearchRec);
begin
   Name := Data.Name;
   Time := Data.Time;
   Size := Data.Size;
   Attr := Data.Attr;
end;

function TFileData.IsDirectory : Boolean;
begin
   if (Attr and faDirectory) = faDirectory then
   begin
      Result := True;
   end
   else
   begin
      Result := False;
   end;
end;

function TFileData.IsVolume : Boolean;
begin
   if (Attr and faVolumeID) = faVolumeID then
   begin
      Result := True;
   end
   else
   begin
      Result := False;
   end;
end;

function TFileData.IsFile : Boolean;
begin
   if (not IsDirectory) and (not IsVolume) then
   begin
      Result := True;
   end
   else
   begin
      Result := False;
   end;
end;

end.
