unit about;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls;

type
  TAboutBox = class(TForm)
    OKButton: TButton;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Panel1: TPanel;
    ProductName: TLabel;
    Version: TLabel;
    Copyright: TLabel;
    Comments: TLabel;
    TabSheet2: TTabSheet;
    Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Button1: TButton;
    Panel2: TPanel;
    ProgramIcon: TImage;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Label2Click(Sender: TObject);
    procedure Label2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Label2MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormCreate(Sender: TObject);
    procedure Label5Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  type lplp = ^Pointer;

function GetFileVersionInfoSize2(lptstrFilename: PAnsiChar; lpdwHandle: LPDWORD): DWORD; stdcall;
function GetFileVersionInfo2(lptstrFilename: PAnsiChar; dwHandle : DWORD; dwLen: DWORD; lpData: Pointer): BOOL; stdcall;
function VerQueryValue2(pBlock: Pointer; lpSubBlock: PAnsiChar; lplpBuffer: lplp; puLen: pUINT): BOOL; stdcall;

var
  AboutBox: TAboutBox;

implementation

uses ShellAPI, ex2explore, Dialogs;

{$R *.DFM}

const
  version   = 'version.dll';

function VerQueryValue2; external version name 'VerQueryValueA';
function GetFileVersionInfoSize2; external version name 'GetFileVersionInfoSizeA';
function GetFileVersionInfo2; external version name 'GetFileVersionInfoA';


procedure TAboutBox.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TAboutBox.Label2Click(Sender: TObject);
begin
   ShellExecute(Handle, 'open', PChar(TLabel(Sender).Caption), nil, nil, SW_SHOWNORMAL)
end;

procedure TAboutBox.Label2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   TLabel(Sender).Font.Color := clRed;
end;

procedure TAboutBox.Label2MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   TLabel(Sender).Font.Color := clBlue;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
   Version.Caption := 'Version ' + Explore2fsVersion;
   Memo1.Text := '';
   Memo1.Lines.Add('explore2fs, the Linux file system utiltiy for Windows NT Copyright (C) 2000 John Newbigin');
   Memo1.Lines.Add('');
   Memo1.Lines.Add('This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.');
   Memo1.Lines.Add('');
   Memo1.Lines.Add('This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.');
   Memo1.Lines.Add('');
   Memo1.Lines.Add('You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.');

   Memo1.WordWrap := True;

end;
{
    explore2fs, the Linux file system utiltiy for Windows NT
    Copyright (C) 1998  John Newbigin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

procedure TAboutBox.Label5Click(Sender: TObject);
var
   URL : String;
begin
   URL := 'mailto:' + TLabel(Sender).Caption;
   ShellExecute(Handle, 'open', PChar(URL), nil, nil, SW_SHOWNORMAL)
end;



end.

