unit saving;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, BetterProgressBar;

type
  TSavingDlg = class(TForm)
    CancelBtn: TButton;     
    Bevel1: TBevel;
    Label1: TLabel;
    FileName: TLabel;
    FileProgressBar: TBetterProgressBar;
    DirProgressBar: TBetterProgressBar;
    procedure FormCreate(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Cancel : Boolean;

    procedure Display(FileCount : ULong);
    procedure SetFile(Name : String; Size : ULong);
    procedure FileStep;
    procedure AddFiles(Count : ULong);
  end;

var
  SavingDlg: TSavingDlg;

implementation

{$R *.DFM}

procedure TSavingDlg.FormCreate(Sender: TObject);
begin
   Cancel := False;
end;

procedure TSavingDlg.CancelBtnClick(Sender: TObject);
begin
   Cancel := True;
end;

procedure TSavingDlg.Display(FileCount : ULong);
begin
   DirProgressBar.Range       := FileCount;
//   DirProgressBar.Max       := FileCount;
   DirProgressBar.LPosition   := 0;
//   DirProgressBar.Position   := 0;
   DirProgressBar.Step        := 1;
   if FileCount > 1 then
   begin
      DirProgressBar.Visible     := True;
   end;
   Show;
   Repaint;
end;

procedure TSavingDlg.SetFile(Name : String; Size : ULong);
begin
   FileName.Caption := Name;
   FileProgressBar.Range      := Size;
//   FileProgressBar.Max      := Size;
   FileProgressBar.LPosition  := 0;
//   FileProgressBar.Position  := 0;
   FileProgressBar.Step       := 1;

   if DirProgressBar.Visible then
   begin
      DirProgressBar.StepIt;
   end;
   Repaint;
end;

procedure TSavingDlg.FileStep;
begin
   FileProgressBar.StepIt;
end;

procedure TSavingDlg.AddFiles(Count : ULong);
begin
   DirProgressBar.Range    := DirProgressBar.Range + LongInt(Count);
//   DirProgressBar.Max      := DirProgressBar.Max + Count;
   DirProgressBar.Visible  := True;    
end;

end.
