package map.data;

import java.awt.Color;

/**
 * メッシュ標高
 * @author ma38su
 */
public class Mesh {
	public static final int SIZE = 2000;
	private final int x;
	private final int y;
	private final int height;
	private final Color color;
	public Mesh (int x, int y, int height) {
		this.x = x;
		this.y = y;
		this.height = height;
		float n = (float)height / 5000;
		this.color = Color.getHSBColor(0.46f - n * 0.7f, 0.8f, 1 - n);
	}
	public int getX() {
		return this.x;
	}
	public int getY() {
		return this.y;
	}
	public int getHeight() {
		return this.height;
	}
	public Color getColor() {
		return this.color;
	}
	public double distance (int x, int y) {
		long dx = this.x - x;
		long dy = this.y - y;
		return Math.sqrt(dx * dx + dy * dy);
	}
	@Override
	public boolean equals(Object o) {
		Mesh m = (Mesh)o;
		return (this.x == m.getX() && this.y == m.getY());
	}
}
