package map.labeling;

import java.awt.Graphics2D;
import java.awt.Rectangle;

import map.data.Label;

/**
 * そのままの位置にラベルを配置する
 * @author ma38su
 *
 */
public class DefaultLabeling implements Labeling {
	private final Graphics2D g;
	private final Rectangle screen;
	private final float scale;
	private final int height;
	public DefaultLabeling(final Graphics2D g, final Rectangle screen, final int height, final float scale) {
		this.scale = scale;
		this.g = g;
		this.screen = screen;
		this.height = height;
	}
	public void add(final Label[] label) {
		for(Label data : label) {
			int x = (int) ((data.getX() - this.screen.x) * this.scale);
			int y = this.height - (int) ((data.getY() - this.screen.y) * this.scale);

			this.g.fillOval(x - 2, y - 2, 4, 4);
			this.g.drawString(data.getName(), x + 2, y - 2);
		}
	}
	/**
	 * 不要
	 */
	public void draw() {
	}
}
