package map.map25000.cell;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * セルによる領域検索
 * @author ma38su
 *
 */
public class CellSearch {
	/**
	 * 都道府県セル
	 */
	private final Prefecture[] prefecture;
	/**
	 * コンストラクタ
	 * @param file
	 * @throws IOException
	 */
	public CellSearch(String file) throws IOException {
		BufferedReader bi = null;
		try {
			bi = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file), "SJIS"));
			this.prefecture = new Prefecture[47];
			while(bi.ready()) {
				String[] param = bi.readLine().split(",");
				int code = Integer.parseInt(param[0]);
	
				this.prefecture[code - 1] = new Prefecture(code, param);
			}
		} finally {
			if (bi != null) {
				bi.close();
			}
		}
	}
	/**
	 * 都道府県番号を取得する
	 * @param rectangle 検索範囲
	 * @return 検索範囲と重なる都道府県の番号
	 */
	public Set<Integer> searchPrefectureCode(Rectangle rectangle) {
		Set<Integer> codes = new HashSet<Integer>();
		for(Prefecture cell : this.prefecture) {
			if(rectangle.intersects(cell)) {
				codes.add(cell.getCode());
			}
		}
		return codes;
	}
	/**
	 * 都道府県番号と市区町村番号を取得する
	 * @param rectangle 検索範囲
	 * @return 検索範囲と重なる都道府県番号と市区町村番号
	 * @throws IOException 
	 */
	public Map<Integer, Set<Integer>> search(Rectangle rectangle) throws IOException {
		Map<Integer, Set<Integer>> code = new HashMap<Integer, Set<Integer>>();
		for(Prefecture cell : this.prefecture) {
			if(rectangle.intersects(cell)) {
				cell.productCell();
				code.put(cell.getCode(), cell.search(rectangle));
			}else{
				cell.dump();
			}
		}
		return code;
	}
	/**
	 * 市区町村番号を取得する
	 * @param rectangle 検索範囲
	 * @return 検索範囲と重なる市区町村の番号
	 * @throws IOException 
	 */
	public Set<Integer> searchCityCode(Rectangle rectangle) throws IOException {
		Set<Integer> codes = new HashSet<Integer>();
		for(Prefecture cell : this.prefecture) {
			if(rectangle.intersects(cell)) {
				cell.productCell();
				cell.search(codes, rectangle);
			}else{
				cell.dump();
			}
		}
		return codes;
	}
}