/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.gcat.scalc;

import jp.jasminesoft.gcat.scalc.DMSconv;
import jp.jasminesoft.gcat.scalc.LatLong2XY;
import jp.jasminesoft.gcat.scalc.XY2LatLong;
import jp.jasminesoft.xmlcat.MBR;

public class Converter {
    public static MBR latlong2xy(MBR mbr) {
        return Converter.latlong2xy(mbr, -1);
    }

    public static MBR latlong2xy(MBR mbr, int kei) {
        LatLong2XY conv = new LatLong2XY(kei);
        conv.setLongitude(mbr.getSX());
        conv.setLatitude(mbr.getSY());
        float sx = (float)conv.getX();
        float sy = (float)conv.getY();
        conv.setLongitude(mbr.getEX());
        conv.setLatitude(mbr.getEY());
        float ex = (float)conv.getX();
        float ey = (float)conv.getY();
        return new MBR(sx, sy, ex, ey);
    }

    public static MBR xy2latlong(MBR mbr, int kei) {
        if (kei < 1 || kei > 19) {
            return null;
        }
        XY2LatLong conv = new XY2LatLong(kei);
        conv.setX(mbr.getSX());
        conv.setY(mbr.getSY());
        float sx = (float)conv.getLongitude();
        float sy = (float)conv.getLatitude();
        conv.setX(mbr.getEX());
        conv.setY(mbr.getEY());
        float ex = (float)conv.getLongitude();
        float ey = (float)conv.getLatitude();
        return new MBR(sx, sy, ex, ey);
    }

    public static MBR toAngle(MBR mbr) {
        return new MBR(DMSconv.deg2dms(mbr.getSX()), DMSconv.deg2dms(mbr.getSY()), DMSconv.deg2dms(mbr.getEX()), DMSconv.deg2dms(mbr.getEY()));
    }

    public static void main(String[] args) {
        MBR mbr = new MBR(0.0f, 0.0f, 10000.0f, 10000.0f);
        System.out.println(mbr);
        MBR mbr2 = Converter.xy2latlong(mbr, 1);
        System.out.println(mbr2);
        MBR mbr3 = Converter.toAngle(mbr2);
        System.out.println(mbr3);
        MBR mbr4 = Converter.latlong2xy(mbr3, 1);
        System.out.println(mbr4);
    }
}

