/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.gcat.scalc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jp.jasminesoft.gcat.scalc.MeshInfo;
import jp.jasminesoft.gcat.scalc.MeshParameter;

public class MeshCodeManager {
    private static MeshCodeManager _instance;
    private String paramfile = "mesh.info";
    private String enc = "SJIS";
    private static Hashtable meshMap;

    private MeshCodeManager() {
        meshMap = MeshParameter.map;
    }

    public static synchronized MeshCodeManager getInstance() {
        if (_instance == null) {
            _instance = new MeshCodeManager();
        }
        return _instance;
    }

    public void setParameterFilename(String paramfile) {
        this.paramfile = paramfile;
    }

    public String getParameterFilename() {
        return this.paramfile;
    }

    public void setParameterFileEncoding(String enc) {
        this.enc = enc;
    }

    public String getParameterFileEncoding() {
        return this.enc;
    }

    /*
     * Loose catch block
     */
    public void loadParameter() {
        block12: {
            File f = new File(this.paramfile);
            if (!f.exists()) {
                System.err.println(this.paramfile + " is not found.");
                return;
            }
            meshMap = new Hashtable();
            BufferedReader in = null;
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.paramfile), this.enc));
            String line = null;
            while ((line = in.readLine()) != null) {
                this.addLine(line);
            }
            Object var6_5 = null;
            try {
                in.close();
            }
            catch (Exception ex) {}
            break block12;
            {
                catch (UnsupportedEncodingException e) {
                    System.err.println(this.enc + " is not supported encoding.");
                    Object var6_6 = null;
                    try {
                        in.close();
                    }
                    catch (Exception ex) {}
                    break block12;
                }
                catch (IOException e) {
                    System.err.println(e.getMessage());
                    Object var6_7 = null;
                    try {
                        in.close();
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    in.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void addLine(String line) {
        StringTokenizer st = new StringTokenizer(line, ",");
        int meshCode = 0;
        String name = null;
        int kei = -1;
        if (st.hasMoreTokens()) {
            try {
                try {
                    meshCode = Integer.parseInt(st.nextToken());
                    name = st.nextToken();
                    kei = Integer.parseInt(st.nextToken());
                    meshMap.put(new Integer(meshCode), new MeshInfo(meshCode, name, kei));
                }
                catch (Exception e) {
                    System.err.println("Error: " + line);
                    Object var8_7 = null;
                    meshCode = 0;
                    name = null;
                    kei = -1;
                }
                Object var8_6 = null;
                meshCode = 0;
                name = null;
                kei = -1;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                meshCode = 0;
                name = null;
                kei = -1;
                throw throwable;
            }
        }
    }

    public MeshInfo getMeshInfo(int meshCode) {
        return (MeshInfo)meshMap.get(new Integer(meshCode));
    }

    public Enumeration keys() {
        return meshMap.keys();
    }

    public boolean isReady() {
        return meshMap != null && meshMap.size() > 0;
    }

    public int getProperKei(double lat, double lng) {
        int b = (int)((double)((int)lat) * 1.5);
        int l = (int)lng - 100;
        String key_str = Integer.toString(b) + Integer.toString(l);
        int key = new Integer(key_str);
        MeshInfo minfo = this.getMeshInfo(key);
        if (minfo != null) {
            return minfo.getKei();
        }
        return 0;
    }

    public static void main(String[] argv) {
        MeshCodeManager mcman;
        int meshCode = 5339;
        if (argv.length > 0) {
            meshCode = Integer.parseInt(argv[0]);
        }
        if (!(mcman = MeshCodeManager.getInstance()).isReady()) {
            mcman.setParameterFilename("./lib/mesh.info");
            mcman.setParameterFileEncoding("SJIS");
            System.out.print("loading parameter...");
            mcman.loadParameter();
            System.out.println("done.");
        }
        MeshInfo minfo = mcman.getMeshInfo(meshCode);
        System.out.println(minfo);
    }
}

