package database;
import java.io.Serializable;

class Pointer implements Serializable {
	int pointer;
	public Pointer(String str) {
		this.pointer = Integer.parseInt(str);
	}
	public Pointer(long pointer) {
		this.pointer = (int) (pointer % Integer.MAX_VALUE);
	}

	public Pointer() {
	}
	
	void setPointer(int p) {
		this.pointer = p;
	}
	
	@Override
	public String toString() {
		return Integer.toString(this.pointer);
	}
    /**
     * Integer のハッシュコードを返します。
     * 
     * @return  このオブジェクトのハッシュコード値。この Integer
     *          オブジェクトが表すプリミティブ型 int 値に等しい
     */
    @Override
	public int hashCode() {
        return this.pointer;
    }
    
    /**
     * このオブジェクトを指定されたオブジェクトと比較します。結果が true
     * になるのは、引数が null ではなく、このオブジェクトと
     * 同じ int 値を含む Integer オブジェクトである
     * 場合だけです。
     * 
     * @param   obj 比較対象のオブジェクト
     * @return  オブジェクトが同じである場合は true、そうでない場合は
     *          false
     */
    @Override
	public boolean equals(Object obj) {
        if (obj instanceof Integer) {
            return this.pointer == ((Integer) obj).intValue();
        } else if (obj instanceof Pointer) {
        	return this.pointer == ((Pointer) obj).pointer;
        }
        return false;
    }
}
