package map.model;


/**
 * 道路区間
 * @author ma38su
 */
public class Road extends Curve {
	private static boolean useHighway = true;
	public static void switchHighway() {
		Road.useHighway = !Road.useHighway;
	}
	public static boolean useHighway() {
		return Road.useHighway;
	}
	/**
	 * 高速道路に対する一般道の比
	 */
	public static final float GENERAL_RATE = 1.3f;
	private final float cost;
	/**
	 * 道路種別
	 * type = 16 - 13 高速道路
	 *        15 - 13 一般道
	 *        14 - 13 石段
	 *        13 - 13 庭園
	 */
	private final int width;

	public Road() {
		super(null, null, 0);
		this.cost = 0;
		this.width = 0;
	}
	public Road(int[] aryX, int[] aryY, int type, int width, float cost) {
		super(aryX, aryY, type);
		assert aryX.length == aryY.length;
		this.cost = cost;
		this.width = width;
	}
	public Road(int type, int width, float cost) {
		super(null, null, type);
		this.cost = cost;
		this.width = width;
	}
	/**
	 * 幅員を取得
	 * 0 - 5
	 * @return 幅員
	 */
	public int getWidth() {
		return this.width;
	}
	public float getCost() {
		return this.cost;
	}
}