package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;


public class Setting implements Serializable {

	/**
	 * 設定を読み込みます。
	 * 設定ファイルが存在しない場合は、新たに作成します。
	 * @param dir 
	 * @return 設定
	 */
	public static Setting readSetting(String dir) {
		ObjectInputStream bo = null;
		Setting setting = null;
		File file = new File(dir + "setting.obj");
		try {
			try {
				bo = new ObjectInputStream(new FileInputStream(file));
				setting = (Setting) bo.readObject();
			} finally {
				if (bo != null) {
					bo.close();
				}
			}
		} catch (Exception e) {
			if (file.exists()) {
				file.delete();
			}
			setting = null;
		}
		if (setting == null) {
			setting = new Setting();
		}
		setting.setFile(file);
		return setting;
	}

	private boolean isCheckUpdate;
	
	/**
	 * 設定の保存先
	 */
	private transient File file;
	
	private Setting() {
		this.isCheckUpdate = true;
		this.isManualVisible = true;
	}
	
	private void setFile(File file) {
		this.file = file;
	}
	
	public boolean isCheckUpdate() {
		return this.isCheckUpdate;
	}

	/**
	 * 
	 * @param flag 更新情報
	 */
	public void setCheckUpdate(boolean flag) {
		this.isCheckUpdate = flag;
		this.write();
	}

	/**
	 * 操作マニュアルの表示フラグ
	 */
	private boolean isManualVisible;

	/**
	 * マニュアルの表示・非表示を切り替えます。
	 */
	public void switchManualVisible() {
		this.isManualVisible = !this.isManualVisible;
		this.write();
	}
	
	/**
	 * マニュアルの表示
	 * @return マニュアルを表示するならtrue
	 */
	public boolean isManual() {
		return this.isManualVisible;
	}
	
	/**
	 * 設定を保存します。
	 * @return 保存に成功すればtrue
	 */
	public boolean write() {
		try {
			ObjectOutputStream bo = null;
			try {
				bo = new ObjectOutputStream(new FileOutputStream(this.file));
				bo.writeObject(this);
			} finally {
				if (bo != null) {
					bo.close();
				}
			}
		} catch (IOException e) {
			if (this.file.exists()) {
				this.file.delete();
			}
			Log.err(this, e);
			return false;
		}
		return true;
	}
}
